label scenario_example:
    outfit john casual
    scene example_bg street night
    show john a_0 at center
    with dissolve

    if _scenario:
        john "Hah! You came from the main storyline! Anyways, let's get on with it..."

    show john a_1
    john "Hey there! I'm going to explain how to actually {i}make{/i} scenarios."

    show john a_0
    john "I swear to you  that it's a whole lot simpler than it seems."

    show john a_4
    john "Attempting to use a new system like Ren'Py can be daunting, especially when there's a lot more bells and whistles added on like morphing and swapping animations."

    show john a_0
    john "But luckily, creating scenarios for Student Transfer is pretty easy."

    show example_bg scenario_mode with dissolve
    show john at centerright, faceleft with ease
    show example_bg scenario_mode dark with dissolve
    show example_asset arrow as arrow with dissolve:
        zoom 0.3
        xalign 0.46
        yalign 0.32
        ease 0.4 yalign 0.28
    john "To begin, simply press the {q}+ New Scenario{/q} button in the main Scenario Mode window."

    show john a_8
    john "This will create a new template for you to edit, set up with a minimal working example."

    john "The game will open the folder for you, but in case you want to find the files yourself, they are stored in the game/scenarios folder of Student Transfer."

    scene example_bg street night
    show john a_0 at centerright, faceleft
    with dissolve

    john "In there, you will find '.rpy' files along with '.rpyc' files. The '.rpyc' files are created from the '.rpy' files when the game launches, and you can safely ignore them."

    john "The real meat of any scenario is in its '.rpy' files. You can use any plaintext editor to edit them--"

    show example_eliza a_1 at centerleft with easeinleft
    example_eliza "I personally recommend you use {a=https://code.visualstudio.com}Visual Studio Code{/a}, along with the {a=https://marketplace.visualstudio.com/items?itemName=LuqueDaniel.languague-renpy}Ren'Py addon{/a}."

    show example_eliza a_0
    example_eliza "In general, most text editors that support plug-ins also have one for Ren'Py available. If you are not comfortable using VS Code, you can also take a look at {a=https://www.sublimetext.com}SublimeText{/a} or {a=http://brackets.io}Brackets{/a}."

    show example_eliza at faceleft
    pause 0.2
    hide example_eliza with easeoutleft
    show john a_8
    john "You can find even more suggestions and helpful tips on the {a=https://www.renpy.org/}Ren'Py Website{/a}."

    show john a_6
    john "You can even use something like Windows Notepad to open and edit files, though that can get old very fast."

    show john a_0
    john "If you open the story file for this scenario, which you can find under the {q}story{/q} folder, titled 'example.rpy', you'll see that it's written sort of like the script to a play."

    john "If you write something like--"

    show john at right with ease
    show john at faceleft with dissolve
    show example_asset demo_1 no_edges as code_1:
        alpha 0.0
        xalign 0.5
        yalign 0.6
        easein 0.4 yalign 0.5 alpha 1.0
    pause 0.4
    show john a_0
    john "--then I'll say it. Watch me do it now!"

    show john a_3
    john "It is surprisingly straightforward!"

    show john a_0
    show example_asset arrow as arrow:
        zoom 0.3
        alpha 0.0
        xalign 0.25
        yalign 0.597
        easein 0.2 alpha 1.0
    john "You just use the relevant name to get someone to say stuff, which is almost always their first name in lower case."

    john "Above that there's usually stuff like--"

    show example_asset demo_1 high_edges as code_1
    show example_asset demo_2 low_edges as code_2 behind code_1:
        alpha 0.0
        xalign 0.5
        yalign 0.5
        easein 0.4 yalign 0.44 alpha 1.0
    show example_asset arrow as arrow:
        alpha 1.0
        parallel:
            ease 0.4 rotate 90
        parallel:
            ease 0.4 xalign 0.171
        parallel:
            ease 0.4 yalign 0.435
    john "--as well."

    show example_asset arrow as arrow:
        xalign 0.171
        yalign 0.435
        rotate 90
        parallel:
            ease 0.4 rotate 180
        parallel:
            ease 0.4 xalign 0.368
        parallel:
            ease 0.4 yalign 0.33
    john "How that works is the 'a' stands for which pose the character is in while the number says which expression shows on their face."

    show example_asset arrow as arrow:
        xalign 0.368
        yalign 0.33
        rotate 180
        ease 0.2 xalign 0.4
    show example_asset demo_3 low_edges as code_2 with dissolve
    show john a_1
    john "So a_1 is happy."

    show example_asset demo_4 low_edges as code_2 with dissolve
    show john a_2
    john "And a_2 is sad."

    show example_asset arrow as arrow:
        xalign 0.4
        ease 0.3 xalign 0.458
    show example_asset demo_5 low_edges as code_2 with dissolve
    show john a_1 blush
    john "While something like 'a_1 blush' results in me making the 'a_1' face while blushing."

    show john a_0
    john "And so on. Some characters only have one pose, so they'll only use pose 'a' while others will have a pose 'b' and sometimes even a pose 'c' as well."

    show example_asset arrow as arrow:
        xalign 0.458
        ease 0.4 xalign 0.6
    john "Also, side note, you'll always want to place characters with an explicit location like the one in the above example, otherwise they'll float in the center because nobody has actual legs."

    hide arrow with dissolve
    show john a_1
    john "This becomes important when you're using the built-in body swap command in Student Transfer. Our programming team made it themselves!"

    show john a_6
    john "But to demonstrate the body swap command and how pose {q}b{/q} works, I'll need a volunteer."

    john "Let's also get rid of this code..."

    hide code_1
    hide code_2
    with dissolve

    show john a_0 at centerright, faceleft with ease
    show leona a_1 at centerleft with easeinleft
    leona "You needed me to demonstrate pose {q}b{/q} for the audience?"

    show john a_1
    john "Yup!"

    show john a_0
    john "Technically I have a b pose as well, but let's keep the spoilers out of the tutorial for now."

    show john a_0
    show example_asset demo_6 no_edges as code_1:
        alpha 0.0
        xalign 0.5
        yalign 0.6
        easein 0.4 yalign 0.5 alpha 1.0
    john "The complete swap command looks like this."

    show example_asset demo_6 no_edges highlight_1 as code_1 with dissolve:
        alpha 1.0
        yalign 0.5
    john "The first part of the expression is how you start..."

    show example_asset demo_6 no_edges highlight_2 as code_1 with dissolve
    john "...the second is how you end up."

    show john a_8
    hide code_1 with dissolve
    john "If we try it now, you'll see us swapping bodies, with our ghosts transferring between us. Watch closely!"

    swap john a_0 : a_1, leona a_1 : a_0

    leona "When you swap bodies, you also swap expression banks, so you have to use the expressions that are native to the body and not the person."

    john "Now that I'm in Ms. Winter's body, I can make her {q}b{/q} expression by putting {q}show john b_1{/q} above my text."

    show example_asset demo_1 high_edges as code_1:
        xalign 0.5
        yalign 0.5
    show example_asset demo_7 low_edges as code_2:
        xalign 0.5
        yalign 0.44
    with dissolve
    john "In the example from before, it could look like this. Which would result in the following..."

    hide code_1
    hide code_2
    with dissolve
    show john b_1 with dissolve
    john "It is surprisingly straightforward!"

    show leona a_2
    leona "And if you try to make somebody perform a {q}b{/q} pose while in a body that doesn't have one, the game will reject it!"

    show john a_1
    john "There are other things, like how to set the backgrounds, the morph command, changing outfits, and so on. You should refer to the official {a=https://docs.student-transfer.com/scenario_guide/intro.html}scenario guide{/a} if you want to learn about the more complex things you can do."

    show leona a_8
    leona "Pretty much anything else you can find in the {a=https://www.renpy.org/doc/html/}Ren'Py documentation{/a}, which is a comprehensive guide on all the standard things Ren'Py can do, e.g. stuff like transitions, how we both moved earlier, text effects, and much more can all be found there."

    show leona a_6
    leona "The Ren'Py program's example game also contains some useful information. And if you want you can also take a look at the code for this scenario."

    show john a_4
    john "Making your own scenario is as easy as creating a new scenario story file and turning it into something you like."

    show leona a_0
    leona "In the folder of your scenario you will find a {q}scenario.yml{/q} file. There you can set some meta-data about your scenario, like the title, description, version and the author's name."

    leona "Please take care that the {q}label{/q} field corresponds to the label you use in the story file."

    show john a_1 with dissolve
    john "Sending us the scenario is as easy as hitting the {q}Export{/q} button on your scenario and sending us the produced file."

    john "Scenarios can be about whatever you want. Our first submission was a random MediaFire drive-by and involved a totally new story with no bearing on our regular canon."

    show john a_4
    john "And that's all for now! Good luck!"

    show leona a_1
    leona "See you around!"

    show example_eliza a_1 at left, faceright with st_easeinleft(0.2)
    example_eliza "Smoke Bomb!{w=0.2}{nw}"
    scene black with Dissolve(0.2)

    # Movies are available either as a Movie displayable:
    # show example_movie_fire:
    #     size (1280, 720)
    #     pause 5
    #     ease 0.5 alpha 0.0

    # Or as a variable containing the filename:
    $ renpy.movie_cutscene(example_movie_fire)
