label bj2options: #This is the .rpy file that stores the dialogue of the options menu and a few other miscellaneous spots.
    scene black with fade
    play music bgm_awkward_meeting fadein 1.5
    show circe a_0 at center
    $optionsmenu = True #Set a flag to show we're in the Options navigation.
    if persistent.first is None: #This is a persistent variable to check if we've visited the menu before. It's permanently set to True after this.
        $persistent.first = True
    if persistent.name is None: #This is a persistent variable to set the player's name to a default. If the player played far enough into Blackjack I, this triggers additional dialogue.
        $persistent.name = "squirt"
    if persistent.first == True and persistent.name!= "squirt": #The game checks whether this scene has been viewed and if the player has a unique name.
        show circe a_28
        circe "Hey, [persistent.name]. What a pleasant surprise! It's been a long time. How have you been?" #We can use the variable name like so to directly address the player.
        show circe a_25
        circe "I hope you're itching for some more Blackjack. This new one can actually be kinda tough with the difficulty ticked up."
        show circe a_6
        circe "Anyway, I don't think I'm going to be in this one. What a bummer, right?"
        show circe a_13
        circe "Oh well, you can always visit me in the options menu or the previous game."
        show circe a_14
        circe "Either way, I'll be seeing you around, [persistent.name], my faithful servant."
        $persistent.first = False #After viewing the scene, this variable is permanently set to False. It will not be viewed again until data is cleared.
    label bj2options2: #An additional label is created here to jump back to later.
    show circe a_0
    show circe a_0
    menu:
        circe "What can I do for ya, [persistent.name]?"
        "Play a Challenge.":
            circe "Challenges are one-offs unrelated to the main story. You'll unlock another once the story reaches its completion."
            menu challenges: #Note we can have a menu within a menu to create submenus. There is no limit to these submenus, but too many can make your code hard to read.
                "Riley's Wish":
                    jump rileytime
                "Kiyoshi's Folly."  if persistent.kiyoshi == True: #This checks for a special variable that demonstrates the player has cleared the main game.
                    jump kiyoshitime
                "Raines' Hell" if "kiyoshiwins" in persistent.specialend: #This checks for a special variable that shows the player has won the Kiyoshi challenge.
                    jump rainestime
                "Back...":
                    jump bj2options2 #Returns to the past part of the menu. That's why we created the label there!
        "Toggle Difficulty.":
            circe "The difficulty is currently set to [persistent.difficulty]. On easy difficulty, Patty will raise when you raise, and she will
            also always raise with a hand of 18 or greater. This makes the game easier and much quicker, but not very realistic."
            circe "On medium difficulty, Patty will attempt to raise, call, and fold intelligently. She's also harder to read. It's a tougher yet
            more realistic Blackjack experience."
            circe "Bear in mind, Patty plays by dealer rules either way. She will only hit on a hand of 16 or lower. In fact, she must!"
            menu:
                circe "Which would you prefer?"
                "Easy.":
                    $persistent.difficulty = "easy"
                    circe "Okay, you're now on [persistent.difficulty] mode. Have fun, but more importantly, good luck!"
                    jump bj2options2
                "Medium.":
                    $persistent.difficulty = "medium"
                    circe "Okay, you're now on [persistent.difficulty] mode. Have fun, but more importantly, good luck!"
                    jump bj2options2
        "Toggle Nudity.":
            show circe a_3
            circe "Yeah, yeah. of course there's nudity in this game, you little pervert, you. There's a small chance that when you transform
            from a joker, your girl will be wearing little or no clothes at all."
            menu:
                circe "You want nudity on, right?"
                "Keep nudity on.":
                    show circe a_5
                    circe "Ahaha, yes! I knew it!"
                    $persistent.nudity = True #This is a variable checked on during the transformation sequence. If set to False, "Nude" outfits will not be chosen.
                    jump bj2options2
                "Turn nudity off.":
                    show circe a_15
                    circe "Aww, what a pity. I'm sure you have your reasons, though."
                    show circe a_14
                    circe "I'll respect your wishes. You won't see any boobs, but watch out for undies!"
                    $persistent.nudity = False
                    jump bj2options2
        "Watch Scenes":
            show circe a_15
            circe "Finding scenes to rewatch can be a pain, right?"
            show circe a_14
            circe "Don't worry kid, I kept a record of them all. Which one do you want to view?"
            jump sceneselection
        "Joker Info" if len (persistent.bodylist)>0: #persistent.bodylist stores all bodies that your character has transformed into during gameplay.
            menu:
                "View Obtained Joker Transformations.":
                    $bodylistcount = len (persistent.bodylist) #This counts all of the bodies in bodylist so it can be shown to the player.
                    circe "Currently, you've seen [bodylistcount] out of 111 possible Joker transformations. Or, 83 if you don't count birthday suits."
                    show circe a_12
                    circe "This doesn't really mean anything, though. If you have over 100, congrats. You're a certified nut. And probably a pervert, too."
                    show circe a_0
                    circe "Here's a list of the ones you have, by the way."
                    $hand_peek = [i[3].capitalize() for i in persistent.bodylist] #This is recycled code from another game, hence the weird variable names.
                    $hand_peek.sort() #This sorts the list alphabetically.
                    $hand_peek1 = ', '.join(hand_peek)
                    $hand_peek2 = [i[4].capitalize() for i in persistent.bodylist]
                    $hand_peek3 = ", ".join(["{}({})".format(x, y) for x,y in zip(hand_peek, hand_peek2)]) #These format the list as a string that is more legible to the user.
                    "[hand_peek3]" #This displays the result.
                    jump bj2options2
                # This option has been commented out since it's not formatted well enough to be useful to the player.
                #"View Joker Stats.":
                    #"[persistent.bjs]" #This shows stats like your win and loss records for each Joker transformation.
                    #jump bj2options2
                "Export Joker Stats.": #This users Python code so your stats can be easily viewed in a .csv file. Great for nerds!
                    python: #Since this will need multiple lines of Python, we use a Python block here.
                        csv_file_path = "joker_stats.csv" #This will be in the same location as the game data, so all we need for the "relative path" is a file name.
                        data = [["Name", "Count", "Wins", "Losses", "Draws", "Net$","Outfits"]] #This defines the rows we will be using.
                        data.extend(persistent.bjs) #This adds all of our data to the csv file.
                        with open(csv_file_path, 'w', newline='') as file: #This saves all of our data to the csv file. Viola!
                            writer = csv.writer(file)
                            writer.writerows(data)
                    circe "Your joker stats have been exported to a csv filed called joker_stats.csv."
                    show circe a_25
                    circe "Enjoy, nerd!"
                    jump bj2options2
                "Return.":
                    jump bj2options2
        "Erase All Progress":
            jump areyoureallysure
        "Return to the game.":
            if persistent.name == "squirt":
                circe "Alright, then. Seeya around!"
            else: #If Circe knows your name from before, she will speak to you more warmly.
                show circe a_13
                circe "Okay, then. Seeya [persistent.name], my faithful servant."
            jump blackjack2

label areyoureallysure:
    show circe a_9
    circe "This will clear ALL of your progress for both endings and your joker transformations. Do you really want to do this?"
    menu:
        "No.":
            show circe a_23
            circe "Good. That's what I thought."
            jump bj2options2
        "Yes.":
            show circe a_12
            circe "Are you super-duper sure? For real? Seriously, you can't undo this!"
    menu: #After a menu choice, the game will automatically advance in code. So, no submenu is necessary here.
        "No.":
            show circe a_25
            circe "Good. You were scaring me for a second, and that's no easy feat."
            jump bj2options2
        "Yes. For Real.": #We only want to delete certain persistent variables, so we specifically only initialize the ones we want to here.
            show circe a_28
            $persistent.goodend = []
            $persistent.badend = []
            $persistent.specialend = []
            $persistent.kiyoshi = False
            $persistent.bodylist = []
            circe "Alright, the deed is done, you absolute maniac."
            jump bj2options2

label sceneselection:
    menu:
        "Jump to prologue.":
            show circe a_7
            circe "Oh, did you enjoy that? Alright, you can watch it again. Have fun..."
            $persistent.sawprologue = None
            jump blackjack2
        "Jump to a good ending." if len(persistent.goodend) > 0: #This will not display if we have not obtained a good ending yet.
            show circe a_9
            circe "Good endings? Yuck, how boring."
            show circe a_4
            circe "Sigh, I did save those ones too. Which one do you fancy to watch?"
            jump goodendselect
        "Jump to a bad ending." if len(persistent.badend) > 0: #This will not display if we have not obtained a bad ending yet.
            show circe a_10
            circe "Bad endings? I gotta admit, [persistent.name], you have good taste."
            show circe a_14
            circe "Which one are we gonna watch next?"
            jump badendselect
        "Jump to a special ending." if len(persistent.specialend) > 0: #Same for special endings.
            show circe a_10
            circe "Special endings? You know these have to be good when these have their own category."
            show circe a_8
            circe "Fancy any of these?"
            jump specialendselect
        "Nevermind.":
            show circe a_2
            circe "Aww, don't get my hopes up like that. I wanna see John suffer!"
            jump bj2options2

label goodendselect:
    $johnwins = True
    menu goodend1:
        "[persistent.goodend[0][1]]" if len (persistent.goodend) > 0: #This displays the name of a good ending as a menu option if it exists.
            $tarot = persistent.goodend[0][0]                         #The Tarot variable is set so that we view the corresponding ending.
        "[persistent.goodend[1][1]]" if len (persistent.goodend) > 1: #Necessary data is read from the list stored at persistent.goodend
            $tarot = persistent.goodend[1][0]
        "[persistent.goodend[2][1]]" if len (persistent.goodend) > 2:
            $tarot = persistent.goodend[2][0]
        "[persistent.goodend[3][1]]" if len (persistent.goodend) > 3:
            $tarot = persistent.goodend[3][0]
        "[persistent.goodend[4][1]]" if len (persistent.goodend) > 4:
            $tarot = persistent.goodend[4][0]
        "More..." if len (persistent.goodend) > 5: #If we have more 5 endings, this takes us to an identical menu where further good endings can be selected.
            jump goodend2
        "Nevermind.":
            show circe a_5
            circe "Awesome! I didn't want to see some sappy good ending, anyway."
            jump bj2options2
    jump playgoodend #After a menu option is selected, we'll jump right to playing the good ending.
    menu goodend2:
        "Back...":
            jump goodend1 #This will return us to the earlier good endings.
        "[persistent.goodend[5][1]]" if len (persistent.goodend) > 5:
            $tarot = persistent.goodend[5][0]
        "[persistent.goodend[6][1]]" if len (persistent.goodend) > 6:
            $tarot = persistent.goodend[6][0]
        "[persistent.goodend[7][1]]" if len (persistent.goodend) > 7:
            $tarot = persistent.goodend[7][0]
        "[persistent.goodend[8][1]]" if len (persistent.goodend) > 8:
            $tarot = persistent.goodend[8][0]
        "[persistent.goodend[9][1]]" if len (persistent.goodend) > 9:
            $tarot = persistent.goodend[9][0]
        "More..." if len (persistent.goodend) > 10: #If we have over 10 endings, we can view them via this option.
            jump goodend3
    jump playgoodend
    menu goodend3:
        "Back...":
            jump goodend2
        "[persistent.goodend[10][1]]" if len (persistent.goodend) > 10:
            $tarot = persistent.goodend[10][0]
        "[persistent.goodend[11][1]]" if len (persistent.goodend) > 11:
            $tarot = persistent.goodend[11][0]
        "[persistent.goodend[12][1]]" if len (persistent.goodend) > 12:
            $tarot = persistent.goodend[12][0]
            $patty.name = "Circe"
        "Return to the options menu.":
            show circe a_5
            circe "Awesome! I didn't want to see some sappy good ending, anyway."
            jump bj2options2

label playgoodend:
    clone john cornelia #John's body is initialized as a clone of Cornelia's to reflect his state in the prologue.
    $x.name = "cornelia" #He is not supposed to be in his original body except for a specific ending, so this serves as a sort of failsafe.
    outfit john casual
    $x = BlackJackBody("cornelia", "uniform", "a_13","casual", "sport","nude", "a_1", "a_2", "a_7", "a_6")
    scene bg city alley day with fade
    show john a_0 at centerleft
    show patty a_0 at centerright
    jump bj2goodend

label badendselect:
    $johnwins = False
    menu badend1:
        "[persistent.badend[0][1]]" if len (persistent.badend) > 0: #This menu functions identically to the good ending select, only we're reading from persistent.badend.
            $tarot = persistent.badend[0][0]
        "[persistent.badend[1][1]]" if len (persistent.badend) > 1:
            $tarot = persistent.badend[1][0]
        "[persistent.badend[2][1]]" if len (persistent.badend) > 2:
            $tarot = persistent.badend[2][0]
        "[persistent.badend[3][1]]" if len (persistent.badend) > 3:
            $tarot = persistent.badend[3][0]
        "[persistent.badend[4][1]]" if len (persistent.badend) > 4:
            $tarot = persistent.badend[4][0]
        "More..." if len (persistent.badend) > 5:
            jump badend2
        "Nevermind.":
            show circe a_21
            circe "Aww, what a bore. Next time, alright?"
            jump bj2options2
    jump playbadend
    menu badend2:
        "Back...":
            jump badend1
        "[persistent.badend[5][1]]" if len (persistent.badend) > 5:
            $tarot = persistent.badend[5][0]
        "[persistent.badend[6][1]]" if len (persistent.badend) > 6:
            $tarot = persistent.badend[6][0]
        "[persistent.badend[7][1]]" if len (persistent.badend) > 7:
            $tarot = persistent.badend[7][0]
        "[persistent.badend[8][1]]" if len (persistent.badend) > 8:
            $tarot = persistent.badend[8][0]
        "[persistent.badend[9][1]]" if len (persistent.badend) > 9:
            $tarot = persistent.badend[9][0]
        "More..." if len (persistent.badend) > 10:
            jump badend3
    jump playbadend
    menu badend3:
        "Back...":
            jump badend2
        "[persistent.badend[10][1]]" if len (persistent.badend) > 10:
            $tarot = persistent.badend[10][0]
        "[persistent.badend[11][1]]" if len (persistent.badend) > 11:
            $tarot = persistent.badend[11][0]
        "[persistent.badend[12][1]]" if len (persistent.badend) > 12:
            $tarot = persistent.badend[12][0]
        "Return to the options menu.":
            show circe a_21
            circe "Aww, what a bore. Next time, alright?"
            jump bj2options2

label playbadend:
    if tarot == "thedevil":
        $patty.name = "Circe" #Circe is taking over for Patty here, so we change her name to keep consistency with this particular route.
    clone john cornelia #Once again, John becomes Cornelia for consistency.
    $x.name = "cornelia"
    outfit john casual
    $x = BlackJackBody("cornelia", "uniform", "a_13","casual", "sport","nude", "a_1", "a_2", "a_7", "a_6")
    scene bg city alley day with fade
    show john a_0 at centerleft
    show patty a_0 at centerright
    jump bj2badend

label specialendselect: #While persistent.specialend also exists, this ending selection screen is done a bit differently.
    $johnwins = True        #The reason for this is there are fewer special endings and they all require John to be in a certain state as they occur.
    menu:
        "John Cheats Himself" if "johnthecheater" in persistent.specialend:
            clone john audrey #Audrey has previously become John in the code. So, this is a trick to revert John to his original form.
            outfit john uniform
            scene bg city alley day
            $x = BlackJackBody("john", "uniform", ("a_0"),"uniform","uniform","uniform","a_0", "a_1", "a_4", "a_9")
            show john a_0 at centerleft
            show patty a_0 at centerright
            jump johncheat
        "Never Go Full Sayaka" if "nevergo" in persistent.specialend:
            clone john sayaka
            stop music
            outfit john casual
            $x = BlackJackBody("sayaka", "uniform", "a_24", "casual","sport", "nude", "a_1","a_2", "a_7","a_8")
            scene bg city alley day
            show john a_0 at centerleft
            show patty a_0 at centerright
            jump fullsayaka
        "Me, Myself, and Zoey" if "kiyoshiloses" in persistent.specialend:
            clone john kiyoshi #Kiyoshi is really John all along in this game's code. Renaming John to Kiyoshi and giving him his appearance stays consistent with the rest of the code.
            stop music
            $john.name = "Kiyoshi"
            accessory john clear
            scene bg house_honda bedroom_kiyoshi night with fade
            $x = BlackJackBody("kiyoshi", "uniform", ("a_0"),"uniform","uniform","uniform","a_1", "a_2", "a_22", "a_3")
            show john a_0 at centerleft
            show patty a_0 at centerright
            $tarot = "themagician"
            jump bj2badend
        "Sayaka Gone Wild" if "kiyoshiwins" in persistent.specialend:
            clone john kiyoshi
            stop music
            $john.name = "Kiyoshi"
            accessory john clear
            scene bg house_honda bedroom_kiyoshi night with fade
            $x = BlackJackBody("kiyoshi", "uniform", ("a_0"),"uniform","uniform","uniform","a_1", "a_2", "a_22", "a_3")
            show john a_0 at centerleft
            show patty a_0 at centerright
            $tarot = "themagician"
            jump bj2goodend
        "A Fate Worse Than Identity Death" if "possible" in persistent.specialend:
            scene bg house_honda bedroom_kiyoshi night with fade
            show john a_0 at centerleft
            show patty a_0 at centerright
            $tarot = "lolz"
            jump bj2badend
        "Raines no Chosenjou" if "impossible" in persistent.specialend:
            scene bg house_honda bedroom_kiyoshi night with fade
            show john a_0 at centerleft
            show patty a_0 at centerright
            $tarot = "lolz"
            jump bj2goodend
        "Nevermind.":
            show circe a_6
            circe "Not even these, huh? I guess some people just can't be pleased."
            jump bj2options2

label increasehandsdialogue: #The dialogue called when stakes are raised.
    patty "We're now [hands] hands into the match."
    patty "The cards grow restless. We must make haste."

label callchoicedialogue: #The dialogue called when Patty asks for your next move.
    patty "The stake is currently [stake*2]. What's next?"

label blackjackdialogue: #The dialogue called when you draw a Blackjack.
    patty "Fortune has smiled upon you. You drew a Blackjack and win this hand by default."

label opblackjackdialogue: #The dialogue called when Patty draws a Blackjack.
    patty "The cards have betrayed you. That's a Blackback, and this hand is mine."

label windialogue: #The dialogue called when you win a hand.
    patty "You win this hand. The pot of $[stake*2] is yours."

label losedialogue: #Called when you lose a hand.
    patty "Too bad. You lose this hand. The pot of $[stake*2] is mine."

label raisebackdialogue: #Called when Patty raises in response to your raise.
    patty "Fate demands that I raise you back."

label raisedialogue: #One of these lines are called at random when Patty raises you initially.
    patty "Ah, the cards are calling. I must raise you."
    patty "Ah, the spirits speak to me. I must raise you."

label calldialogue: #One of these options is called at random when Patty holds. This is weirdly formatted Python code that makes more sense for Renpy than for us.
    """$choice:
        patty "My cards are silent. I shall go with the flow."
    $choice:
        patty "The spirits make me wary. I shall call."
    $choice:
        patty "My cards are silent. I abide."
        """
    return

label folddialogue: #Called when Patty folds a hand.
    patty "My fate is sealed. I concede."

label taketurndialogue: #Called while Patty is taking her turn.
    patty "Okay. Now, what does fate have in store for me?"

label opbustdialogue: #Called when Patty's hand exceeds 21.
    patty "Hmm, it appears I busted."

label tiedialoguejoker: #Called in the case of a tie and John hasn't transformed in a while.
    patty "Oh, a tie? The deck grows restless. The cards act on their own."

label tiedialogue: #Called during a tie when John has transformed recently.
    patty "Huh, just a tie. I'll return our stakes."

label recentjokerdialogue: #Called when a Joker is revealed but John has recently transformed.
    patty "The cards have granted you a brief respite. Your body needs time to recuperate."

label bustdialogue: #Called when John's hand exceeds 21.
    patty "Fate has it out for you, for you have busted."

label dealdialogue: #Called after John 'hits'.
    patty "Your card is a [card], bringing your total to [jhandtotal]. Was that your desire?"

label aidealdialogue: #Called after Patty 'hits
    patty "My card is a [card], bringing my total to [chandtotal]."

label newdeckdialogue: #This is called during the function when a new deck is created.
    patty "It appears we're out of cards. This will not do! I'll form a new deck to deal from."

label tarotexplain: #A brief bit of dialogue that is shown during the first ending.
    patty "Surely you're curious as to your fate?"
    john "I at least understand we weren't playing for money."
    show patty a_1
    patty "No. Your $25 is nonrefundable. And much appreciated."
    $emoo = ("john", x.sad_em)
    $renpy.show (emoo)
    john "Figures..."
    show patty a_2
    patty "Indeed, your true wager was represented in the tarot card you selected."
    return

label bj2prologue: #This is the prologue scene.
    clone john cornelia
    $john.name = "Cordelia" #Offscreen, John is turned into Cornelia's twin, Cordelia!
    outfit john uniform_b
    outfit cornelia casual
    outfit sayaka casual
    play music bgm_ensolarado
    scene bg city walkway day
    show sayaka a_21 at centerright
    sayaka "C'mon Cordelia! Hurry it up! Aren't you excited for your first mall trip?"
    show john a_17 at left
    john "Yeah, yeah, I'm coming, I'm coming."
    show sayaka a_20
    sayaka "What is up with that girl? She's got a shit attitude."
    show cornelia a_2 at right
    cornelia "Go easy on her, Sayaka. She just found out about her real family and awesome twin sister like a week ago."
    sayaka "I know, I know. What a batshit story. You could have told me this was all some kind of scheme, but she just looks fucking miserable."
    show cornelia a_18
    cornelia "Yeah, tell me about it. But, who the hell knows why? Maybe she had it made in her past life. All I know is she won't tell me shit."
    show sayaka a_1
    sayaka "Oh well. We'll get her in shape eventually. In the meantime, it's nice to have someone that will haul our shit around."
    show cornelia a_2
    cornelia "Gawd, for real. She can't be that bad, right?"
    show cornelia a_13
    cornelia "Meanwhile, Irene could never be assed to carry our bags. What a selfish bitch!"
    show john a_22
    think "They keep looking at me. I can only imagine what they're gossiping about."
    show john a_4
    think "There's no way they trust my {q}long lost twin{/q} story, right? Unfortunately, it was the only cover I could come up with after that fateful day."
    $john.name = "John"
    scene bg house_honda bedroom_kiyoshi night with fade
    outfit john underwear
    show john a_6 at centerleft #This is a direct callback to Blackjack 1 in terms of music, scene, and characters. Cute, huh?
    show kiyoshi a_1 at centerright, faceleft
    play music bgm_sneaky_snitch fadein 1.5
    show kiyoshi a_5
    kiyoshi "The remote just broke due to overuse. I think it's a goner."
    show john a_3
    john "Damnit, Kiyoshi! What the hell were you thinking?"
    show john a_8
    john "I didn't sign up to be Cornelia forever!"
    show kiyoshi a_2
    kiyoshi "I think you just did, John. Never gamble what you're not prepared to lose!"
    stop music
    scene bg city walkway day with fade
    outfit john uniform_b
    outfit patty robe
    show john a_8 at centerleft
    think "Damnit, those words still haunt me."
    show john a_14
    think "What an jerk. He was practically mocking my loss. Now all he wants to do is get in my pants."
    show john a_15
    think "Worse yet, I'm stuck with Sayaka's clique because nobody else wants to associate with Cornelia."
    show john a_18
    think "Can't imagine why."
    show john a_17
    think "Ah well, no use dwelling on it. That remote is cooked. There's never gonna be another Blackjack."
    show patty b_0 at centerright
    play music bgm_mirage
    patty "Good afternoon, madam. You appear troubled."
    show john a_11
    john "Huh? Where did you come from? Did you just appear out of thin air?!"
    show patty b_5
    patty "Your eyes deceive you, for I have been here all along."
    show john a_17
    john "Uh, right. If you say so."
    show patty b_1
    patty "More importantly, would you care for a little game to cheer you up?"
    show john a_4
    john "Sorry, I'm done with gambling. Bye."
    show patty b_11
    patty "Really? From what I heard, you are quite a connoisseur of Blackjack."
    show john a_20
    john "What did you say? Do you know something?"
    show patty b_1
    patty "I know more than you think."
    show patty b_2
    patty "Come into this alleyway. I have something to show you."
    john "...okay."
    hide patty
    hide john
    show sayaka a_6 at center
    show cornelia a_1 at centerright
    sayaka "Seriously? Did she just ditch? I knew this was a bad idea."
    show cornelia a_10 at centerright
    cornelia "Relax. I think she just went to get her fortune told. We'll meet up later."
    show sayaka a_18
    sayaka "Whatever. If she wants to get scammed like an idiot, it's not my problem."
    scene bg city alley day with fade
    show patty b_2 at centerright
    show john a_20 at centerleft
    john "Okay, what is it you wanted to show me?"
    show patty b_3
    patty "Behold."
    play sound sfx_spell
    morph begin magic john john uniform a_0
    morph do john
    morph finish john
    show john a_1
    john "What? I'm back to normal? Thanks, you're the best! Do I owe you anything?"
    show patty b_4
    patty "My apologies, John. That is merely a sample of my cards' power."
    show patty b_3
    patty "If you want your body back for good, I can deliver. But that privelege must be earned."
    show john a_16
    john "I should've known there was a catch."
    show patty b_1
    patty "It's only fair. A win to undo a loss."
    show john a_5
    john "Fine. What do I need to do?"
    show patty b_0
    patty "You'll pick a tarot card and receive 25 chips."
    show patty b_2
    patty "All you need to do is take all of my chips in a game of Blackjack. That will unlock the tarot card's power to change you back."
    show john a_2
    john "Fair enough, but what if I lose? Or, what if I choose the wrong Tarot card?"
    show patty b_3
    patty "There are always risks to gambling. However, if the spirits of the cards are on your side, you will prevail."
    show john a_5
    john "Okay, then."
    show john a_9
    john "I'm not sure I trust you or your cards, but I think you're the only one that can help me."
    show patty b_10
    patty "I knew you'd understand. Now, that will be $25!"
    show john a_5
    john "...deal."
    outfit patty uniform
    show patty a_1
    patty "Then let us begin."
    $persistent.sawprologue = True
    return

label newgameprompt: #This dialogue will display when an ending is completed. This way, you can easily jump back to the beginning.
    if johnwins == True:
        circe "And there's your ending. I hope you enjoyed it. Personally, I find these sappy good endings a snooze."
    elif johnwins == False:
        circe "And there's the ending. I hope you enjoyed it. Aren't the bad ends the best?"
    else:
        circe "And there's your ending. You found a special one, huh hotshot? I bet the author told you how to find it. Boring!"
    circe "Would you like to play again?"
    menu:
        "Start a new game.":
            circe "You got it, boss!"
            clone john audrey #John returns to his old form.
            clone patty riley #Patty returns to her old form.
            $john.name = "John" #Names are changed back in case certain scenarios are played.
            $patty.name = "Patty"
            jump blackjack2
        "Return to the main menu.":
            circe "Huh. I'm getting bored, too. Seeya next time, [persistent.name]."
            $ MainMenu(confirm=False)()

label kiyoshitime:
    clone john kiyoshi #This is a game starring Kiyoshi, so we need to make John look like him in both name and appearance.
    $john.name = "Kiyoshi"
    accessory john clear
    scene bg house_honda bedroom_kiyoshi night with fade
    $x = BlackJackBody("kiyoshi", "uniform", ("a_0"),"uniform","uniform","uniform","a_1", "a_2", "a_22", "a_3")
    show john a_0 at centerleft
    show patty a_0 at centerright
    play music bgm_aces_high
    $tarot = None
    $cmoney = 69
    show patty a_2
    patty "Good evening, Kiyoshi. I'm glad you could have me over for this fine evening of Blackjack."
    show john a_3
    john "Uh, who the heck are you? Where did you even come from?"
    show patty a_1
    patty "I am Patty, your friendly magical Blackjack Dealer."
    show patty a_10
    patty "I come and go where I please. When I please. I have my ways."
    show john a_0
    john "...right. Well, I know better than to ask questions."
    show john a_6
    john "I'm dying for some more Blackjack. Hit me with some of those...changes."
    show patty a_5
    patty "As you wish. But first, choose one of my Tarot cards. They will guide your destiny."
    show john a_10
    john "Give me that one. I have a good feeling.."
    show patty a_2
    patty "The Magician, huh? Interesting choice. Let us begin."
    $tarot = "themagician"
    jump gamestart

label rainestime:
    scene bg house_honda bedroom_kiyoshi night with fade
    show john a_0 at centerleft
    show patty a_0 at centerright
    play music bgm_aces_high
    $tarot = "lolz"
    $cmoney = 11546
    #$cmoney = 1
    show patty a_0
    patty "Good evening, John."
    show patty a_2
    patty "I see you've found Raines' secret stash."
    show patty a_9
    patty "There sure are a lot of chips here. He entrusted them to me."
    show patty a_10
    patty "I bet you don't have the time, patience, or skill to take them all."
    show patty a_1
    patty "Not even on the easy difficulty."
    show patty a_9
    patty "What? You don't believe me?"
    show patty a_11
    patty "I dare you to pry them from my greedy hands. All 11546 of them!"
    "A word of warning from the author: the 'good' ending for this is a practical joke. You may be disappointed. Proceed only if you enjoy a grindy challenge. You've been warned..."
    $tarot = "lolz"
    jump gamestart

label rileytime:
    clone john faith #Riley's form is stored under Faith's character. We load his appearance using her for this game.
    $john.name = "Riley"
    $tarot = "emperor"
    $cmoney = 45
    $x = BlackJackBody("riley", "uniform", ("a_0"),"uniform","uniform","uniform","a_0", "a_1", "a_4", "a_2")
    hide patty
    scene bg school rooftop cloudy with fade
    show john a_6 at centerleft
    play music bgm_flutey_funk
    john "Hmph. This year's been a total bust."
    john "I mean, Tina Hoya's been alright."
    show john a_3
    john "My teachers are cool, and Genny's still my bestie."
    show john a_2
    john "But how the heck will I ever get a girlfriend if nobody knows who I am?!"
    show john a_3
    john "Bah, this is ridiculous. Why am I pouting on a rooftop? This won't fix anything."
    show patty a_0 at centerright
    play sound sfx_spell
    patty "Good afternoon, Riley."
    show john a_1
    john "Hiya!"
    think "Finally, a cute girl, and she knows my name! Maybe I'm in the right place after all."
    show john a_4
    john "Wait, how did you get here? I could have sworn I was alone!"
    show patty a_5
    patty "The means of my presence is a triviality."
    show patty a_3
    patty "The reason for my presence is the pressing concern. I am here to cure what ails you."
    show john a_14
    john "You...want to be my girlfriend?"
    show patty a_6
    patty "No."
    show patty a_5
    patty "Still, you are in luck. My cards hold the key to what you seek."
    show john a_6
    john "Oh, is that so?"
    show john a_3
    john "I don't really believe in that kind of stuff, but I have nothing to lose."
    show patty a_8
    patty "Right, if you say so."
    show patty a_0
    patty "Simply choose one of these Tarot cards, then play me in a game of Blackjack. The cards shall guide your fate."
    show john a_16
    john "How fun! How about the emperor card? That one's perfect for me."
    show patty a_2
    patty "I'm inclined to agree. Shall we begin?"
    jump gamestart
