define bco_explosion = Move((0, 10), (0, -10), 0.10, bounce=True, repeat=True, delay=2.75)

label bco1:
    play music bgm_senbazuru

    # Button Colors
    style bco_textbutton:
        background "#00000000"

    style bco_textbutton_text:
        color "#ffffff"
        hover_color "#a838c4"

    show bco_asset epilepsy_warning at truecenter
    with Dissolve(2.0)
    pause 6.0

    call screen bco_warning

screen bco_warning():
    textbutton "{size=+5}{b}Continue{/b}{/size}" action [ToggleScreen("bco_warning"), Jump("bco1_1")] pos (0.5, 0.8) xanchor 0.5  style "bco_textbutton"
    textbutton "{size=+5}{b}Leave{/b}{/size}" action [ToggleScreen("bco_warning"), Jump("bcoleave")] pos (0.5, 0.15) xanchor 0.5 style "bco_textbutton"

label bcoleave:
    "This isn't the secret ending."
    gameover "There's a Secret Ending?"
    return

label bco1_1:
    "Nice choice.{p=3.0}"

    title "One Year Ago" "Local Shrine"

    scene bg shrine interior dusk
    with dissolve
    pause 1.0

    show john a_21:
        anchor (0.5,1.0) pos (0.35,1.3)
    show setsuna b_1:
        anchor (0.5,1.0) pos (0.65,1.3)
        faceleft
    with dissolve

    "During my class trip to the local shrine, I broke away from the main group in order to pay a visit to my childhood friend, Setsuna Otani."

    john "Thanks again for your advice, Setsuna."

    show john a_0
    with exchange
    setsuna "Anytime, John."

    setsuna "You should get going, though. I wouldn't want to keep you away from your class trip."

    show john:
        ease 1.0 ypos 1.0
    pause 1.0

    show john at faceleft
    with exchange
    pause 0.5

    hide john with easeoutleft

    play sound sfx_sliding_door_open

    "With that, I excused myself and left to rejoin my class."

    scene bg shrine exterior dusk
    with dissolve
    pause 0.5

    show john a_0 at centerright, faceleft
    with easeinright
    think "I'm so lucky to have a friend like Setsuna."

    show john a_2
    with exchange
    think "It's a shame that she's stuck here pretending to be some kind of bridge between us and the spirits."

    think "Such a pure-hearted, beautiful girl like her deserves the world."

    stop music fadeout 2.0

    outfit yoshinori gi

    show yoshinori a_1 at centerleft
    with easeinleft

    "My internal monologuing was interrupted by a strange old man."

    play music bgm_monster_promenade

    $ yoshinori.name = "Mysterious Man"
    show yoshinori a_2
    with exchange
    yoshinori "Hey! Did you just come out of the shrine?"

    show yoshinori a_1
    with exchange
    john "Um, yeah. Do you need something or...?"

    $ yoshinori.name = "Pervert"
    show yoshinori a_2
    with exchange
    yoshinori "Did you get a look at that hot babe, Setsuna?!"

    show yoshinori a_1
    show john a_16
    with exchange
    think "{q}Hot babe?!{/q}"

    john "Yeah, I did."
    extend " What about it?"

    show yoshinori a_2
    with exchange
    yoshinori "Ya gotta tell me how big her boobs've gotten now!"
    extend " I'd go check myself, but that damn guy Nemuri won't let me in there anymore."

    show yoshinori a_1
    show john a_7
    with exchange
    john "Excuse me?!"
    extend " What are you, some kind of pervert?!"

    john "Setsuna isn't some kind of pin-up girl for you to ogle at!"
    extend " She's a beautiful pure maiden!"

    john "Now you'd better get out of here before I call the police on you!"

    show yoshinori a_3
    show john a_16
    with exchange
    yoshinori "Hey, hey, kid! Relax, would you?! You don't have to be such a virgin about it!"

    show yoshinori a_2
    with exchange
    yoshinori "Let me tell you all about who I really am!"

    show yoshinori a_1
    show john a_7
    with exchange
    john "That's it! You clearly don't belong here! I'm calling the police!"

    show john a_16 at faceright
    with exchange
    "I pulled out my phone and started rapidly dialing."

    show yoshinori a_3
    with exchange
    yoshinori "Woah woah woah! If you're going to be such a white knight, maybe you need a lesson or two about how ladies work."

    play sound sfx_swirl1 volume 0.7
    show john:
        ease 1.0 blur 20
    show yoshinori:
        ease 1.0 blur 20
    show bg shrine exterior dusk:
        ease 1.0 blur 20
    image bco_white = Solid("#fff")
    show bco_white:
        alpha 0
        ease 3.0 alpha 1.0
    stop music fadeout 2.0
    "Before I could finish dialing the excessively long San Fransokyo non-emergency police number, I was enveloped in a bright light."

    show black with fade
    play sound sfx_alarm_clock

    scene bg house_davis bedroom_john day_shut:
        blur 20
        ease 2.0 blur 0
    with dissolve

    pause 1.0

    outfit john sleepwear
    show john a_9 at center
    with easeinbottom

    pause 3.0

    scene black with fade
    play music bgm_comfortable_mystery
    nvl clear
    nvl_narrator "The next thing I knew, I woke up to the sound of my alarm in my bedroom like nothing happened."
    nvl_narrator "Was it all a dream? Or maybe that freaky old guy drugged me somehow?"
    nvl_narrator "Who even was that guy anyway?"
    nvl_narrator "I spent the next year of my life with that mystery lingering in the back of my head."
    nvl_narrator "Eventually, it just became one of those weird unexplainable things that you just shrug off after a while, like the Mandela effect."
    nvl_narrator "But after the events of last night, nothing could be further from my mind."

    pause 1.0

    scene bg house_davis bedroom_john dark
    with dissolve

    pause 0.5

    outfit john uniform
    show john a_0 at center
    with dissolve

    pause 0.5

    play sound sfx_spell
    morph begin magic john katrina uniform a_3

    pause 2.0

    morph finish john

    pause 1.0

    "I discovered that I have magical powers!"

    scene black with fade

    stop music fadeout 2.0

    title "Present Day" "School Clubroom"

    play music bgm_easy_lemon
    scene bg school clubroom day
    with dissolve

    pause 1.0

    body john john
    show john a_0 at centerleft
    show katrina a_0 at centerright, faceleft
    with dissolve

    "I've been waiting for the perfect opportunity all day today to use my powers, but I had no idea when or where to use them."

    think "Should I tell Kat about my magical powers? After all, she was the one who had given the magical book in the first place."

    think "Can Kat really handle this sort of power?"

    think "No way! Who am I kidding?! With unlimited power like this, you have to be responsible!"

    think "You can't just play around with it with your friends like it's a toy!"

    stop music fadeout 4.0

    $ bco_choicestrike = 0
    $ bco_choicelabel = "bad_choice1"
    $ bco_firstfail = True

    transform bco_choose:
        alpha 0.0 blur 0
        easeout_expo 0.5 alpha 1.0
        ease 3.0 alpha 0.0 blur 20

    transform bco_pain:
        matrixcolor ContrastMatrix(1.5)
        ease 1.0 matrixcolor ContrastMatrix(1.0)


    play sound sfx_bass_tone volume 0.5

label bad_choice1:
    timedchoice 16.0 bco_timeout "Timeout Choice"
    menu:
        "{s}Leave for the day and test the magic in a safe, responsible environment.{/s}":
            if bco_firstfail:
                jump bco_choicelabel
            $ bco_choicestrike += 1
            if bco_choicestrike >= 3:
                jump bco_end0
            elif bco_choicestrike == 1:
                jump bco_menufail1
            elif bco_choicestrike == 2:
                jump bco_menufail2

        "Run outside and leap into traffic.":
            if bco_firstfail:
                jump bco_choicelabel
            else:
                jump bco_end1

        "Blurt out my secret and go on a magic spree with Katrina.":
            if bco_firstfail:
                jump bco_choicelabel
            else:
                jump bco2

label bco_timeout:
    if bco_firstfail:
        jump bco_choicelabel
    $ bco_choicestrike += 1
    if bco_choicestrike >= 3:
        jump bco_end0
    elif bco_choicestrike == 1:
        jump bco_menufail1
    elif bco_choicestrike == 2:
        jump bco_menufail2

label bco_choicelabel:
    stop sound fadeout 2.0
    play music bco_bgm_little_devil_shuffle volume 0.5
    show john a_15
    with exchange
    think "What the hell are these options?!"

    think "Why can't I just leave?!"

    think "It doesn't make any--"

    show john a_9 at bco_pain
    with exchange
    with vpunch
    play sound sfx_explosion volume 0.5
    "Just then, a sharp pain flooded into my head."

    show katrina a_11
    show john a_11
    with exchange
    with hpunch
    john "Aaaaahhhh!"

    show katrina a_3
    with exchange
    katrina "Oh my god! John, are you okay?"

    show katrina a_23
    show john a_9
    with exchange
    pause 0.5

    play sound bco_sfx_gong volume 0.2
    show bco_white at bco_choose
    show yoshinoriGhost a_1 at bco_choose, center
    think "It's that pervert from last year!"

    show john a_4
    with exchange
    john "The pervert is here!"

    show katrina a_22
    show john a_15
    with exchange
    katrina "Huh?"

    show katrina a_23
    show john a_9 at bco_pain
    with exchange
    with vpunch
    play sound sfx_explosion volume 0.5
    "Before I could figure out what was going on, another great pain flooded my head."

    show katrina a_11
    show john a_11
    with exchange
    with hpunch
    john "Aaaaagggghhhh!"

    show katrina a_23
    show john a_9
    with exchange
    pause 0.5

    play sound bco_sfx_gong volume 0.2
    show bco_white at bco_choose
    show yoshinoriGhost at bco_choose, center
    yoshinori "{size=+10}{b}You must choose!{/b}{/size}"

    show john a_15
    with exchange
    think "Choose what? Those weird options?"

    think "It won't let me go home! Which just leaves {q}Magic Spree with Kat{/q} or {q}Leap into Traffic?!{/q}"

    $ bco_firstfail = False

    jump bad_choice1

label bco_end1:
    play music bco_bgm_le_grand_chase volume 0.5
    think "I can't do this! It's just too risky to involve Kat in something like this!"

    show john a_11
    with exchange
    john "I'm sorry, Kat!"

    show john a_9 at faceleft
    with exchange
    pause 0.5

    hide john with easeoutleft
    play sound sfx_door_slam
    pause 2.0

    show katrina a_17
    with exchange
    katrina "What the heck?"

    scene bg school hallway_1 day
    with fade

    pause 0.5

    show sayaka b_0 at centerleft
    show john a_11 at offscreenright
    show cornelia b_0 at centerright,faceleft
    with dissolve

    with hpunch
    john "Out the way! Out the way!"

    play sound sfx_running
    show john at offscreenleft with ease
    pause 0.5

    show sayaka a_8
    show cornelia a_7
    with exchange
    pause 0.5

    show cornelia b_14
    show sayaka b_19 at faceleft
    with exchange
    sayaka "What the hell is that freak's issue?!"

    scene bg school hallway_2 day
    with fade

    show yui a_0 at centerleft
    show john a_11 at offscreenright
    show claus a_1 at centerright,faceleft
    with dissolve

    with hpunch
    john "Traffic! Traffic! I gotta throw myself into traffic!"

    play sound sfx_running
    show john at offscreenleft with ease
    pause 0.5

    show claus a_3
    show yui b_2 at faceleft
    with exchange

    show yui a_2
    with exchange
    yui "John! No running in the halls!"

    show claus a_4
    show yui a_3
    with exchange
    claus "Did he just say he's planning to throw himself into traffic?"

    scene bg town_corner day
    with fade

    show rita a_0 at center, faceleft
    show john a_11 at offscreenright, faceleft
    with dissolve

    john "Get out the way! I need to be in traffic {i}now!{/i}"

    show rita a_4 at faceright
    with exchange
    rita "Huh?"

    play sound sfx_running
    show john:
        transform_anchor True
        pos (1.4, 0.7)
        easeout_expo 1.0 anchor (0.5, 1.0) pos (0.5,1.0) rotate -90
    pause 0.75
    play sound sfx_whack
    with vpunch
    show rita:
        transform_anchor True
        anchor (0.5, 1.0) pos (0.5,1.0)
        linear 0.5 pos (-0.5,1.0) rotate -90

    think "There! I completed the mission!"

    stop music fadeout 2.0

    think "Now I can finally--"

    scene black with fade

    play sound bco_sfx_car_crash

    "It was at that moment that everything went black."

    pause 5.0

    outfit john sleepwear
    outfit rita casual

    scene bco_bg hospital bed:
        blur 20
        ease 5.0 blur 0
    with dissolve

    play music bgm_fluffing_a_duck

    "When I finally came to, I was in some sort of hospital room."

    think "Talk about nasty bedsores!"

    show john a_9 at centerright
    with dissolve

    rita "No way..."

    show john a_2 at faceleft
    with exchange

    show rita a_21 at centerleft
    with exchange
    rita "You're actually fucking awake!"

    show john a_8
    show rita a_20
    with exchange
    john "Rita, what are you doing here?"

    "My dry throat struggled to get the words out."

    show rita b_8
    with exchange
    rita "John, this is going to be a shock to you, but I need you to brace yourself."

    show john a_2
    show rita b_2
    with exchange
    john "What?"

    show rita b_4
    with exchange
    rita "The car accident you saved me from..."

    show rita b_14
    with exchange
    think "That's right, the last thing I remember was that I jumped into traffic."

    show john a_15
    show rita b_4
    with exchange
    rita "...was five years ago."

    show john a_4
    show rita b_14
    with exchange
    john "What?! It can't be!"

    show john a_15
    show rita b_4
    with exchange
    rita "I'm so sorry, John, but it's the year 20XX."

    show rita b_14
    with exchange
    think "That's not possible!"

    show john a_4
    with exchange
    john "What about my friends and family?!"

    show john a_15
    show rita b_4
    with exchange
    rita "I know for you, it must have seemed like an instant, but 5 years is a long fucking time."

    rita "At first, they stayed here by your side waiting for you to finally wake up."

    rita "But slowly, they've all moved on and even started your dream podcast without you."

    show john a_9
    show rita b_14
    with exchange
    think "Not my dream podcast!"

    show john a_2
    with exchange
    john "But if it's been so long, why are you still here?"

    stop music fadeout 2.0

    show rita b_18
    with exchange
    rita "Me? I'm still here because..."
    extend " well..."

    rita "I need to know why you saved me."

    rita "That's why I've been waiting here every day, having my rich parents pay for all of your hospital bills."

    show rita b_7
    with exchange
    think "I had 5 years of hospital bills?!"

    think "And if she's been waiting for me every day, then that must mean she has feelings for me now?"

    think "Okay, think, John. All your friends and family are gone, you don't have a penny to your name, and a rich girl is standing right in front of you."

    play music bgm_summer_memories

    show john a_13
    show rita a_18
    with exchange
    john "It's because I love you, Rita."

    john "I always have."

    john "So when I saw that truck coming for you, I knew I couldn't just stand there."

    john "I knew I had to be your shield."

    show john a_0
    show rita a_19
    with exchange
    rita "Oh, John!"

    rita "I knew it!"

    rita "It was actually a golf cart, but I still appreciate it nonetheless!"

    rita "Now c'mon! We gotta get you dressed up in your clothes and get you back out into the world!"

    show john a_13 blush
    show rita a_18
    with exchange
    john "About that... I don't know why, but I have the weird urge to wear skirts and dresses?"

    show john a_15 blush
    with exchange
    think "Why did I just tell her that?!"

    show rita a_23
    with exchange
    rita "Oh, that's because I played sissy hypno audios into your ears while you were in that 5-year coma."

    show rita a_22
    with exchange
    john "Huh?"

    show bco_asset cross:
        subpixel True
        xalign 0.54 yalign 0.40
        ease 10.0 zoom 1.1
    with Dissolve (5.0)

    pause 5.0

    gameover "Look Both Ways Before Crossdressing"

    return

label bco2:
    stop music fadeout 2.0
    think "Fuck it! I'm just going to have to trust Kat with my secret!"

    play music bco_bgm_feeling_sloppy volume 0.3
    show john a_2
    with exchange
    john "The truth is..."
    extend " I'm a wizard!"

    show katrina a_21
    with exchange
    katrina "Uh huh... I love that you're getting into the roleplay spirit, but this is a little much for me."

    show katrina a_5
    with exchange
    think "Roleplay? Maybe I could just play it off as--"

    show john a_9 at bco_pain
    with exchange
    with vpunch
    play sound sfx_explosion volume 0.4
    think "My head!"

    show katrina a_18
    show john a_2
    with exchange
    john "No! I'm a real wizard!"
    extend " Here, watch!"

    stop music fadeout 2.0

    "I chanted the spell that I tested out last night."

    play music bgm_mirage
    show pentagram at Position(pos=(placement_of(john).xpos, 0.5)) behind john as pentagram
    play sound sfx_spell
    john "{spell}Corpus transfiguret!{/spell}"

    morph begin magic john katrina uniform a_5

    show katrina a_19
    with exchange
    "The familiar burning sensation filled my body as I felt my organs shift around."

    "My chest and hips swelled until they were the exact size and shape of Kat's wide hips and perky breasts."

    morph finish john
    hide pentagram with dissolve
    stop music fadeout 3.0

    "Finally, as the spell was completed, Kat was left standing there speechless."

    play music bco_bgm_feeling_sloppy volume 0.3

    show katrina a_3
    with exchange
    katrina "Wait, wait, wait! John?! Is that really you in there?!"

    show katrina a_19
    show john a_21
    with exchange
    john "Yup, it's me in the flesh."

    show katrina b_17
    show john a_5
    with exchange
    katrina "Yeah, {i}my{/i} flesh! This is so crazy! You even sound just like me!"

    show katrina b_0
    show john a_21
    with exchange
    john "If anyone overheard this conversation, they'd probably think {q}Katrina's finally lost it.{/q}"

    show katrina b_18
    show john a_5
    with exchange
    katrina "I'm not sure I {i}haven't{/i} lost my marbles!"

    show katrina a_12
    with exchange
    katrina "So when did you even learn that you have freakin' wizard powers?!"

    show katrina a_4
    show john a_21
    with exchange
    john "Yeah, about that, I just found out about my powers last night when you gave me that weird spellbook that turned out to be the real deal."

    show john a_5
    show katrina a_13
    with exchange
    katrina "So it was my book that gave you powers?! What else can you do?"

    show john a_21
    show katrina a_0
    with exchange
    john "I don't know. I haven't had the time to try any other spells yet."

    show john a_0
    show katrina b_17
    with exchange
    katrina "{q}Other spells?{/q} But you've already tried this transforming spell?"

    show katrina b_0
    with exchange
    john "Yeah, unfortunately, this was the only one I had time to try last night."

    show katrina b_17
    with exchange
    katrina "Oh, so who did you transform into?"

    show john a_16 blush
    show katrina b_0
    with exchange
    think "Shit! Should I admit that I transformed into her, or should I make something up?!"

    show katrina a_19 blush
    with exchange
    "My silence spoke for itself."

    show katrina b_5 blush
    with exchange
    katrina "Well... I guess imitation {i}is{/i} the highest form of flattery."

    show john a_0
    show katrina b_17
    with exchange
    katrina "But anyway, this is such a big deal, John!"

    katrina "We gotta try out some of the other stuff!"

    show john a_21
    show katrina b_0
    with exchange
    john "Yup, we definitely gotta go on some sort of reckless {i}magic spree.{/i}"

    show john a_0
    with exchange
    think "Whether I want to or not."

    show katrina a_13
    with exchange
    katrina "Do you have the book on you right now?"

    show john b_17 at faceleft
    show katrina a_0
    with exchange
    john "Yeah, it's right here in my bag."

    show john b_0
    with exchange
    "I reached into my bag, now transformed into Kat's bag, and pulled out the book."

    scene black with fade

    body john john

    "After I turned myself back into myself, me and Kat spent some time looking through the spell book for some fun spells to try out."

    "Unfortunately, Kat wasn't able to read the writing in the book, so I had to explain what each spell did."

    think "That pervert's curse is going to mess me up unless I find something we can use right now."

    think "Here we go! A simple telekinesis spell!"

    think "This should be harmless enough not to cause any real problems for anyone."

    scene bg school clubroom day
    with fade

    pause 0.5

    show john a_0 at centerleft
    show katrina a_0 at centerright, faceleft
    with dissolve

    show john a_21
    with exchange
    john "Hey, Kat, I think I found a spell that would be perfect for us to try out right here!"

    show katrina a_13
    show john a_0
    with exchange
    katrina "Yeah? What does it say?"

    show katrina a_0
    show john a_21
    with exchange
    "It's--"

    play music bco_bgm_little_devil_shuffle volume 0.5
    $ bco_choicestrike = 0
    $ bco_choicelabel  = "bad_choice2"

label bad_choice2:
    timedchoice 18.0 bco_timeout "Timeout Choice"
    menu:
        "{s}Use the telekinesis spell to safely experiment with magic first.{/s}":
            $ bco_choicestrike += 1
            if bco_choicestrike >= 3:
                jump bco_end0
            elif bco_choicestrike == 1:
                jump bco_menufail1
            elif bco_choicestrike == 2:
                jump bco_menufail2

        "Use the astral projection spell to prank Sayaka and Cornelia.":
                stop music fadeout 3.0

                show john a_15
                with exchange
                think "These choices are equally terrible!"

                jump bco3

        "Use the explosion spell to blow up Tina Koya High School.":
                jump bco_end2

label bco_end2:
    show john a_15
    with exchange
    think "These choices are equally terrible!"

    show john a_4
    with exchange
    john "We are going to use the explosion spell!"

    show john a_15
    show katrina a_21
    with exchange
    katrina "The what spell?!"

    katrina "That sounds kinda dangerous!"

    stop music fadeout 2.0

    show john a_4
    show katrina a_14
    with exchange
    john "I'm sorry, Katrina! It's not my fault!"

    play music bco_bgm_dominus_deus volume 0.8
    play sound sfx_spell
    show pentagram at Position(pos=(placement_of(john).xpos, 0.5)) behind john as pentagram
    with vpunch
    show john a_4
    with exchange
    john "{color=#f00}Nigra flammea rex mundorum millium etsi naturae leges promulgamus{/color}"

    show katrina b_16
    show john a_15
    with exchange
    katrina "Wait! John, you can't be serious!"

    with vpunch

    transform bco_exploshake:
        linear 0.1 yoffset -5
        linear 0.1 yoffset 5
        repeat 9001
    show bg school clubroom day at bco_exploshake
    show john at bco_exploshake
    show katrina at bco_exploshake
    image bco_white = Solid("#fff", xsize=1.0, ysize=1.0)
    show bco_white:
        alpha 0.0
    pause 0.1

    show bco_white:
        linear 0.1 alpha 0.0
        linear 0.1 alpha 0.1
        repeat 9001

    play audio sfx_house_shake

    show katrina a_11
    show john a_4
    with exchange
    john "{color=#f00}Ego sum alias interitus incarnati ex principiis omnis creaturae{/color}"

    show katrina a_22
    show john a_15
    with exchange
    katrina "John, the floor is shaking!"

    show bco_white:
        alpha 0.0
        ease 5.0 alpha 1.0
    with bco_explosion
    play audio sfx_house_shake
    show katrina a_11
    show john a_4
    with exchange
    john "{color=#f00}Descendat ad me malleus aeternitatis{/color}"

    show katrina a_3
    show john a_15
    with exchange
    katrina "You're going to kill us all!"

    play sound bco_sfx_quake
    show bco_white:
        alpha 0.0
        ease 5.0 alpha 1.0
    with bco_explosion
    show katrina a_11
    show john a_4
    with exchange
    john "{color=#f00}Explosio!{/color}"

    show bco_white:
        alpha 0.0
        ease 5.0 alpha 1.0
    with bco_explosion
    pause 3.0
    scene black with fade
    stop music fadeout 2.0

    pause 4.0

    play music bgm_dark_fog

    pause 2.0

    charlotte "Chaos."
    extend " Devastation."
    extend " Despair."

    outfit charlotte jeans

    image gray = Solid( "#68686891", xsize=1.0, ysize=1.0)
    show bco_bg quake
    show charlotte a_0 at center
    show gray
    show vhs
    with dissolve

    show charlotte a_3
    with exchange
    charlotte "An ordinary school day ended in tragedy today when a suspected gas leak caused the school of Tina Koya High to erupt into a fireball."

    charlotte "With dozens dead and dozens more missing, this community will never be the same."

    show charlotte a_5
    with exchange
    naomi "...aaaaand cut!"

    stop music fadeout 2.0

    hide gray
    hide vhs
    with dissolve

    pause 1.0

    show naomi a_0 at faceleft, right
    with easeinright

    pause 1.0

    show naomi a_1
    show charlotte b_0 at faceright
    with exchange
    naomi "Way to go, Charlotte! We're definitely acing this journalism class!"

    show naomi a_0
    show charlotte b_2
    with exchange
    charlotte "Thanks, Nao!"

    show naomi a_5
    show charlotte b_0
    with exchange
    naomi "We should get outta here though. This place gives me the creeps."

    show naomi a_0
    show charlotte at faceleft
    with exchange
    pause 1.0

    hide charlotte
    hide naomi
    with easeoutleft
    pause 1.0

    show bco_bg quake:
        ease 3.0 anchor (0.5,1.0) zoom 1.5 pos (0.5,1.0)
    play music bgm_investigations
    pause 3.0

    show johnGhost a_2 at center
    show katrinaGhost a_4 at right, faceleft
    with dissolve
    pause 1.0

    show katrinaGhost a_12
    with exchange
    katrina "Wait. So explain that to me again?"

    show johnGhost a_13
    show katrinaGhost a_4
    with exchange
    john "Okay, so last year I was cursed by this pervert god, and then today, all of these terrible choices started popping up in front of me."

    john "And if I hesitated on choosing one, it made my head feel like it was exploding."

    show johnGhost a_2
    show katrinaGhost a_17
    with exchange
    katrina "Gee, it must feel {i}terrible{/i} feeling like you were getting exploded."

    show katrinaGhost a_18
    with exchange
    "Katrina's voice was laced with sarcastic malice."

    show katrinaGhost a_17
    with exchange
    katrina "So you wanna explain to me how {i}this{/i} was the better option than pranking Sayaka?"

    show johnGhost a_7
    show katrinaGhost a_18
    with exchange
    john "The choices were equally bad!"

    stop music fadeout 2.0

    show johnGhost a_16
    with exchange
    pause 0.5

    show yoshinoriGhost a_0 at left
    with dissolve
    "Before I could defend myself any further, the pervert god revealed himself to us."

    play music bgm_netherworld_shanty

    show yoshinoriGhost a_3
    show johnGhost a_15 at faceleft
    show katrinaGhost a_4
    with exchange
    yoshinori "You moron!"

    show johnGhost a_7
    show yoshinoriGhost a_0
    with exchange
    john "You!"

    show johnGhost a_16
    show katrinaGhost a_12
    with exchange
    katrina "You're the pervert god?!"

    show yoshinoriGhost a_3
    show katrinaGhost a_4
    with exchange
    yoshinori "Hey! I'm not a perv! I was just trying to teach your friend--"

    show yoshinoriGhost a_0
    show katrinaGhost a_12
    with exchange
    katrina "I don't care what you were teaching him!"

    with hpunch
    show katrinaGhost a_12
    with exchange
    katrina "{size=+10}{b}I died!{/b}{/size}"

    show yoshinoriGhost a_3
    show katrinaGhost a_4
    with exchange
    yoshinori "Look, look! I'm gonna fix this all!"

    yoshinori "Obviously, this dumbass wasn't supposed to choose that option!"

    show yoshinoriGhost a_0
    with exchange
    think "Is he really trying to blame me for this?"

    show johnGhost a_7
    with exchange
    john "Or you could've just, y'know, {i}not cursed me.{/i}"

    show johnGhost a_16
    show yoshinoriGhost a_3
    with exchange
    yoshinori "Alright! I get it!"

    yoshinori "I'm gonna bring everyone back to life, but it's gonna take some time."

    show yoshinoriGhost a_0
    show katrinaGhost a_12
    with exchange
    katrina "A day?! A week?! How long?!"

    show yoshinoriGhost a_2
    show katrinaGhost a_4
    with exchange
    yoshinori "Maybe a day? I dunno, it's a complicated process and I have to find everyone's body parts and put them back together and..."

    "The pervert god's voice trailed off."

    show yoshinoriGhost a_3
    with exchange
    yoshinori "Look, the point is you can't rush good work!"

    show johnGhost a_7
    show yoshinoriGhost a_1
    with exchange
    john "Well, I'm sure we would all appreciate it if you hurried up!"

    john "And also remove that curse while you're at it!"

    show johnGhost a_16
    show yoshinoriGhost a_3
    with exchange
    yoshinori "Oh, you don't gotta tell me twice! I'm never doing that learn-a-life-lesson-by-being-cursed thing again!"

    show johnGhost a_7
    show yoshinoriGhost a_1
    with exchange
    john "Well, at least one of us learned a lesson here!"

    scene black with fade
    stop music fadeout 2.0

    "Even though the pervert god did say that you can't rush good work, he eventually proved that you can't rush shitty work either."

    title "One Month Later" "Tina Koya School Gates"

    play music bgm_hackbeat
    scene bg school entrance day:
        zoom 1.5 anchor (1.0,1.0) pos(1.0,1.0)
    with dissolve
    pause 0.5

    body john phila
    body kyoko jack
    body kiyoshi yui
    body katrina kiyoshi
    body sayaka katrina
    body cornelia john

    accessory katrina set glasses

    show john a_0:
        anchor (0.5,1.0) pos (0.4,1.0)
    show kiyoshi a_0:
        anchor (0.5,1.0) pos (0.2,1.0)
    show katrina a_0:
        anchor (0.5,1.0) pos (0.6,1.0)
        faceleft
    show kyoko a_16:
        anchor (0.5,1.0) pos (0.8,1.0)
        faceleft
    with dissolve

    pause 2.0

    "Although this whole thing was the pervert god's fault, I couldn't help but feel a pang of guilt about it all as I vented my frustrations to Kiyoshi."

    show john a_8
    with exchange
    john "This is the worst!"

    show kiyoshi b_5
    show john a_7
    with exchange
    kiyoshi "I don't know what you're complaining about, J-man. It's not so bad being plopped into the bodies of two stunning beauties such as ourselves!"

    show katrina a_3
    show kiyoshi b_10
    with exchange
    katrina "Yeah, John, some people don't have it as good."

    show katrina a_0
    show kiyoshi b_6
    show john b_4
    with exchange
    john "Right. Sorry, Kyoko."

    show kyoko a_13
    show john b_0
    with exchange
    kyoko "Don't worry about it, I'm sure there's {i}some{/i} sort of benefit to being a middle-aged man."

    show kyoko a_16
    show john a_4
    with exchange
    john "I just don't get why the pervert god actually thought {i}that{/i} was your body."

    show kyoko a_4
    show john a_0
    with exchange
    kyoko "It was my fault, I should have been more specific."

    kyoko "All I said was that I was a brunette with glasses, and then he said he already knew which body was mine."

    show katrina a_3
    show kyoko a_16
    with exchange
    katrina "I mean, with just that description alone, you could've been talking about Michelle Bloom."

    show katrina a_0
    show kiyoshi b_2
    with exchange
    kiyoshi "Wow, you were able to get in two traits?"
    extend " He cut me off after just {q}purple hair{/q}."

    show kiyoshi b_6
    show john b_8
    with exchange
    john "Same. I have no idea how he got {q}Phila{/q} after I only said {q}average.{/q}"

    show kyoko a_19
    show john b_0
    with exchange
    kyoko "Well, one could interpret {q}average{/q} as meaning similar to others, so maybe he saw Phila and Mina together and figured their similarity to each other made them the most average."

    show katrina a_3
    show kyoko a_16
    with exchange
    katrina "Okay, but at least you guys were able to say {i}anything at all{/i} to him!"

    katrina "When it was my turn to claim my body, he just stuck me in one of the leftovers!"

    show katrina a_0
    show kiyoshi b_10
    with exchange
    kiyoshi "A very dashing and handsome leftover body, might I add."

    show katrina a_5
    show kiyoshi b_6
    with exchange
    katrina "I don't know how you people live with these glasses!"

    show kiyoshi b_5
    show katrina a_0
    with exchange
    kiyoshi "A true warrior of the planet Earth must always be vigilant for incoming threats!"

    stop music fadeout 3.0

    show kiyoshi b_9
    show katrina a_20
    with exchange
    katrina "Speaking of which, looks like we have some threats incoming right now."

    show sayaka a_4:
        anchor (0.5, 1.0) pos (-0.2, 1.0)
    show cornelia b_17:
        anchor (0.5, 1.0) pos (-0.4, 1.0)
    show john b_0 at faceleft
    show kiyoshi a_13 at faceleft
    show katrina a_19
    show kyoko a_19
    with exchange
    pause 0.5

    play music bgm_early_riser

    show bg school entrance day:
        subpixel True
        ease 3.0 zoom 1.0
    show john:
        subpixel True
        ease 3.0 zoom 0.67 xpos 0.6
    show kiyoshi:
        subpixel True
        ease 3.0 zoom 0.67 xpos 0.47
    show katrina:
        subpixel True
        ease 3.0 zoom 0.67 xpos 0.73
    show kyoko:
        subpixel True
        ease 3.0 zoom 0.67 xpos 0.87
    show sayaka:
        subpixel True
        ease 3.0 zoom 0.67 xpos 0.20
    show cornelia:
        subpixel True
        ease 3.0 zoom 0.67 xpos 0.07

    pause 3.0

    show sayaka b_24
    with exchange
    sayaka "Hmm... I didn't realize it was {q}take your grandpa to school{/q} day?"

    show cornelia a_3
    show sayaka b_0
    with exchange
    cornelia "Yeah, for real, he's probably just some old perv who likes high school girls."

    show katrina a_20
    show cornelia a_17
    with exchange
    katrina "Fuck you, Sayaka!"

    show katrina a_19
    show sayaka a_17
    with exchange
    sayaka "Jealous much? Just because I can make even {i}this{/i} trashy body work?"

    show sayaka a_4
    with exchange
    pause 0.5

    show cornelia b_3
    with exchange
    show katrina:
        easeout_expo 1.0 xpos 0.30
    show pentagram at Position(pos=(placement_of(cornelia).xpos, 0.5)) behind cornelia as pentagram
    play sound sfx_spell
    cornelia "{spell}Verba obedi!{/spell}"

    pause 1.0

    hide pentagram
    with dissolve

    show katrina a_16:
        xpos 0.30
    show cornelia b_3
    show sayaka b_24
    with exchange
    sayaka "Not so fast."

    show john b_7
    show sayaka b_21
    with exchange
    think "There it is. The worst part of this wrong-body situation. Cornelia has my wizard powers."

    show cornelia a_3
    with exchange
    cornelia "You will now blurt out your biggest, most humiliating secret."

    show katrina a_3
    show cornelia a_17
    with exchange
    katrina "{size=+5}I have a huge crush on John Davis!{/size}"

    show john a_5
    show katrina a_16
    with exchange
    think "What?!"

    show john a_2
    show sayaka b_24
    with exchange
    sayaka "{i}That{/i} was supposed to be a secret?"

    show cornelia b_3
    show sayaka b_20
    with exchange
    cornelia "Gross!"

    show cornelia b_17
    show sayaka a_12 at faceleft
    with exchange
    sayaka "C'mon, Corny. Let's get out of here before these two start having weird loser sex."

    show sayaka a_4
    show cornelia at faceleft
    with exchange
    pause 0.5

    hide cornelia
    hide sayaka
    with easeoutleft

    stop music fadeout 2.0
    "Katrina was too shocked to even attempt attacking them any further as the pair of bullies retreated."

    play music bgm_strangers_draw
    show john b_3:
        ease 3.0 xpos 0.45
    show kiyoshi:
        ease 5.0 xpos 0.7
    think "I feel like I have to say something."

    show bg school entrance day:
        subpixel True
        anchor (0.5,1.0) pos (0.5,1.0)
        ease 4.0 zoom 1.7 blur 5
    show john:
        subpixel True
        ease 4.0 zoom 1.1 xpos 0.475
    show katrina:
        subpixel True
        ease 4.0 zoom 1.1 xpos 0.18
    show kiyoshi:
        subpixel True
        ease 4.0 zoom 1.1 xpos 1.35
    show kyoko:
        subpixel True
        ease 4.0 zoom 1.1 xpos 1.65
    john "Was that true, Kat?"

    john "Do you really have a crush on me?"

    "I asked that already knowing that the spell couldn't have been wrong."

    show katrina a_22:
        faceright
        zoom 1.1 xpos 0.18
    with exchange
    katrina "Would we be able to still be friends if I did?"

    show katrina a_21
    with exchange
    think "Friends? That's what she's worried about?"

    show john a_4:
        zoom 1.1 xpos 0.475
    with exchange
    john "No, we couldn't be friends anymore."
    extend " Because we would have to be more than that."

    show john a_0
    show katrina a_22
    with exchange
    katrina "What?! Really?! Even though I'm stuck in this freaky body?!"

    show katrina a_21
    with exchange
    kiyoshi "{size=-5}Hey, that's my body--{/size}"

    kyoko "{size=-5}Shush, Kiyoshi!{/size}"

    kiyoshi "{size=-5}It's a little rude!{/size}"

    show john b_5
    with exchange
    john "Well, it's not ideal, but..."

    show john b_2
    show katrina a_22
    with exchange
    katrina "Yeah?"

    show john a_4 blush
    with exchange
    john "Maybe we could give it a shot like this with the way things are."

    show john a_2 blush
    show katrina a_14
    with exchange
    katrina "You really mean it?!"

    show john b_8 blush
    show katrina a_1
    with exchange
    john "Let me be clear, I'm not crazy about being {i}anyone's{/i} girlfriend, but until this thing gets sorted out, we can't just put our lives on pause, right?"

    show john a_2 blush
    show katrina a_7
    with exchange
    katrina "Right!"

    scene black with fade

    "That was the day that me and Kat officially started dating."

    "It wasn't an ideal confession, but all is well that ends well, I suppose."

    "As the days bled into weeks, we had to finally contend with the real possibility that the pervert god was never going to come back come back to fix things."

    "We had tried asking Cornelia to use my magic to fix this mess, but when we tried talking to her and Sayaka, they both were acting really weird and uncanny."
    extend " Almost NPC-like."

    "This was obviously some sort of side effect from messing around too much with some of the spells, so we decided as a group that maybe magic wasn't worth the risk of danger."

    "But even with no hope of going back to normal, I didn't really care all that much."

    "I had gotten so used to seeing Kiyoshi's face as my new boyfriend, that it was really hard to imagine it any other way."

    "I'm actually happy like this."

    "I'm glad that Kat's my boyfriend."

    "And I'm glad that I chose to explode Tina Koya High School, killing everyone inside in a violent fireball."

    show bco_asset kiyophila:
        ease 10.0 zoom 1.1
    with Dissolve (3.0)

    pause 5.0

    gameover "The Kiy to a New Philing"

    return

label bco3:
    play music bco_bgm_feeling_sloppy volume 0.3
    show john a_21
    with exchange
    john "It's called {q}Astral Projection and Body Possession.{/q}"

    show john a_0
    show katrina b_17
    with exchange
    katrina "Astral projection? You mean like flying around as spooky ghosts and whatnot?"

    show john a_21
    show katrina b_0
    with exchange
    john "Yeah, something like that."

    john "Basically, what it does is that it kicks our souls outside of our bodies."

    show john a_0
    show katrina a_17
    with exchange
    katrina "Well, that sounds a whole lot like {i}dying.{/i}"

    show john a_21
    show katrina a_0
    with exchange
    john "It's not. So while our souls are just floating around in the air, we can actually dive right into other people's bodies, taking control of them."

    show john a_0
    show katrina b_17
    with exchange
    katrina "I figured as much from the {q}Body Possession{/q} part of the title."

    show katrina b_16
    with exchange
    katrina "You're not gonna try to possess {i}me{/i}, are you?"

    show katrina b_0
    with exchange
    think "I wish that's what the curse wanted me to do."

    show john a_21
    with exchange
    john "Actually, I was thinking that we could really use this spell for... {i}comeuppance{/i}."

    show john a_0
    show katrina a_13
    with exchange
    katrina "{i}Comeuppance,{/i} you say? I like the sound of this."

    show john a_21
    show katrina a_0
    with exchange
    john "I say we use the spell to prank Sayaka and Cornelia."

    show john a_0
    show katrina b_17
    with exchange
    katrina "Now we're talking!"

    katrina "So when do you wanna do it?"

    show katrina b_0
    with exchange
    think "It would probably be best to take our time with something as crazy as this."

    show john a_21
    with exchange
    john "Let's do it--"

    show john a_9 at bco_pain
    with exchange
    with vpunch
    play sound sfx_explosion volume 0.4
    think "My head!"

    show john a_4
    with exchange
    john "Now! Let's do it now!"

    show john a_15
    show katrina a_21
    with exchange
    katrina "Oh! O-okay!"

    stop music fadeout 2.0
    show katrina a_0
    with exchange
    "Without a moment's hesitation, I chanted the spell."

    play music bgm_mirage
    show pentagram at Position(pos=(placement_of(john).xpos, 0.5)) behind john as pentagram
    play sound sfx_spell
    show john a_20
    with exchange
    john "{spell}Anima a carne dimittat!{/spell}"

    hide pentagram
    exspirit john a_0
    play sound sfx_fall
    exspirit katrina a_0
    stop music fadeout 3.0
    play audio sfx_fall
    "The spell ripped our souls out like strings on a marionette, leaving our bodies flopping onto the floor as empty husks."

    play music bco_bgm_feeling_sloppy volume 0.3
    show katrinaGhost b_15
    with exchange
    katrina "Holy crap! John! I'm a freakin ghost!"

    show johnGhost a_21
    show katrinaGhost b_0
    with exchange
    john "I feel so... floaty!"

    show johnGhost a_0
    show katrinaGhost b_18
    with exchange
    katrina "I'm so excited! What are you waiting for?! It's {i}comeuppance{/i} time!"

    show katrinaGhost a_0
    with exchange
    pause 0.5

    hide katrinaGhost with easeoutleft
    pause 0.5

    show johnGhost at faceleft
    with exchange
    "Before I could reply, Katrina zoomed away, phasing straight through the wall."

    stop music fadeout 4.0

    think "Personally, I'd have preferred a quick test run on the whole {q}intangibility{/q} thing before diving headfirst into a wall."

    scene bg school hallway_2 day
    with fade
    pause 0.5

    play music bgm_fast_talkin
    body katrina sayaka
    show katrina b_12 at centerleft
    show cornelia a_14 at centerright, faceleft
    with dissolve
    pause 0.5

    show johnGhost a_0 at right, faceleft
    with easeinright
    "When I followed her into the hall, I saw no sign of Kat's ghost anywhere."

    show johnGhost a_2
    with exchange
    "Instead, I saw Cornelia having what appeared to be a heated argument with Sayaka."

    katrina "--and my skin is so dry that I need to slather my mattress in lotion before going to bed at night!"

    show katrina b_1
    show cornelia b_23
    with exchange
    cornelia "What the hell are you even talking about, Saya?"

    possess john cornelia a_11

    play sound sfx_spell
    "Before Katrina could do any more damage, I dove right into Cornelia's body."

    "Diving into Cornelia's body felt like squeezing into an ill-fitting suit. The merging of my soul with her body clicked into place as my perspective was forced into an unsettling alignment with hers."

    show john b_17
    with exchange
    john "Katrina!"

    show john b_5
    with exchange
    "My embarrassingly shrimpy voice echoed through the halls."

    show katrina a_12
    with exchange
    katrina "Well, look who finally decided to show up!"

    show john b_6
    show katrina a_15
    with exchange
    john "Yeah, yeah, let's just get this prank thing over with."

    show john b_5
    show katrina b_10
    with exchange
    katrina "Why the rush? I think I just might take my time telling everyone how this {i}absolutely pedestrian{/i} cafeteria food makes my {i}arm flab wrinkles{/i} flare up."

    show katrina b_1
    with exchange
    think "We're supposed to prank them! Not destroy their reputations!"

    think "I have to think of something quicker and easier!"

    show john b_16
    with exchange
    john "You know what, {i}Sayaka{/i}? I'm suddenly feeling a bit warm. How about we take a dip in the pool to cool off?"

    show john b_1
    show katrina a_19
    with exchange
    katrina "A dip in the pool? Well, I {i}suppose{/i} that could help moisturize my amphibian scales..."

    stop music fadeout 4.0
    show john a_10
    show katrina a_1
    with exchange
    john "Oh, yes! Let's go!"

    play music bgm_the_builder
    scene bg school pool day
    with fade
    pause 0.5
    show john b_1 at centerleft, faceleft
    show katrina b_1 at centerright, faceleft
    with easeinright
    "The pool area was deserted, the perfect stage for a sneaky prank."

    show katrina b_10
    show john b_0 at faceright
    with exchange
    katrina "Ready?"

    show katrina b_1
    show john b_11
    with exchange
    john "Ready as I'll ever be."

    show john b_1
    with exchange

    "Without a moment's hesitation, Katrina and I leapt into the shallow end."

    show bg school pool day:
        anchor (0.5,0.5) pos (0.5,0.5)
        ease 0.5 zoom 1.3
    exspirit john a_0
    play sound sfx_big_water_splash volume 0.7
    exspirit katrina a_0
    play audio sfx_big_water_splash volume 0.7

    "The shock of the cold water drenching Cornelia's uniform was exhilarating."

    "And with a quick mental push, Katrina and I ejected ourselves from their soaked bodies."

    with hpunch
    sayaka "Corny! What did you just do to me?!"

    "We hovered above the water, watching Sayaka and Cornelia thrashing around in confusion."

    think "They really have no idea what had just happened!"

    show katrinaGhost b_1
    with exchange
    "Katrina let out a peal of ghostly laughter."

    show katrinaGhost b_5
    with exchange
    katrina "Oh my god, John, look at their faces!"

    show katrinaGhost b_0
    show johnGhost a_20
    with exchange
    john "Priceless. Absolutely priceless."

    show johnGhost a_0
    with exchange
    "We floated there for a few more moments, soaking in the success of our prank."

    show johnGhost a_21
    with exchange
    john "Comeuppance complete?"

    show johnGhost a_0
    show katrinaGhost a_13
    with exchange
    katrina "Comeuppance complete."

    scene black with fade

    "I could feel the tension leaving me as I finally had a moment's break from the curse's hold."

    scene bg school clubroom day
    with dissolve
    pause 0.5

    show johnGhost a_0 at center, faceleft
    show katrinaGhost a_0 at right, faceleft
    with easeinright
    "We drifted back to our unconscious bodies."

    john "Great. All that's left now is to--"


    play music bco_bgm_little_devil_shuffle volume 0.5
    $ bco_choicestrike = 0
    $ bco_choicelabel  = "bad_choice3"

label bad_choice3:
    timedchoice 18.0 bco_timeout "Timeout Choice"
    menu:
        "{s}Return to my own body and live a peaceful life.{/s}":
            $ bco_choicestrike += 1
            if bco_choicestrike >= 3:
                jump bco_end0
            elif bco_choicestrike == 1:
                jump bco_menufail1
            elif bco_choicestrike == 2:
                jump bco_menufail2

        "Return to Kat's body and immediately engage in cat-related pet play.":
                jump bco_end4

        "Return to the body of an actual dog.":
                jump bco_end3

label bco_end3:
    transform bcobounce:
        ypos 1.0
        easein_expo 0.25 ypos 0.98
        easeout_expo 0.25 ypos 1.00
        ypos 1.0

    stop music fadeout 3.0
    show johnGhost a_15
    with exchange
    think "Fuck! It happened again!"

    play music bco_bgm_le_grand_chase volume 0.5
    think "There's {b}no{/b} way I'm doing that other one!"

    hide johnGhost with easeoutleft
    pause 0.5

    scene black with fade
    "Without giving Kat any sort of explanation, I flew out of the room in search of the nearest dog."

    scene bg sky day with dissolve
    "I frantically searched around the school grounds for anyone walking a dog."

    think "Gotta find a dog! Any dog! Please, just let there be a dog!"

    scene bg house_yamashita exterior day
    show allison a_0:
        anchor (0.5,1.0) pos (0.35,1.0)
    show rudy a_0:
        anchor (0.5,1.0) pos (0.65,1.0)
    with dissolve
    "And then, like a beacon of hope in a sea of despair, I spotted her - Allison Stein, walking her small brown and white cocker spaniel across the sidewalk."

    show johnGhost a_15 at right, faceleft
    with easeinright
    think "There!"

    stop music fadeout 2.0
    play sound sfx_spell
    possess john rudy a_0
    "Without a second thought, I dove headfirst into the unsuspecting canine."

    play music bgm_just_nasty
    think "Woah... the smells! What are these smells?!"

    "The first thing I noticed was my nose being attacked by an assortment of unknown stenches."

    show john at faceleft, bcobounce
    john "Woof!"

    think "Did I just bark?"

    "The primal urge to chase squirrels, sniff butts, and roll in the grass overwhelmed me."

    "The dog's instincts were quickly taking over, leaving me powerless to resist."

    show allison b_20
    with exchange
    allison "Rudy! What's gotten into you?"

    show allison b_22
    with exchange
    think "Okay. Focus. I did the mission. I hopped into the damn dog's body. Now, I can finally return back and forget this ever happened."

    show john at faceleft, bcobounce
    "I tried to wrench myself free from the dog's body, but it was no use."

    show john at faceleft, bcobounce
    think "What's happening?! Why can't I leave?!"

    "My soul was scrambled with the dog's like a knot I couldn't untangle."

    show john at faceleft, bcobounce
    think "I'm stuck! I'm actually stuck in the dog's body!"

    "I tried to recant the spell again, but all that came out was--"

    show john at faceleft, bcobounce
    john "Woof!"

    "Panic was consuming me, but it was also accompanied by an unexpected sense of joy."

    "I looked up at Allison while my tail wagged with genuine enthusiasm."

    show john at faceleft, bcobounce
    think "Yippe! It's Allie!"

    show john at faceleft, bcobounce
    john "Woof! Woof!"

    "A happy bark escaped my new dog-lips."

    show allison b_21:
        ease 2.0 xpos 0.45 ypos 1.1
    allison "Aww... who wants pets? Is it you, girl? Is it you?"

    show allison b_22:
        xpos 0.45 ypos 1.1
    with exchange
    show john at faceleft, bcobounce
    think "It's me! It's me!"

    show john at faceleft, bcobounce
    john "Woof!"

    stop music fadeout 3.0

    "Allie's gentle pats filled me with a bliss no human could ever know."

    scene black with fade

    "Maybe, just maybe, this wasn't the end. Maybe it was a new beginning."

    play music bgm_fluffing_a_duck
    show bg house_stein bedroom_allison day
    show john a_0:
        anchor (0.5,1.0) pos (0.2,1.0)
    show allison a_0:
        anchor (0.5,1.0) pos (0.6,1.0)
        faceleft
    with dissolve
    "However, that all changed one morning when I woke up feeling off."

    show allison a_25
    with exchange
    "Allie, the best owner ever, noticed my malaise immediately."

    show allison a_27:
        ease 2.0 pos (0.4,1.1)
    allison "Rudy, what's wrong? You're not your usual bouncy self."

    show allison b_0
    with exchange
    allison "I know what'll cheer you up! Come on, let's go sniff my dirty laundry. That always makes you feel better, doesn't it?"

    scene black with fade

    "But not even Allie's dirty underwear could fix what was wrong with me."

    "With no options left, Allie forced me to see the vet."

    scene bg house_stein livingroom day
    show john a_0:
        anchor (0.5,1.0) pos (0.2,1.0)
    show gwen a_3:
        anchor (0.5,1.0) pos (0.4,1.2)
        faceleft
    show allison a_25:
        anchor (0.5,1.0) pos (0.8,1.0)
        faceleft
    with dissolve
    "The {q}vet{/q} was a stylish young blonde woman who apparently only did appointments via home visits."

    show gwen a_11:
        ease 1.0 ypos 1.0
    gwen "Hmm, this is a peculiar case. I've never seen anything quite like it."

    show allison a_5
    show gwen a_3:
        faceright
        ypos 1.0
    with exchange
    pause 0.5
    allison "What is it, doctor? Is she going to be okay?"

    show allison a_25
    with exchange
    show gwen a_11:
        ease 2.0 xpos 0.6
    gwen "I'm afraid your dog has contracted a rare and explosive condition. We in the industry call it... {i}Dog-itis.{/i}"

    show gwen a_3:
        pos(0.6,1.0)
    with exchange
    think "What a ridiculous diagnosis! There's no way this lady's actually licensed!"

    show allison a_5
    with exchange
    allison "Dog-itis? What does that mean?"

    show allison a_19
    show gwen a_11
    with exchange
    gwen "It means... your dog is going to explode unless you pay me boatloads of money right now."

    show gwen a_3
    with exchange
    "Allison gasped, and her eyes were wide with disbelief."

    show allison a_5
    with exchange
    allison "Explode?! But... how much time does she have?"

    show allison a_25
    show gwen a_11
    with exchange
    gwen "Not much, I'm afraid. Five..."

    show allison a_5
    show gwen a_3
    with exchange
    allison "Five what? Months?"

    show allison a_25
    show gwen a_11
    with exchange
    gwen "4..."
    extend " 3... 2... 1..."

    show gwen a_3 at faceleft
    with exchange
    pause 0.5

    with vpunch
    play sound sfx_explosion volume 0.2

    show allison a_19
    with exchange
    show john:
        easeout_expo 0.5 blur 30 zoom 2.0 alpha 0.0
        alpha 0.0
    "And then, in a burst of fur and confetti, I actually exploded."

    hide john

    body john john
    think "I died?!"
    extend " I actually died?!"

    show johnGhost a_0:
        alpha 0.0 blur 30 zoom 2.0
        centerleft
        ease 4.0 alpha 1.0 blur 0 zoom 1.0
        alpha 1.0 blur 0 zoom 1.0

    show allison a_25
    show gwen a_0 at faceright
    with exchange
    "Finally freed from my canine prison, I floated my ghostly form beside the tearful Allison and the smug vet."

    think "Well, that was certainly a unique way to go out."

    "I watched as Allie and the vet haggled over the fees."

    "Allie's face looked like she practically had to sign up to donate a kidney to cover the costs of my {q}healthcare{/q}."

    show allison a_26 with exchange
    pause 0.5

    hide gwen with easeoutright
    "Finally, the vet left, clutching a check that could probably fund a small country."

    think "Time to make my grand re-entrance into humanity!"

    play sound sfx_spell
    possess john allison a_16
    "The world snapped back into focus. I wiggled my fingers, my toes, my everything!"

    show john a_11
    with exchange
    think "Oh, the sweet ecstasy of opposable thumbs!"

    think "Freedom! I'm back, baby!"

    show john a_0 at faceright
    with exchange
    pause 0.5

    play sound sfx_running
    show john at offscreenright
    with easeoutright
    "I rushed over to Allie's kitchen."

    play sound sfx_running
    show john at center, faceleft
    with easeinright
    "After eating all the scraps in Allison's garbage can, I decided it was finally time to leave her body."

    play sound sfx_spell
    show john at bcobounce
    pause 2.0

    show john b_3
    with exchange
    think "Oh, for the love of kibble, not again!"

    show john b_18
    with exchange
    "My soul was intertwined with Allie's, just like it was when I possessed Rudy!"

    show john a_3
    with exchange
    "I wasn't going to panic. This time, I had a secret weapon: Allison's perfectly functional human vocal cords!"

    show john a_0
    with exchange
    "With Allie's human voice, I belted out the magic words."

    play sound sfx_spell
    show john a_11
    with exchange
    john "{spell}Anima a carne dimiruff!{/spell}"

    show john a_25
    with exchange
    "An awkward silence. My soul remained stubbornly glued to Allison's."

    show john a_5
    with exchange
    john "{q}Dimi-ruff?{/q} Why did I just add {q}ruff{/q} to the magic spell?"

    stop music fadeout  3.0

    show john a_3:
        anchor (0.5,1.0) pos (0.5,1.0) subpixel True
        ease 3.0 zoom 1.5 ypos 1.4
    show bg house_stein livingroom day:
        anchor (0.5, 0.5) pos (0.5,0.5) subpixel True
        ease 3.0 zoom 1.5
    "I pawsed for a moment and pawndered."

    pause 2.0

    play music bgm_snowfall

    show john b_3:
        zoom 1.5 ypos 1.4
    with exchange
    john "This is certainly a fur-midable ruff patch I've hit-woof."

    show john b_2
    with exchange
    "Despite my situation, I was determined not to panic."

    show john b_30
    with exchange
    john "I may be leashed to Allie's body, but I know anything is paws-ible if I just stay paws-itive!"

    show john b_10
    with exchange
    "I focused on the people in my life waiting for me that I could lean on for support."

    show john b_27
    with exchange
    john "I really should get help from my fur-ends and family-woof."

    show john b_17
    with exchange
    "And if there's anything I learned from from being Allie's dog, it was that adversity could be overcome one step at a time by allowing ourselves to be fueled by the small joys in life."

    show john b_12
    with exchange
    john "But fur-st, I think I'll help myself to some more of those trash scraps-woof!"

    show john a_11 at faceright
    with exchange
    john "Paw-lease fur-give me, Allie, but it's the leash you could do fur me!"
    extend " Bone apetite!"

    play sound sfx_running
    hide john with easeoutright
    pause 1.0

    show black with Dissolve(2.0)

    pause 2.0

    show bco_asset trash:
        subpixel True
        xalign 0.54
        ease 10.0 zoom 1.1
    with Dissolve (3.0)

    pause 5.0

    gameover "The Ending Where John Eats Out of the Garbage Can While in Allison's Body"

    pause 1.0
    return

label bco_end4:
    stop music fadeout 3.0
    show johnGhost a_15
    with exchange
    think "{q}Cat-related pet play?!{/q} Seriously?!"

    play music bgm_fluffing_a_duck
    show johnGhost at faceright
    with exchange
    pause 0.5

    play sound sfx_spell
    show johnGhost:
        anchor (0.5,1.0) pos (0.5,1.0)
        ease 2.0 pos (0.65, 2.0)
        pos (0.65, 2.0)
    "With no choice but to obey, I poured my astral essence into Katrina's comatose body."
    hide johnGhost
    body john katrina

    show john a_5 blush:
        anchor (0.5,1.0) pos (0.65,2.0)
        faceleft
        easein 4.0 ypos 1.0
        ypos 1.0
    "Unlike Cornelia's body, jamming myself into Kat's body felt more comfortable and spacious. I wasn't sure if it was because I'm more comfortable with Kat, the fact that her soul is missing, or the fact that she's not a midget."

    play sound sfx_spell
    show katrinaGhost:
        anchor (0.5,1.0) pos (0.8,1.0)
        ease 2.0 pos (0.35, 2.0)
        pos (0.35, 2.0)
    "With her real body being currently occupied, Kat had no choice but to insert her soul into my comatose body."
    hide katrinaGhost
    body katrina john
    show katrina a_13:
        anchor (0.5,1.0) pos (0.35, 2.0)
        easein 2.0 ypos 1.0
        ypos 1.0
    katrina "You just couldn't help yourself, huh?"

    show katrina a_0
    with exchange
    "Even though she spoke with my voice, she still had her signature tomboyish cadence."

    show john a_21 blush
    show katrina a_2
    with exchange
    john "Well, I guess you should've been more purr-suasive!"

    show john a_5 blush
    with exchange
    "Kat gave me the world's most disappointed stare."

    think "Hopefully that cat pun was enough to stop the curse?"

    show john a_10 blush:
        ypos 1.0
        bco_pain
    with exchange
    with vpunch
    play sound sfx_explosion volume 0.4
    think "My head!"

    think "Of course, it wasn't enough! I'm gonna have to commit to it!"

    stop music fadeout 3.0

    show john a_23 blush
    with exchange
    think "I'm so sorry, Kat!"

    transform bco_breathe:
        subpixel True
        ease 3.0 zoom 1.01
        ease 2.0 zoom 1.00
        repeat 9001


    play music bgm_kool_kats
    show john zorder 1:
        easeout 0.5 xpos 0.45
    pause 0.5
    show john b_5 blush:
        xpos 0.45
        bco_breathe
    with exchange
    john "Nyaaaa! I'm a kitty Kat!"

    show john b_19 blush at bco_breathe
    with exchange
    "I purred loudly, rubbing my face against Kat's arm. I even went so far as to start licking her shoulder."

    show katrina:
        ease 0.5 xpos 0.2
    pause 0.5
    show katrina a_13 blush:
        xpos 0.2
    with exchange
    katrina "Okay, okay! I get it! You're a {q}Kat!{/q} Har dee har har!"

    show john b_5 blush at bco_breathe
    show katrina a_6 blush
    with exchange
    john "Nya! Pet me more! I need pets from master!"

    show john b_19 blush at bco_breathe
    with exchange
    pause 0.5
    show katrina:
        ease 3.0 xpos 0.35
    "Kat sighed, but a smile crept onto her face as she hesitantly reached out and started stroking the top of my head."

    show katrina a_21 blush:
        xpos 0.35
    with exchange
    katrina "That's a {i}good girl!{/i}"

    show katrina a_0 blush
    with exchange
    show john a_19:
        easein 1.0 xpos 0.55
        bco_breathe
    think "Wait! Why is Kat actually letting this happen?!"

    show john a_21 blush:
        xpos 0.55
        bco_breathe
    with exchange
    john "Mrow?"

    show john a_5 blush at bco_breathe
    with exchange
    show katrina:
        ease 2.0 xpos 0.45
    "Kat started scratching behind my ears, sending a tingle down my spine."

    show katrina a_21 blush:
        xpos 0.45
    with exchange
    katrina "You know, I never thought I'd see you like this, but I always had my suspicions."

    show john a_21 blush at bco_breathe
    show katrina a_0 blush
    with exchange
    john "Like what-nya?"

    show john a_10 blush at bco_breathe
    show katrina a_21 blush
    with exchange
    katrina "So... {i}submissive.{/i}"
    show katrina a_10 blush
    with exchange
    extend " It's kinda hot."

    show katrina a_0 blush
    with exchange
    "My heart skipped a beat."

    show john a_5 blush at bco_breathe
    with exchange
    think "{q}Hot?{/q} Was she serious? Did she forget that this is {b}her{/b} body I'm violating here?!"

    show john a_21 blush at bco_breathe
    with exchange
    john "Okay! Okay! I think we've both had enough of this!"

    show john a_5 blush at bco_breathe
    with exchange
    think "This has already gone too far!"

    show katrina a_21 blush
    with exchange
    katrina "Aww, is the little kitty getting tired? Does she need a nap?"

    stop music fadeout 3.0

    show katrina a_0 blush
    with exchange
    "The way Kat wielded my voice while her eyes stared into my soul sent a feeling of reassurance and warmth throughout my body, making my heart flutter."

    think "What is this feeling? It's like a purr is rumbling deep within me, and I don't hate it!"

    play music bgm_summer_memories

    show bg school clubroom day:
        subpixel True
        ease 20.0 blur 10
        blur 10

    transform bco_hbreathe:
        subpixel True
        ease 3.0 zoom 1.02
        ease 2.0 zoom 1.00
        repeat 9001

    show john b_12 blush at bco_hbreathe
    with exchange
    john "M-maybe just a little nap..."

    show john b_19 blush at bco_hbreathe
    with exchange
    "I nuzzled into Kat's chest, and the steady rhythm of her heartbeat lulled me into a sense of profoundly animalistic peace."

    show katrina a_21 blush at bco_breathe
    with exchange
    katrina "There you go, sleepy kitty Kat. Just relax and let master take care of you."

    show john b_12 blush at bco_hbreathe
    show katrina a_0 blush at bco_breathe
    with exchange
    john "Meow..."

    show john b_19 blush at bco_hbreathe
    with exchange
    "Heat crept up my neck while a blush had begun staining Kat's cheeks."

    think "This is insane. I'm in Kat's body, being petted by myself, and I'm... enjoying it?"

    "A wave of arousal enveloped me. This foreign sensation both thrilled and terrified me."

    show katrina a_21 blush at bco_breathe
    with exchange
    katrina "It's okay. Just let go, kitty. Let master take care of you."

    show katrina a_0 blush at bco_breathe
    with exchange
    "Her hand trailed down my back, sending sparks of pleasure through this body."

    "I closed my eyes, surrendering to the dominance of her electric touch."

    show john b_18 blush at bco_hbreathe
    with exchange
    john "Yes, master! Please, pet me more!"

    show john b_19 blush at bco_hbreathe
    with exchange
    "I projected Kat's voice in a desperate plea. I arched my back, pressing my body against hers, craving the warmth of her friction."

    show katrina a_21 blush at bco_breathe
    with exchange
    katrina "Oh my, someone's getting a little eager, aren't we?"

    show katrina a_0 blush at bco_breathe
    with exchange
    "I writhed in her arms while I let the feline frenzy take hold of me. I rubbed my face against her, purring like a motor, demanding attention and affection."

    show john b_18 blush at bco_hbreathe
    with exchange
    john "More! More! I need more-nya!"

    show john b_19 blush at bco_hbreathe
    show katrina a_21 blush at bco_breathe
    with exchange
    katrina "Oh, you're a naughty kitty, aren't you?"

    show john b_18 blush at bco_hbreathe
    show katrina a_0 blush at bco_breathe
    with exchange
    john "Pet me! Please, master! I'll be your good little kitty Kat!"

    show john b_19 blush at bco_hbreathe
    with exchange
    "Her hands roamed my body, igniting a wildfire of sensation in me, and my hips instinctively grinded against hers."

    think "This is too much! I can't take this anymore!"

    scene black with fade

    "Unleashing the animal within, I furiously started clawing away at Kat's clothes."

    think "Curse or not, here I come."

    stop music fadeout 5.0

    pause 5.0

    play music bgm_say_goodbye
    scene bg sky dusk
    with dissolve
    yoshinori "The choices we make in life can lead us down dramatically different paths with dramatically different destinations."

    yoshinori "John, for one, has walked down a path carved not by luck or outside forces, but by the choices that John himself made."

    yoshinori "And as John's relationship with Katrina continues to grow, he too will continue to make more choices that will no doubt create more paths for him to walk."

    yoshinori "Indeed, John's ending has not yet... ended?"

    scene bg shrine exterior_festival dusk
    show yoshinori a_3 at center
    with dissolve
    yoshinori "Fuck! I messed up the damn ending again!"

    yoshinori "Why is it so hard to be profound? I'm a god, for crying out loud! I should be able to deliver a perfect closing narration!"

    scene black with dissolve
    pause 1.0

    show bco_asset katcat:
        subpixel True
        xalign 0.54
        ease 10.0 zoom 1.1
    with Dissolve (3.0)

    pause 5.0

    gameover "The Purr-suit of Happiness"

    return

label bco_menufail1:
    if bco_choicelabel  == "bad_choice3":
        show johnGhost a_11 at bco_pain
    else:
        show john a_11 at bco_pain
    with exchange
    with vpunch
    play sound sfx_explosion volume 0.5
    john "Aaaaahhhh!"

    play sound bco_sfx_gong volume 0.2
    show bco_white at bco_choose
    show yoshinoriGhost a_2 at bco_choose, center
    yoshinori "{size=+10}{b}You must choose!{/b}{/size}"

    if bco_choicelabel  == "bad_choice3":
        show johnGhost a_15
    else:
        show john a_15
    with exchange
    $ renpy.jump(bco_choicelabel)

label bco_menufail2:
    if bco_choicelabel  == "bad_choice3":
        show johnGhost a_11 at bco_pain
    else:
        show john a_11 at bco_pain
    with exchange
    with vpunch
    play sound sfx_explosion volume 0.5
    john "{size=+5}Aaaaagggghhhh!{/size}"

    play sound bco_sfx_gong volume 0.2
    show bco_white at bco_choose
    show yoshinoriGhost a_2 at bco_choose, center
    yoshinori "{size=+10}{b}You must choose! Or else!{/b}{/size}"

    if bco_choicelabel  == "bad_choice3":
        show johnGhost a_15
    else:
        show john a_15
    with exchange
    $ renpy.jump(bco_choicelabel)

label bco_end0:
    play sound bco_sfx_gong volume 0.2
    show bco_white at bco_choose
    show yoshinoriGhost a_2 at bco_choose, center
    yoshinori "{size=+10}{b}You have failed to choose!{/b}{/size}"

    yoshinori "{size=+10}{b}You have no right to call yourself a true man!{/b}{/size}"

    stop music fadeout 2.0
    scene black with fade
    pause 3.0

    jump bco_end0_1

label bco_end0_1:
    # I have no idea what this stuff even does hehe
    nvl clear
    $ nvl_window_style = "nvl_window_intro"
    scene black
    play music bgm_comfortable_mystery

    nvl show None
    window show

    scene intro_panorama:
        xanchor 0.0
        yanchor 0.0
    with Dissolve(0.7)

    intronvl "Okay, so let's talk about my friend John, the absolute {i}master{/i} of average."

    intronvl "Not that there's anything wrong with being average, mind you! But John takes it to a whole new level."

    intronvl "He's like, the definition of {q}unremarkable.{/q} Average house, average grades, average life, average everything."

    intronvl "But even still, I could always tell that he wanted something {i}more.{/i}"

    intronvl "The fact that he wanted something {i}more{/i} probably made him even {i}more{/i} unremarkable."

    # wtf is there trigonometry here for T.T
    show expression meteor_particles(750, head_particle_purple, tail_particle_purple) as meteor:
        transform_anchor True
        subpixel True
        rotate 12 - 180
        zoom 0.15
        pos (0.0, 0.05)
        0.5
        linear 8.0 pos (1.5, 0.05 + 1.5 * (16.0 / 9.0) * math.tan(12 * math.pi / 180.0)) zoom 0.4

    intronvl "And you know what? Maybe that's why it all happened to {i}him.{/i} The universe couldn't have picked a more average guy! Because let's face it, John wasn't exactly the type to go looking for trouble. He was more likely to trip over it."

    intronvl "But when the magical cosmic lottery came knocking, guess who answered the door? Yep, our very own Mr. Average."

    pause 3.0

    window hide
    nvl hide None
    nvl clear

    show intro_panorama:
        easeout 1.5 yalign 0.5
        easein 1.7 yalign 1.0
    show intro_trees:
        alpha 0.0
        ypos 1.0
        pause 0.1
        easeout 1.1 alpha 0.8 ypos 0.5
        easein 2.0 alpha 1.0 ypos 0.0
    show intro_silhouettes:
        alpha 0.0
        ypos 1.0
        pause 1.3
        easeout 0.7 alpha 0.5 ypos 0.5
        easein 1.2 alpha 1.0 ypos 0.0
    stop music fadeout 3.0
    pause 3.5

    play music bgm_destiny_day


    call screen bco_start_button

screen bco_start_button():
    textbutton "{size=+5}Start{/size}" action [ToggleScreen("bco_start_button"), Jump("bco_end0_2")] pos (0.1, 0.2) style "bco_textbutton"

label bco_end0_2:
    stop music fadeout 1.0
    title "Day 2" "Tina Koya School Gates"
    play music bgm_fluffing_a_duck
    scene bg school entrance day
    with dissolve

    body john katrina
    body katrina john

    $ john.name = "{q}Katrina{/q}"
    $ katrina.name = "{q}John{/q}"

    show john a_14 at centerright
    with dissolve

    "I waited patiently for John outside the school gates."

    "Tonight's the night that me and my D&D group were supposed to meet up, but my friend Emily couldn't make it."

    "Thankfully, John was able to sub in for her."

    show katrina a_21 at centerleft
    with easeinleft
    katrina "Hey, Kat! Sorry, I kept you waiting!"

    show katrina a_0
    show john a_0 at faceleft
    with exchange
    john "No problem!"

    show katrina a_21
    with exchange
    katrina "You said you needed me to use some kind of prop for tonight?"

    show katrina a_0
    with exchange
    john "Yeah..."

    "I reached into my bag and felt a wave of hesitation descend over me before handing him the prop book."

    $ bcobrightness = 0.0
    $ bco_choicelabel = "bad_choice0"

    jump bad_choice0

label bad_choice0:
    timedchoice 25.0 bco_endfail1 "Timeout Choice"
    menu:
        "{s}{q}You have to watch out for the magical pervert! He reincarnates people into their cute red-headed tomboy friends!{/q}{/s}":
            jump bco_endfail1
        "{s}{q}Careful with that! Magic is real, and this book is not a toy! It's an actual legit spell book that only you can use!{/q}{/s}":
            jump bco_endfail1
        "{q}Sure John! I have the prop right here!{/q}":
            jump bco_end0_3

label bco_endfail1:
    $ bco_choicestrike += 1
    $ bcobrightness -= 0.005
    if bco_choicestrike >= 100:
        jump bco_secret
    show john a_3 at bco_pain
    show bg school entrance day:
        matrixcolor BrightnessMatrix(bcobrightness)
    with exchange
    with vpunch
    play sound sfx_explosion volume 0.5
    john "Aaaaahhhh!"

    play sound bco_sfx_gong volume 0.2
    show bco_white at bco_choose
    show yoshinoriGhost a_1 at bco_choose, center
    yoshinori "{size=+10}{b}You must choose!{/b}{/size}"

    show john a_10
    with exchange
    $ renpy.jump(bco_choicelabel)

label bco_end0_3:
    show john b_5
    with exchange

    $ john.name = "John"

    john "Here's the book you're going to need, {i}John{/i}."

    show john b_19
    with exchange
    think "It's still as humiliating as ever to call {q}myself{/q} by my own former name."

    "The other me chuckled while examining the book."

    show katrina a_21
    with exchange
    katrina "{i}Ancient Archaic Arts of the Arcane?{/i} Where did you even get this thing?"

    show katrina a_0
    show john a_17
    with exchange
    john "Don't even get me started."

    scene black with fade

    stop music fadeout 3.0

    think "Gee, I can't wait to see how this version of me messes with cosmic powers beyond his understanding."

    "A part of me died inside, handing off the book to my clone."

    play music bgm_daybreak

    extend " But another part of me was actually excited."

    "Ever since the pervert-god cursed me into living out Kat's life, I had been watching closely over this universe's John."

    "I wasn't allowed to change the timeline too much, but in some small ways, I've been able to help John with a whole bunch of other things."

    "I always felt like such an imposter when I had to pretend like I was actually the real Kat."

    "Because this John turned out to be so much sweeter than I ever was, and I really wish I could just tell him the truth."

    "But until the day that the pervert-god lifts the curse, I'll just have to keep watching over him."

    "I'm sure the real Kat wouldn't mind that either."


    show bco_asset swing:
        ease 10.0 zoom 1.05
    with Dissolve (5.0)

    pause 5.0

    gameover "Kats Have Multiple Lives"

    return

label bco_secret:
    menu:
        "Never give up!":
            stop music fadeout 2.0
            show john a_0 with exchange
            "After I weathered one hundred of the pervert god's attacks, something incredible happened."

    # John confronts the pervert god
    play sound sfx_swirl1 volume 0.5
    image bco_white = Solid("#fff")
    show bco_white behind john:
        alpha 0
        ease 3.0 alpha 1.0
    show katrina:
        ease 3.0 alpha 0
    pause 5.0

    play music bco_bgm_brand_new_horizon_destiny_day
    show yoshinori a_0 at centerleft
    with Dissolve(3.0)
    pause 3.0

    with hpunch
    show yoshinori a_3
    yoshinori "{b}{size=+5}That's enough!{/size}{/b}"

    show john b_24
    show yoshinori a_0
    with exchange
    john "Finally, you've come!"

    show john b_21
    show yoshinori a_3
    with exchange
    yoshinori "What is the meaning of this?! Why can't you just make a damn choice?!"

    show john b_24
    show yoshinori a_0
    with exchange
    john "Pervert god, I've come to bargain!"

    show john b_21
    show yoshinori a_3
    with exchange
    yoshinori "Bargain? That's not the sort of deal this is, you moron!"

    show john b_24
    show yoshinori a_0
    with exchange
    john "I don't care what it is! I'm a man of principle, and I'd die before submitting to the whims of some pervert!"

    show john b_21
    show yoshinori a_3
    with exchange
    yoshinori "All you need to do is learn one damn lesson, and you can't even do that!"

    show john b_24
    show yoshinori a_0
    with exchange
    john "To hell with your {q}lesson!{/q}"

    john "I won't let anyone decide my fate. If I don't like the choices you give me, I'll make my own, and I'll never give in! You know why?"

    show john b_23
    with exchange
    john "{b}Because I do have the fiery righteous soul of a true man!{/b}"

    show john a_0
    show yoshinori a_3
    with exchange
    yoshinori "Ugh! You're impossible!"

    yoshinori "Fine! I'll leave you alone, you fuckin' freak!"

    show bco_white:
        ease 3.0 alpha 0.0
    show yoshinori:
        ease 3.0 alpha 0.0
    show katrina a_2:
        ease 3.0 alpha 1.0
    show bg school entrance day:
        matrixcolor BrightnessMatrix(0.0)
        ease 3.0 matrixcolor BrightnessMatrix(0.1)
    pause 3.0

    # John says farewell to John
    "After that, the pervert god disappeared from my life, never to be seen again."

    show katrina a_13
    with exchange
    katrina "{size=-5}...Kat?{/size}"
    extend " Kat!"

    show john a_21
    show katrina a_2
    with exchange
    john "Yes, John, I'm here."

    show katrina a_13
    show john a_5
    with exchange
    katrina "Kat, are you okay? I just asked you for the prop, and then you started muttering something about having the soul of a true man?"

    show katrina a_2 blush with exchange
    show john:
        ease 2.0 anchor (0.5,1.0) pos (0.4,1.0)
    "I walked over to John and gave him a hug."

    show john a_21
    with exchange
    john "Yes, John. You {i}do{/i} have the soul of a true man."

    show john a_13
    with exchange
    john "Never let anyone try to change you or tell you otherwise."

    show john a_0
    with exchange
    "I reached into my bag and handed John the magic book."

    show john a_13
    with exchange
    john "Here, promise me you'll take good care of this. It's important."

    show katrina a_13
    show john a_0
    with exchange
    katrina "O-of course. I wouldn't mess up your stuff."

    show katrina a_2 with exchange
    show john a_13:
        ease 2.0 pos (0.65,1.0)
    john "It's time for me to go, John."

    show katrina a_13
    show john a_0
    with exchange
    katrina "Go where? You're kinda freaking me out over here."

    show katrina a_2
    show john a_13
    with exchange
    john "It's time for me to walk my own path. Not the path set out for me by anyone else."

    show katrina a_13
    show john a_0
    with exchange
    katrina "O-okay... have fun with that."

    stop music fadeout 3.0

    show katrina a_0
    show john at faceright
    with exchange
    pause 0.5

    hide john with easeoutright

    scene black with fade

    # Walking
    transform bco_walk:
        subpixel True
        ease 0.3 ypos 1.05
        ease 0.3 ypos 1.00
        repeat
    scene bg school field day:
        anchor (0.0,0.0) pos (0.0,0.0)
    show bco_bg field:
        anchor (0.0,0.0)
        faceleft
        xpos 1.0 ypos 0.0
    show john a_0 at center
    with dissolve
    pause 1.0
    show bg school field day:
        xpos 0.0
        linear 8.0 xpos -1.0
        xpos 1.0
        linear 8.0 xpos 0.0
        repeat
    show bco_bg field:
        xpos 1.0
        linear 8.0 xpos 0.0
        linear 8.0 xpos -1.0
        repeat
    show john:
        anchor (0.5,1.0)
        center
        bco_walk
    play music bco_bgm_lostep

    pause 10.0

    show john:
        parallel:
            ease 0.5 xzoom 1.2 yzoom 0.7
        parallel:
            bco_walk

    pause 4.5

    show john:
        parallel:
            ease 0.5 xzoom 1.0 yzoom 1.0
        parallel:
            bco_walk

    pause 4.5

    show john:
        parallel:
            ease 0.5 xzoom 0.8 yzoom 1.2
        parallel:
            bco_walk
        parallel:
            transform_anchor True
            ease 0.3 rotate 5
            ease 0.3 rotate -5
            repeat

    pause 5.5

    show john:
        parallel:
            ease 0.5 xzoom 1.0 yzoom 1.0 rotate 0
        parallel:
            bco_walk

    # 29s
    pause 4.5


    show john:
        parallel:
            ease 0.5 xzoom 1.1 yzoom 0.9
        parallel:
            bco_walk

    # 31s
    pause 2.0


    show john:
        parallel:
            ease 0.5 xzoom 1.2 yzoom 0.8
        parallel:
            bco_walk

    # 32.5s
    pause 1.5

    show john:
        parallel:
            ease 0.5 xzoom 1.4 yzoom 0.6
        parallel:
            bco_walk

    pause 1.0

    show john:
        parallel:
            ease 0.5 xzoom 0.8 yzoom 1.2
            bco_walk
        parallel:
            transform_anchor True
            ease 0.3 rotate 5
            ease 0.3 rotate -5
            repeat

    # 37.5s
    pause 5.0

    show john:
        parallel:
            ease 0.5 xzoom 1.1 yzoom 0.9 rotate 0
        parallel:
            bco_walk

    # 39.5s
    pause 2.0

    show john:
        parallel:
            ease 0.5 xzoom 1.2 yzoom 0.8
        parallel:
            bco_walk

    # 40.5s
    pause 1.0

    show john:
        parallel:
            ease 0.5 xzoom 1.4 yzoom 0.6
        parallel:
            bco_walk

    # 41.5s
    pause 1.0
    show john:
        parallel:
            ease 0.5 xzoom 0.8 yzoom 1.2
        parallel:
            bco_walk
        parallel:
            transform_anchor True
            ease 0.3 rotate 5
            ease 0.3 rotate -5
            repeat

    # 46.5s
    pause 5.0
    show john a_19:
        parallel:
            ease 0.5 rotate 0 xzoom 1.0 yzoom 1.0
        parallel:
            linear 0.1 xoffset 3
            linear 0.1 xoffset -3
            repeat
        parallel:
            bco_walk
        parallel:
            faceright
            1.0
            faceleft
            1.0
            faceright
            repeat

    # 51s
    pause 4.5
    show john a_0:
        faceright
        parallel:
            ease 0.5 xzoom 0.8 yzoom 1.2 xoffset 0
        parallel:
            transform_anchor True
            ease 0.3 rotate 5
            ease 0.3 rotate -5
            repeat
        parallel:
            bco_walk

    # 56s
    pause 5.0
    show john a_19:
        parallel:
            ease 0.5 rotate 0 xzoom 1.0 yzoom 1.0
        parallel:
            linear 0.1 xoffset 3
            linear 0.1 xoffset -3
            repeat
        parallel:
            bco_walk
        parallel:
            faceright
            1.0
            faceleft
            1.0
            faceright
            repeat

    # 61s
    pause 4.5
    with vpunch
    show john a_0:
        parallel:
            ease 0.5 rotate 0 xzoom 1.0 yzoom 1.0 blur 15 zoom 1.5 alpha 0
        parallel:
            bco_walk
    show johnGhost a_0:
        parallel:
            center
        parallel:
            linear 0.3 zoom 1.0
            linear 0.3 zoom 1.1
            repeat

    # 66s
    pause 5.0
    show john a_0:
        parallel:
            ease 0.5 blur 0 zoom 1.0 alpha 1.0
        parallel:
            bco_walk
    hide johnGhost with dissolve

    # 72.5s
    stop music fadeout 7.0
    scene black with Dissolve(7.0)
    pause 2.0

    gameover "Indomitable Human Spirit"
