from abc import ABCMeta

try:
    from renpy.store import persistent
except:
    pass

# Raw Character Database


class Profile:
    __metaclass__ = ABCMeta

    base_name = "fill"
    name = "fill"
    emotion = "fill"
    description = "fill"
    tags = ["fill"]
    background = "fill"


# Database Persistent Flags:
#     $ persistent.fAbbyBodyDB
#     $ persistent.fAllisonRuseDB
#     $ persistent.fHankNameDB
#     $ persistent.fHollySexualityDB
#     $ persistent.fJohnAbductedDB
#     $ persistent.fJohnSpellbookDB
#     $ persistent.fMattNameDB
#     $ persistent.fRachelDelinquencyDB
#     $ persistent.fSandraSpellbookDB
#     $ persistent.fToriSexualityDB
# These should be tripped as true at specific points within routes.
# Doing so will permanently alter the character's database entry to reflect the change.
# Multiple routes that reveal the same detail can share the same flag without issue.
# New Database Flags must also be pre-set as false in persistent.rpy, otherwise the game will get upset.


class Abby(Profile):
    base_name = "abby"
    name = "Abby Luten"
    emotion = "a_0"
    outfit = "suit"
    accessories = ""
    tags = ["Female", "Principal"]
    background = "bg school office_abby day"

    @property
    def description(self):
        text = (
            "The principal of Tina Koya High School. "
            "John hasn't met with her very often. "
            "An older woman who has dedicated a lot to her career, she spends "
            "much of her time worrying over running the school."
        )
        if persistent.fAbbyBodyDB:
            text += (
                " She suffers from a number of health issues, including chronic"
                " migraines. She would do anything to escape that, even steal another"
                " person's body."
            )
        else:
            text += " She seems stressed due to something."
        return text


class Alex(Profile):
    base_name = "alex"
    name = "Alex Hawkins"
    emotion = "a_0"
    outfit = "casual"
    accessories = "glasses"
    description = (
        "The P.E. and health teacher at Tina Koya High School, the guidance counselor,"
        " and also the athletics coach. She attended Tina Koya herself several years"
        " ago and was an excellent student, inspiring her brother, Claus, to try to"
        " follow in her footsteps. Though rare in women, she seems to have some form of"
        " colorblindness."
    )
    tags = ["Female", "Teacher"]
    background = "bg school gym day"


class Allison(Profile):
    base_name = "allison"
    name = "Allison Stein"
    emotion = "a_0"
    outfit = "uniform"
    accessories = "braids"
    tags = ["Female", "Student", "Popular Clique", "Wealthy"]
    background = "bg school entrance day"

    @property
    def description(self):
        text = (
            "Part of the popular clique and Irene's childhood friend,"
            " sometimes known as {q}Alice.{/q} Allison seems to be a very polite"
            " and kind individual, which contrasts a bit with her friends."
        )
        if persistent.fAllisonRuseDB:
            text += (
                " Her airheadedness is a ploy to hide her deep insecurities,"
                " but she secretly wishes for her friends to see her for who she truly is."
            )
        else:
            text += " She is more than a little airheaded, and her gullibility is a cause of concern for Irene."
        return text


class Anuja(Profile):
    base_name = "anuja"
    name = "Anuja Killada"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A foreign exchange student from India currently being hosted by Michelle's"
        " family. She's a very polite and soft-spoken person, and is still adapting to"
        " the environment. Though she usually avoids talking about it, she seems to"
        " have some problems with her mother back home."
    )
    tags = ["Female", "Student", "D&D Group", "Foreign Exchange Student"]
    background = "bg house_bloom livingroom day"


class Audrey(Profile):
    base_name = "audrey"
    name = "Audrey Callahan"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "A first-year at the university, with an undecided major. "
        "Though she's not old enough to drink, she sometimes uses her social skills to get some booze. "
    )
    tags = ["Female", "College Student"]
    background = "bg university courtyard"


class Brad(Profile):
    base_name = "brad"
    name = "Brad Chambers"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "One of the most popular guys at Tina Koya High, and one of the school's top"
        " athletes. He's a gregarious and easygoing student, but a tumultuous home life"
        " has made him overprotective of his sister Zoey. Brad is best friends with"
        " Eric, and doesn't like Kiyoshi due to his sister's strange attachment to him."
    )
    tags = ["Male", "Student", "Athletics"]
    background = "bg school field day"


class Carrie(Profile):
    base_name = "carrie"
    name = "Carrie Parker"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "John's next-door neighbor. Her parents have chosen to homeschool her, so she"
        " doesn't go to class with the others. She doesn't get to interact very much"
        " with others her age, so she's taken a very particular interest in John. She"
        " tries to meet him in front of his house every morning before he goes to"
        " school, to mixed success."
    )
    tags = ["Female", "Neighbor"]
    background = "bg house_davis exterior day"


class Cassie(Profile):
    base_name = "cassie"
    name = "Cassandra {q}Cassie{/q} Wright"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "A student at the local college and a friend of John's sister, Holly. Though"
        " she has been over a few times, John has interacted with her very little."
        " Somewhat snobbish due to her social status, she always has a maid, Elizabeth,"
        " with her wherever she goes."
    )
    tags = ["Female", "College Student", "Wealthy"]
    background = "bg house_wright exterior day"


class Charlotte(Profile):
    base_name = "charlotte"
    name = "Charlotte Foster"
    emotion = "b_0"
    outfit = "casual_hairloop"
    accessories = ""
    description = (
        "A fashion design major at the local college. Charlotte is typically somewhat"
        " scatterbrained, kept in check by her best friend, Naomi. She has a tendency"
        " to embarrass herself in public, which sometimes deters her from pursuing"
        " anyone romantically. Despite sharing a major with fellow student Cassandra,"
        " she's often jealous of all the outfits she can afford."
    )
    tags = ["Female", "College Student"]
    background = "bg university courtyard"


class Circe(Profile):
    base_name = "circe"
    name = "Circe"
    emotion = "a_0"
    outfit = "nude"
    accessories = ""
    description = (
        "A demon summoned by John during a magic ritual. She boasts having great power"
        " and pretty much any wish you can think of may be granted by her-- for a"
        " price. She's granted enough wishes over her long life that she gets amusement"
        " in twisting the thoughtless or altruistic wishes of new and unprepared"
        " summoners."
    )
    tags = ["Female", "Supernatural"]
    background = "bg house_davis bedroom_john dark"


class Claus(Profile):
    base_name = "claus"
    name = "Claus Hawkins"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "The vice president of the Student Council who, like Yui, is a well-known"
        " stickler for school rules. He greatly admires his sister, Alex, and has taken"
        " up many of the duties she once held while she was a student. He's often seen"
        " discussing council business with Yui, or keeping watch over the newspaper"
        " club as the editor."
    )
    tags = ["Male", "Student", "Student Council", "Newspaper Club"]
    background = "bg school clubroom day"


class Connie(Profile):
    base_name = "connie"
    name = "Connie Williams"
    emotion = "a_0"
    outfit = "suit"
    accessories = ""
    description = (
        "A math teacher at Tina Koya who also oversees John's homeroom. A very kind"
        " woman, she tries hard to gain the favor of her students. Unfortunately she"
        " has a peculiar sense of humor, often telling lame jokes and puns which only"
        " Kiyoshi seems to appreciate."
    )
    tags = ["Female", "Teacher"]
    background = "bg school classroom_1"


class Cornelia(Profile):
    base_name = "cornelia"
    name = "Cornelia Roberts"
    emotion = "a_5"
    outfit = "uniform"
    accessories = ""
    description = (
        "Part of Sayaka's friend group. She's somewhat clingy and desperate for"
        " approval, causing her to always hang by Sayaka's side parroting her every"
        " opinion. Her small stature is a sensitive subject for her, but it also makes"
        " her an excellent flier on the cheerleading squad."
    )
    tags = ["Female", "Student", "Cheerleader", "Popular Clique", "Wealthy"]
    background = "bg school hallway_2 day"


class Dominic(Profile):
    base_name = "dominic"
    name = "Dominic Carter"
    emotion = "b_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A college student working part-time at the mall's French restaurant, {i}Serenade,{/i} to make ends meet."
    )
    tags = ["Male", "College Student", "Mall Worker"]
    background = "bg mall restaurant day"


class Donna(Profile):
    base_name = "donna"
    name = "Donna Barnes"
    emotion = "a_3"
    outfit = "suit"
    accessories = ""
    description = (
        "Secretary to the principal at Tina Koya High School. "
        "Besides filing and sorting paperwork, she also lets students "
        "who have been sent to the principal's office in to see Ms. Luten, "
        "and oversees classrooms in the event of a teacher's sudden absence. "
        "She has a bad habit of humming while she works, which drives Abby crazy."
    )
    tags = ["Female", "School Secretary"]
    background = "bg school office_donna"


class Elizabeth(Profile):
    base_name = "elizabeth"
    name = "Elizabeth Sebas"
    emotion = "a_0"
    outfit = "maid"
    accessories = "hairbun"
    description = (
        "A loyal maid of the Wright family, and intimate confidant of the daughter,"
        " Cassandra. Her empathetic and virtuous character is only matched by her great"
        " sense of responsibility."
    )
    tags = ["Female", "Maid"]
    background = "bg house_wright dining_room night"


class Emily(Profile):
    base_name = "emily"
    name = "Emily Brooks"
    emotion = "b_1"
    outfit = "casual"
    accessories = ""
    description = (
        "A student at Tina Koya High. She's known for her spontaneous nature and is"
        " always jumping at the chance to try something new. Her hobbies include"
        " cosplay and playing D&D with her friends, Kat, Michelle, and Anuja."
    )
    tags = ["Female", "Student", "D&D Group"]
    background = "bg house_bloom livingroom night"


class Eric(Profile):
    base_name = "eric"
    name = "Eric Tyner"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A slacker student, and Brad's best friend. He's a smoker, and often has to"
        " endure the wrath of Yui or Claus whenever he gets caught trying to sneak in a"
        " smoke break at school. He's also in a relationship with Maria, who often"
        " drags him off to more secluded locations."
    )
    tags = ["Male", "Student", "Boxing Club", "Delinquent"]
    background = "bg school passage day"


class Faith(Profile):
    base_name = "faith"
    name = "Faith Reinhardt"
    emotion = "a_0"
    outfit = "nude"
    accessories = ""
    description = (
        "A spooky ghost who haunts the girl's locker room. The circumstances in how she"
        " came to haunt the school are unknown, though there are many rumors. Most say"
        " she doesn't exist, but of course Kiyoshi is willing to investigate just about"
        " anything, especially if it involves the girl's locker room. Somehow, she"
        " looks familiar..."
    )
    tags = ["Female", "Supernatural"]
    background = "bg school lockerroom"


class Flavia(Profile):
    base_name = "flavia"
    name = "Flavia Lucca"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "An athletic, kindhearted, and beautiful girl at Tina Koya High School. She's"
        " the captain of the swim team and has been leading them to victory in many"
        " competitions lately. In addition, she's a member of the Student Council."
        " Despite her popularity and the pedestal people put her on, she surprisingly"
        " doesn't have a boyfriend."
    )
    tags = ["Female", "Student", "Swimming Team", "Student Council"]
    background = "bg school pool day"


class Gabriel(Profile):
    base_name = "gabriel"
    name = "Gabriel Riel"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A mysterious student. He seems to have an interest in the occult "
        "and pseudo-scientific subjects. Doesn't have many friends due to his "
        "often-condescending attitude."
    )
    tags = ["Male", "Student"]
    background = "bg school hallway_1 day"


class Genny(Profile):
    base_name = "genny"
    name = "Genny Collins"
    emotion = "b_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A student at Tina Koya High School, and childhood friend of Riley. She's"
        " studious, phlegmatic, and even-tempered, but enjoys teasing her"
        " easily-flustered friend. Her full first name is {q}Genevieve,{/q} but she"
        " doesn't seem to like it much and insists on {q}Genny.{/q}"
    )
    tags = ["Female", "Student"]
    background = "bg school entrance day"


class Grace(Profile):
    base_name = "grace"
    name = "Grace Reinhardt"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "The school's resident nurse. She's a slightly apathetic and pessimistic woman"
        " who doesn't hold back when talking to students. It's a well-known secret"
        " throughout the school that she has a drinking problem, and that she even has"
        " a stash hidden somewhere in her office."
    )
    tags = ["Female", "School Nurse"]
    background = "bg school infirmary day"


class Greg(Profile):
    base_name = "greg"
    name = "Greg Fisk"
    emotion = "a_0"
    outfit = "suit"
    accessories = ""
    description = (
        "A biology teacher at Tina Koya High School. Though fairly stern at times, "
        "he enjoys teaching his students and enthusiastically rewards hard work. "
        "Despite his chosen career, he's actually pretty squeamish about dissections."
    )
    tags = ["Male", "Parent", "Teacher"]
    background = "bg school classroom_2"


class Gwen(Profile):
    base_name = "gwen"
    name = "Gwen Strauss"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "A clerk at one of the mall's many clothing stores. She has a keen eye for"
        " women's fashion, and a keener eye for women in general. Despite this, as a"
        " retail worker she puts up with a lot of abuse from picky, snobbish, or rude"
        " customers."
    )
    tags = ["Female", "Mall Worker"]
    background = "bg mall clothing_store"


class Hank(Profile):
    base_name = "hank"
    emotion = "a_0"
    outfit = "formal"
    accessories = ""
    tags = ["Male", "Parent"]

    @property
    def name(self):
        text = "Hank"
        if persistent.fHankNameDB:
            text += " Vega"
        return text

    @property
    def description(self):
        if persistent.fHankNameDB:
            text = (
                "Tori's father, a burly auto mechanic with his own shop. He enjoys"
                " gardening in his spare time. A widower for some time now, he's"
                " recently re-entered the dating scene in search of a new wife and a"
                " step-mother for Tori."
            )
        else:
            text = (
                "A burly auto mechanic with his own shop. He enjoys gardening in his "
                "spare time. A widower for some time now, he's recently "
                "re-entered the dating scene in search of a new wife."
            )
        return text

    @property
    def background(self):
        if persistent.fHankNameDB:
            text = "bg house_vega exterior day"
        else:
            text = "bg bar dusk"
        return text


class Hestia(Profile):
    base_name = "hestia"
    name = "Hestia Virelles"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "Irene's younger sister, and a friend of Natsumi and Jess. "
        "She's a quiet child and is often off in her own little world, but when "
        "she does speak she has a habit of being blunt or condescending. "
        "She enjoys playing with her house's fireplace."
    )
    tags = ["Female", "Elementary Student"]
    background = (  # Replace with Virelles household when applicable.
        "bg elementary playground day"
    )


class Holly(Profile):
    base_name = "holly"
    name = "Holly Davis"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    tags = ["Female", "Family", "College Student"]
    background = "bg house_davis bedroom_holly day_shut"

    @property
    def description(self):
        text = (
            "John's older sister, and a student at the local college. She used to be"
            " outgoing and have a wonderful relationship with her brother, but a couple"
            " of years ago she suddenly became very sullen and withdrawn, especially"
            " around John. John often wishes he could restore his relationship with her"
            " back to how it used to be."
        )
        if persistent.fHollySexualityDB:
            text += " She's been keeping her homosexuality a secret for some time."
        return text


class Irene(Profile):
    base_name = "irene"
    name = "Irene Virelles"
    emotion = "b_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "Part of Sayaka's group, and a member of the school's volleyball team. She's"
        " protective of Allison, and doesn't seem to like the way the other popular"
        " girls influence or take advantage of her. This causes some friction between"
        " her and Sayaka."
    )
    tags = ["Female", "Student", "Popular Clique", "Athletics"]
    background = "bg school field day"


class Izuna(Profile):
    base_name = "izuna"
    name = "Izuna Ito"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A student with sharp senses and a sharper blade. "
        "Her nigh-superhuman athletic prowess is known to impress, as well. "
        "She usually speaks in a serious and disciplined manner, "
        "but is known to crack a joke on rare occasion. "
        "Despite sharing a mutual friend in Setsuna, John and Izuna seldom cross paths."
    )
    tags = ["Female", "Student", "Swordplay Club"]
    background = "bg school hallway_1 day"


class Jack(Profile):
    base_name = "jack"
    name = "Jack Mallory"
    emotion = "a_0"
    outfit = "suit"
    accessories = ""
    description = (
        "An abrasive history teacher at Tina Koya High School. He seems to deeply enjoy"
        " lecturing about bloody revolutions, the inquisition, and other violent"
        " events, particularly if they involve torture devices. Though he is well-known"
        " for being a jerk to his students, he seems especially fond of targeting John"
        " specifically."
    )
    tags = ["Male", "Teacher", "Asshole"]
    background = "bg school office_jack"


class Jess(Profile):
    base_name = "jess"
    name = "Jess Morgan"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "The youngest child of the Morgan household. "
        "A bright young girl who's almost as energetic as her sister, Kat. "
        "She's best friends with Natsumi and Hestia."
    )
    tags = ["Female", "Elementary Student"]
    background = "bg house_morgan livingroom day"


class John(Profile):
    base_name = "john"
    name = "John Davis"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    background = "bg house_davis bedroom_john day_shut"

    @property
    def description(self):
        text = (
            "John is the main character of this story. An all-around average guy,"
            " though he has a few surprises hidden up his sleeve"
        )
        if persistent.fJohnAbductedDB and persistent.fJohnSpellbookDB:
            text += ", such as an alien device or magical heritage"
        elif persistent.fJohnAbductedDB:
            text += ", such as an alien device"
        elif persistent.fJohnSpellbookDB:
            text += ", such as magical heritage"
        text += (
            ". He would rather spend most of his time playing video games instead of"
            " studying. Surprisingly good at speaking different languages and making"
            " new friends."
        )
        return text

    @property
    def tags(self):
        list = ["Male", "Student", "Protagonist"]
        if persistent.fJohnSpellbookDB:
            list.insert(2, "Supernatural")
        return list


class Katrina(Profile):
    base_name = "katrina"
    name = "Katrina Morgan"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "One of John's close friends since the beginning of high school. Although she"
        " was without friends at the time, she now regularly hangs out with John's"
        " circle as well as her D&D group. She's very fun-loving and likes to joke"
        " around, but sometimes her jokes go a little too far. She seems to really"
        " dislike Sayaka for some reason."
    )
    tags = ["Female", "Student", "Friend", "D&D Group"]
    background = "bg house_morgan bedroom_katrina day"


class Kiyoshi(Profile):
    base_name = "kiyoshi"
    name = "Kiyoshi Honda"
    emotion = "a_0"
    outfit = "uniform"
    accessories = "glasses"
    description = (
        "One of John's closest friends. He's a huge conspiracy nut and comes up "
        "with many insane theories. He also believes himself to be a ladies' man, "
        "and continually attempts to hit on most pretty girls he sees. "
        "Despite the trouble he causes, he's been a fast and true friend of John's "
        "social circle since middle school."
    )
    tags = ["Male", "Student", "Friend"]
    background = "bg house_honda bedroom_kiyoshi day"


class Kyoko(Profile):
    base_name = "kyoko"
    name = "Kyoko Hano"
    emotion = "a_0"
    outfit = "uniform"
    accessories = "glasses"
    description = (
        "John's childhood friend. The two of them are still very close. She shares many"
        " interests with Kiyoshi, and is the one who introduced him to John. Recently"
        " she seems to be having problems with some of the other girls at school."
    )
    tags = ["Female", "Student", "Friend", "Childhood Friend"]
    background = "bg house_hano bedroom_kyoko day_computer"


class Laura(Profile):
    base_name = "laura"
    name = "Laura Morgan"
    emotion = "a_0"
    outfit = "suit"
    accessories = ""
    description = (
        "Katrina's mother. She's an office worker for a large company, which keeps her"
        " busy for most of the day. Loves her children dearly, and wishes she had more"
        " time for them."
    )
    tags = ["Female", "Parent"]
    background = "bg house_morgan livingroom dusk"


class Leona(Profile):
    base_name = "leona"
    name = "Leona Winters"
    emotion = "a_0"
    outfit = "suit"
    accessories = ""
    description = (
        "An English teacher at school who is also John's neighbor. "
        "She's been friends with Sandra and Yuuna for a long time. "
        "She lives alone, and has been trying to change that fact without much success."
    )
    tags = ["Female", "Teacher", "Neighbor", "Family Friend"]
    background = "bg house_winters garden day"

class Maki(Profile):
    base_name = "maki"
    name = "Maki Hano"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "Kyoko's mother and wife of Sojiro. She works as a pharmacist at the local hospital."
        " Unlike her daughter, she's more interested in fashion and appearance but"
        " doesn't impose her interests on her daughter. At first glance she seems cold and"
        " distant; getting to know her reveals a warm-hearted and kind person."
    )
    tags = ["Female", "Parent"]
    background = "bg house_hano livingroom day"

class Maria(Profile):
    base_name = "maria"
    name = "Maria Grandales"
    emotion = "a_0"
    outfit = "uniform"
    accessories = "camera"
    description = (
        "A member of the newspaper club who always carries her camera around with her."
        " She's the biggest gossip in the school, and this reflects in the articles and"
        " photos she publishes in the paper. It's a good bet that if she finds out a"
        " big secret, the whole school will know soon after. She's also very open about"
        " her sex life, and often sneaks away her boyfriend Eric for some private time."
    )
    tags = ["Female", "Student", "Newspaper Club"]
    background = "bg school newsroom day"


class Marty(Profile):
    base_name = "marty"
    name = "Marty"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "A bartender at the local pub. He's affable enough, and his wry smirk makes him"
        " pretty popular with the female clientele."
    )
    tags = ["Male"]
    background = "bg bar dusk"


class Matt(Profile):
    base_name = "matt"
    emotion = "a_0"
    outfit = "formal"
    accessories = ""
    description = (
        "A manager of a company that establishes digital storefronts "
        "for small businesses, and a friend of Hank's from high school. "
        "He's also an avid collector of retro video games. "
        "Lately he's been seeking a woman to settle down with."
    )
    tags = ["Male"]

    @property
    def name(self):
        text = "Matt"
        if persistent.fMattNameDB:
            text += " Davidson"
        return text
        # This one is only a spoiler to avoid calling attention to Hank's mononym.

    @property
    def background(self):
        if persistent.fMattNameDB:
            text = "bg house_davidson livingroom night"
        else:
            text = "bg bar dusk"
        return text


class Maurice(Profile):
    base_name = "maurice"
    name = "Maurice Honda"
    emotion = "a_0"
    outfit = "suit"
    accessories = ""
    description = (
        "Kiyoshi's uncle who took him in after his parents died. He works as a"
        " detective, and is often away because of work, leaving Kiyoshi alone at home"
        " most of the time. He greatly enjoyed detective stories in his youth, which is"
        " why he became one. He loves telling stories about his own adventures, but"
        " often repeats the same ones over and over."
    )
    tags = ["Male", "Parent"]
    background = "bg house_honda livingroom dusk"


class Mel(Profile):
    base_name = "mel"
    name = "Melanie {q}Mel{/q} Larner"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A member of the school's swim team alongside Flavia. She's very energetic and"
        " uses that energy as part of the swim team. Besides Flavia, she's also close"
        " friends with Zoey and the Hubbard twins. She grew up in a rural part of"
        " Osaklahoma, and speaks with somewhat of a southern drawl."
    )
    tags = ["Female", "Student", "Swimming Team"]
    background = "bg school pool day"


class Michelle(Profile):
    base_name = "michelle"
    name = "Michelle Bloom"
    emotion = "a_0"
    outfit = "uniform"
    accessories = "glasses"
    description = (
        "One of the members of the school's newspaper club. Her family also acts as the"
        " host family for Anuja. She's a bright student, though a bit sneaky and"
        " conniving at times. She and Anuja host a D&D group at her house that Katrina,"
        " Emily, and sometimes John attend."
    )
    tags = ["Female", "Student", "Newspaper Club", "D&D Group"]
    background = "bg house_bloom livingroom day"


class Mina(Profile):
    base_name = "mina"
    name = "Mina Hubbard"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "The near-identical twin sister of Phila. Compared to her sister, Mina is very"
        " shy and meek, but is skilled at cooking. She only seems to talk to those whom"
        " she's come to trust, such as Zoey and Mel. She's always seen with her sister"
        " and seems to depend heavily on her to get through the day."
    )
    tags = ["Female", "Student", "Twin"]
    background = "bg house_hubbard kitchen day"


class Naomi(Profile):
    base_name = "naomi"
    name = "Naomi Nakano"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "The outgoing best friend of Charlotte. In some ways, she acts as a guardian"
        " for her friend, trying her best to keep Charlotte out of trouble. Despite her"
        " usual fun-loving and teasing exterior, she'd really like for Charlotte and"
        " herself to find nice guys to settle down with at some point."
    )
    tags = ["Female", "College Student"]
    background = "bg university courtyard"


class Natsumi(Profile):
    base_name = "natsumi"
    name = "Natsumi Yamashita"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "Yuuna's daughter and Yui's little sister. Sandra often has to babysit her due"
        " to Yuuna's work schedule and Yui's Student Council commitments. She's a good"
        " kid, but finds her sister's obsession with rules and order annoying. Wants to"
        " be grown up so she can do things like play video games that she's not allowed"
        " to play. Disturbingly skilled at Monopoly."
    )
    tags = ["Female", "Elementary Student"]
    background = "bg house_yamashita bedroom_natsumi day"


class Nemuri(Profile):
    base_name = "nemuri"
    name = "Nemuri Otani"
    emotion = "a_0"
    outfit = "robe"
    accessories = ""
    description = (
        "A friend of Sandra's from some time ago. He runs the local shrine, taking care"
        " of both the shrine and his sickly daughter, Setsuna. He's a very thoughtful"
        " individual who often worries for his daughter. He tries to homeschool"
        " Setsuna, though he admits he can't replace actually going to school."
    )
    tags = ["Male", "Parent", "Family Friend"]
    background = "bg shrine interior day"


class Nora(Profile):
    base_name = "nora"
    name = "Nora Whittaker"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    description = (
        "A younger teacher at one of San Fransokyo's elementary schools. "
        "Her patient demeanor and warm, maternal personality make her well-liked "
        "by the student body."
    )
    tags = ["Female", "Teacher"]
    background = "bg elementary classroom day"


class Patty(Profile):
    base_name = "patty"
    name = "Patty"
    emotion = "b_0"
    outfit = "robe"
    accessories = ""
    description = (
        "A shady young woman operating a fortune-telling stall outside the mall. "
        "It's not clear how much of her business is legitimately connected to "
        "the supernatural and how much is just good old-fashioned grifting, "
        "but it's definitely somewhere between the two."
    )
    tags = ["Female", "Supernatural", "Mall Worker"]
    background = "bg mall exterior day"


class Paul(Profile):
    base_name = "paul"
    name = "Paul Simmons"
    emotion = "a_1"
    outfit = "casual"
    accessories = ""
    description = (
        "A friendly face who is a major in accounting and a major nerd. "
        "While most people won't get his references, they still regard him as a pretty likable guy. "
        "In his free time, he also likes to exercise, but is often overshadowed by the nerdy vibe he puts out."
    )
    tags = ["Male", "College Student"]
    background = "bg university courtyard"


class Phila(Profile):
    base_name = "phila"
    name = "Phila Hubbard"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "The near-identical twin sister of Mina. Compared to her sister, she's a lot"
        " more stern and irritable, and is often seen by others as bossy. She's very"
        " protective of her sister and the two are never seen apart when they can help"
        " it, which some people think is a little odd. She enjoys playing video games"
        " while Mina watches."
    )
    tags = ["Female", "Student", "Twin"]
    background = "bg house_hubbard livingroom day"


class Rachel(Profile):
    base_name = "rachel"
    name = "Rachel Clark"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    tags = ["Female", "Teacher"]
    background = "bg school classroom_5 day"

    @property
    def description(self):
        text = (
            "A physics teacher at Tina Koya High School. She has a reputation as one of"
            " the cooler teachers, but also one of the scarier ones when annoyed. She"
            " believes in discipline and can often be seen trying to whip Tori and"
            " Vanessa into shape."
        )
        if persistent.fRachelDelinquencyDB:
            text += " Rumor has it she used to be quite the delinquent herself as a teenager."
        return text


class Riley(Profile):
    base_name = "riley"
    name = "Riley Evans"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A student at Tina Koya High School, often seen together with his childhood"
        " friend Genny. He's smaller and more delicate than most of his male peers,"
        " making him somewhat insecure. Though too timid to approach them, he's easily"
        " enamored with cute girls and quick to embarrass as a consequence."
    )
    tags = ["Male", "Student"]
    background = "bg school stairwell_1 day"


class Rita(Profile):
    base_name = "rita"
    name = "Rita Piper"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A member of Sayaka's friend group from a wealthy background. She's mercurial"
        " and brutish, with some odd hobbies unbecoming of her looks or status. Tends"
        " to speak her mind fairly freely, and enjoys poking at other people with blunt"
        " or crass remarks. She holds a long-standing grudge with Tori, both in and out"
        " of the boxing ring."
    )
    tags = ["Female", "Student", "Boxing Club", "Popular Clique", "Wealthy"]
    background = "bg school hallway_2 day"


class Sadie(Profile):
    base_name = "sadie"
    name = "Sadie-Lynn Kobayashi"
    emotion = "a_0"
    outfit = "uniform"
    accessories = "hair_twintail"
    description = (
        "A student who transferred to Tina Koya during the middle of the previous year."
        " She was part of the cheer team at her previous school, and joined Tina Koya's"
        " team immediately after transferring. Due to her cute looks and position on"
        " the cheer team, she quickly became part of the school's popular clique."
    )
    tags = ["Female", "Student", "Cheerleader", "Popular Clique"]
    background = "bg house_kobayashi bedroom_sadie day"


class Sandra(Profile):
    base_name = "sandra"
    name = "Sandra Davis"
    emotion = "a_0"
    outfit = "casual"
    accessories = ""
    background = "bg house_davis kitchen day"

    @property
    def description(self):
        text = (
            "John's mother who also works as a language teacher at his school alongside"
            " her long-time friend Leona. She's raised Holly and John by herself for"
            " years now, as well as done a lot of babysitting Yuuna's children as they"
            " grew up. Sandra is a very fun-loving person and likes to tease John,"
            " taking a particular interest in her son's love life."
        )
        if persistent.fSandraSpellbookDB:
            text += " Like her son, she's descended from wizards and can practice magic."
        return text

    @property
    def tags(self):
        list = ["Female", "Family", "Parent", "Teacher"]
        if persistent.fSandraSpellbookDB:
            list.insert(3, "Supernatural")
        return list


class Sayaka(Profile):
    base_name = "sayaka"
    name = "Sayaka Sato"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "The most popular girl in school, the captain of the cheerleading team, and the"
        " overall queen bee of Tina Koya. Her outward glamour doesn't extend past the"
        " sweet face she shows most people. Looks down on others such as John's"
        " friends, and seems to have a particularly strong dislike of Katrina."
    )
    tags = ["Female", "Student", "Cheerleader", "Popular Clique", "Wealthy"]
    background = "bg house_sato bedroom_sayaka day"


class Scarlet(Profile):
    base_name = "scarlet"
    name = "Scarlet Morgan"
    emotion = "a_0"
    outfit = "casual"
    accessories = "ribbon"
    description = (
        "The eldest child of the Morgan household. "
        "She's a college student, so she's often busy with her school work. "
        "Without coffee she's all but non-functional in the mornings."
    )
    tags = ["Female", "College Student"]
    background = "bg house_morgan hallway dawn"


class Setsuna(Profile):
    base_name = "setsuna"
    name = "Setsuna Otani"
    emotion = "a_0"
    outfit = "miko"
    accessories = ""
    description = (
        "One of John's early childhood friends, due to their parents being old friends"
        " themselves. Her father runs the local shrine, which she helps to maintain."
        " Due to sickness, she has been unable to attend school with the others,"
        " leaving her feeling lonely. It's because of this that John often takes the"
        " time to meet with her at the shrine."
    )
    tags = ["Female", "Friend", "Childhood Friend", "Miko"]
    background = "bg shrine exterior dusk"

class Sojiro(Profile):
    base_name = "sojiro"
    name = "Sojiro Hano"
    emotion = "a_0"
    outfit = "casual"
    accessories = "glasses"
    description = (
        "Kyoko's father and husband of Maki. He was in the army when he was younger,"
        " which spurred the imagination of his daughter about secret projects he might have"
        " worked on. He's more laid back than his wife but very protective of his daughter."
        " His highlights of the year are the hunting trips with his daughter."
    )
    tags = ["Male", "Parent"]
    background = "bg house_hano livingroom day"

class Tori(Profile):
    base_name = "tori"
    name = "Victoria {q}Tori{/q} Vega"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    tags = ["Female", "Student", "Boxing Club", "Delinquent"]
    background = "bg school rooftop day"

    @property
    def description(self):
        text = (
            "The number one delinquent of the school. "
            "She's irritable and often picks fights with others such as Rita or Yui. "
            "She's best friends with her fellow delinquent Vanessa, "
            "and has a complicated relationship with Ms. Clark."
        )
        if persistent.fToriSexualityDB:
            text += " This is compounded further by her difficulty coming to terms with her own bisexuality."
        return text


class Vanessa(Profile):
    base_name = "vanessa"
    name = "Vanessa Russell"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A troublesome student at Tina Koya High School. She looks up to Tori and tries"
        " to emulate her delinquent behavior, to mixed results. She struggles"
        " academically, having trouble with math in particular."
    )
    tags = ["Female", "Student", "Delinquent"]
    background = "bg school rooftop day"

class Veronica(Profile):
    base_name = "veronica"
    name = "Veronica Hill"
    emotion = "a_1"
    outfit = "casual"
    accessories = ""
    description = (
        "A freshman in college who goes by the name of {q}Ms. Bunnyearz{/q} online."
        " She's very talkative and easy to excite."
        " As a member of Kyoko's anime discussion club, she's good friends with her,"
        " although the two have never met offline."
    )
    tags = ["Female", "College Student"]
    background = "bg city walkway day"

class Yui(Profile):
    base_name = "yui"
    name = "Yui Yamashita"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "President of the Student Council. She takes her position very seriously and is"
        " very strict in following the rules and policing others to do the same. She"
        " and John were actually childhood friends due to their mothers' friendship,"
        " but drifted apart in teenhood."
    )
    tags = ["Female", "Student", "Student Council", "Childhood Friend"]
    background = "bg school clubroom day"


class Yuuna(Profile):
    base_name = "yuuna"
    name = "Yuuna Yamashita"
    emotion = "a_0"
    outfit = "casual"
    accessories = "necklace"
    description = (
        "A close friend of Sandra and Leona from college, and the mother of Yui and"
        " Natsumi. As a single mother she's been preoccupied with keeping her family's"
        " livelihood stable, leaving her little time to watch her children or to go out"
        " drinking with Sandra and Leona like she used to."
    )
    tags = ["Female", "Parent", "Family Friend"]
    background = "bg house_yamashita livingroom day"


class Zoey(Profile):
    base_name = "zoey"
    name = "Zoey Chambers"
    emotion = "a_0"
    outfit = "uniform"
    accessories = ""
    description = (
        "A student at Tina Koya High, and Brad's little sister. Though she usually does"
        " not interact with John's group very much, she has an obviously one-sided"
        " crush on Kiyoshi. She's very active and energetic, and shares an interest in"
        " physical activities with her brother."
    )
    tags = ["Female", "Student"]
    background = "bg school entrance day"
