init python:
    from dataclasses import dataclass

    #Explanations and code of DataClasses pertaining to this scenario are by UnknownUsername. Kudos!
    #Dataclass is a shortcut for real classes. It makes it so you dont have to write much of any class boilerplate
    #Comparison of dataclass vs non dataclass https://stackoverflow.com/a/47955313
    @dataclass
    class Blackjackstats: #These are the stats tracked of John's various transformations.
        name: str #The body John is in.
        count: int #The number of times he has played games in that body.
        win: int #The number of hands John has won.
        loss: int #The number of hands he has lost.
        draw: int #The number of drawn hands.
        net: int

    @dataclass
    class BlackJackBody:
        """ A body for john to get stuck in.

        To use a dataclass, make a class (class MyClass)
        import 'from dataclasses import dataclass' in python
        Then put @dataclass above your class (As seen above)
        Next declare what the class should hold.
        Declare a variable by putting "<var_name>: <type>"
        The types you should be using are:
            str: "This is a string" or 'This is one too' (Quote type doesn't matter)
            tuple: ("1", "2") (This is what you are using in body_index. Tuples are immutable meaning you can't replace a value)
            int: 1, 99 (Whole number)
            float: 1.0, 99.9 (Decimal number)
            list: [1, 2, 3] (Like tuple but you can change the value at each position)
            bool: True or False (Yes or no)
        """
        name: str #The name of John's body.
        joutfit: str #The standard outfit of John's body.
        em: str #John's emotion when he transforms into the body.
        outfit_tf1: str #John's first outfit.
        outfit_tf2: str #John's second, rarer outfit.
        outfit_tf3: str #John's nude 'outfit'. Scandalous!
        neutral_em: str #The value for John's neutral emotion in this body.
        happy_em: str #The value for John's happy emotion in this body.
        suprise_em: str #The value for John's surprised emotion in this body. Yeah, it's misspelt...
        sad_em: str #The value for John's sad emotion.

        #After those 2 things, the rest is up to you.
        #You now make methods that would help you do things
        #For example you do alot of capitalizing in say sentances.
        #Lets just make that a method instead
        def get_proper_name(self): #This is aother custom function, but goes unused here.
            """Anytime you make a method, you have to put self as the first arg. This is how you access the class
            In this method, all we will do return the body name capitlized.

            So instead of jbody_name.capitalize(), you would do jbody.get_proper_name()
            """
            return self.name.capitalize()

        #You also have to create the tuple manually for any show statements
        #Lets shortcut that as well!
        def return_show_tuple(self, emotion="h"):
            if emotion == "h":
                #The * means unload the values, so it wont be a tuple in a tuple
                return (self.name, *self.happy_em)
            elif emotion == "n":
                #The * means unload the values, so it wont be a tuple in a tuple
                return (self.name, *self.neutral_em)
            elif emotion == "sa":
                #The * means unload the values, so it wont be a tuple in a tuple
                return (self.name, *self.sad_em)
            elif emotion == "su":
                return (self.name, *self.suprise_em)

    #MAKE SURE TO USE A $ IF NOT IN PYTHON
    #Now that the class is made, lets use it
    #To create an instance of the class, call the name with brackets and the values
    x = BlackJackBody("sayaka", "uniform", "a_24", "casual","sport", "nude", "a_1","a_2", "a_7","a_8")
    #Now you can use this to access all the things declared above
    #Access a variable directly
    #x.name

    #Use a method
    x.return_show_tuple()
    x.return_show_tuple("n")

    #What an updated body index would look like.
    #Rather than one body index, the bodies are categorized by boon (positive) and bane (negative) effects.
    #If we need to choose a body from among both of them, we can use all_index which is a combination of both of them.

    #Note that each of these are formatted as a Python list of class instances.
    boon_index = [
                BlackJackBody("sayaka", "uniform", "a_24", "casual","sport", "nude", "a_1","a_2", "a_7","a_8"),
                BlackJackBody("kyoko", "uniform", "a_11","casual","underwear", "nude", "a_10", "a_11", "a_14", "a_15"),
                BlackJackBody("allison", "uniform", "a_9","casual", "underwear", "nude","a_0","a_1","a_16","a_20"),
                BlackJackBody("maria", "uniform", "a_24","casual","gym","nude", "a_0", "a_1", "a_19", "a_29"),
                BlackJackBody("patty", "uniform", "a_1","dress","costume","nude","a_2","a_1","a_7","a_4"),
                BlackJackBody("charlotte", "uniform", "a_15","casual","bikini","nude","a_1", "a_2", "a_7", "a_19"),
                BlackJackBody("katrina", "uniform", "a_19","casual","underwear", "nude", "a_0","a_5","a_3","a_15"),
                BlackJackBody("yui", "uniform", "a_14", "casual","underwear", "nude", "a_0","a_1","a_13","a_10"),
                BlackJackBody("cassie", "casual", "a_7","casual_d","underwear", "nude", "a_0", "a_1", "a_16", "a_2"),
                BlackJackBody("mina", "uniform", "b_3", "casual","bikini","nude", "b_0", "b_1", "b_6", "b_5"),
                BlackJackBody("mel", "uniform", "a_7","casual","swimsuit", "nude", "a_0","a_2","a_7","a_4"),
                BlackJackBody("anuja", "uniform", "a_19", "exotic", "swimsuit","nude", "a_0","a_1","a_4","a_20"),
                BlackJackBody("flavia", "uniform", "a_22","casual","swimsuit","nude", "a_1", "a_17", "a_7", "a_10"),
                BlackJackBody("sadie", "uniform", "a_7","casual", "underwear", "nude", "a_0","a_1","a_22","a_25")
                ]
    bane_index = [BlackJackBody("cornelia", "uniform", "a_13","casual", "sport","nude", "a_1", "a_2", "a_7", "a_6"),
                BlackJackBody("irene", "uniform", "a_22","casual_b","sport", "nude", "a_1", "a_14", "a_22", "a_8"),
                BlackJackBody("zoey", "uniform", "b_1", "casual","swimsuit","nude", "b_0", "b_3", "b_4", "b_1"),
                BlackJackBody("vanessa", "uniform", "b_2","casual","swimsuit","nude","b_0", "b_8", "b_7", "b_5"),
                BlackJackBody("tori", "uniform_full", "b_14","uniform","swimsuit","nude", "b_1", "b_2", "b_4", "b_6"),
                BlackJackBody("michelle", "uniform", "b_11","casual_b","swimsuit","nude", "b_17", "b_8", "b_5", "b_2"),
                BlackJackBody("rita", "uniform", "a_4","dress","swimsuit","nude","a_0","a_10","a_17","a_7"),
                BlackJackBody("carrie", "casual", "a_20", "casual", "bikini", "nude", "a_20", "a_21", "a_24","a_6"),
                BlackJackBody("johnGB", "uniform", "a_1","dress","underwear", "nude", "a_3", "a_5", "a_13", "a_15"),
                BlackJackBody("setsuna", "miko", "a_9","casual","swimsuit","nude","a_1", "a_2", "a_7", "a_3"),
                BlackJackBody("izuna", "uniform", "a_5","casual", "gym","nude", "a_0", "a_6", "a_2", "a_1"),
                BlackJackBody("bradGB", "uniform", "a_16","casual", "school_swimsuit","nude", "a_2","a_4","a_12","a_7"),
                BlackJackBody("phila", "uniform", "b_7", "casual_b","bikini","nude", "b_0", "b_1", "b_2", "b_5"),
                BlackJackBody("audrey", "uniform", "a_7","track_b", "casual_c", "nude", "a_0","a_1","a_6","a_8")
    ]
    all_index = boon_index + bane_index
