# For consistency with her twin sister, use Faith's full name in the bar flashback scene.

label legacy_alien_murder_day4:
    resetstate
    outfit john casual
    outfit holly casual_b
    outfit sandra pajamas
    accessory sandra set bedhead, glasses

    title "Day 4" "Private Eye"
    unlock legacy_alien_murder_day4

    scene black
    with dissolve

    nvl clear
    nvl_narrator "So much had happened the day before that I could barely get any sleep. Whenever I started to doze off, my thoughts began drifting wildly."
    nvl_narrator "I kept thinking about Setsuna, who, because of me and Kiyoshi, was now in an even worse condition than ever before. I could only imagine what had happened to her spirit when the ghost of Faith had taken control of her body."
    nvl_narrator "I also thought about the strange, foreign sensations of being a girl. Though I hadn't actually {q}explored{/q} Tori's body, there was still something exhilarating about it."
    nvl_narrator "Just the feeling of looking in the locker room mirror and seeing Tori's face stare back at me, of glancing down and seeing her breasts filling out the gym shirt, of her loose blond locks hanging down over my face..."
    nvl_narrator "It still felt totally unreal, looking back on it. I remember wondering if I would wake up the next morning to find that it had all been a dream."
    nvl_narrator "But mostly, I was focused on the mystery that had thrust itself upon us. All of a sudden, I'd been dragged into a murder case that had long since been abandoned, and had no choice but to solve it if I wanted my friend back."
    nvl_narrator "I wanted to blame Kiyoshi for getting us involved in the whole mess, but I knew it was wrong to pin everything on one person. I spent most of the night asking myself what I was going to do to set everything right, but it would be a while longer before I could come up with an answer."

    stop music fadeout 2.0
    nvl_narrator "All my concerns swam around in my head for hours and hours, until eventually..."

    scene bg house_davis bedroom_john day_shut
    with dissolve
    play music bgm_summer_day

    pause 1.0

    show john a_2 at centerright, faceleft with dissolve
    john "..."
    john "...Damn, it's early."
    john "Must've only gotten, like, two hours of sleep last night..."
    think "Well, there's no way I'll be able to get back to sleep... Might as well take a shower, I guess."

    scene bg house_davis bathroom foggy
    with dissolve

    "I took care of my usual morning routine, making sure to be a little quieter so as to not wake Holly up. My mom is a seriously heavy sleeper, so I wasn't too worried about her, but Holly always seemed... upset these days, and I didn't want to make her even angrier."
    "After changing into my uniform, I headed down to the kitchen to make myself breakfast."

    scene bg house_davis kitchen day
    outfit john uniform
    show john a_5 at center
    with dissolve

    think "Shit, when was the last time I made my own breakfast...?"
    show john at faceleft with exchange
    think "What the hell do we even have?"

    "I scanned through the cupboards, looking for anything I could make that wouldn't take too much effort. I was running low on patience that morning, so I just grabbed the first thing I found."

    think "Can't go wrong with cereal and milk, after all."

    "After pouring myself a bowl, I carried it into the living room and decided to chow down while I watched TV."

    stop music fadeout 2.0
    queue music bgm_gymnopedie_no_1
    scene bg house_davis livingroom day
    show holly b_0 at centerleft
    with dissolve

    show john a_0 at right, faceleft with moveinright

    holly "..."

    show john a_4 with exchange
    think "Huh!? She's up already too?"

    "Me waking up this early was one thing, but Holly? I was totally shocked to see her all prepped for school, relaxing in a chair and reading some book whose title I couldn't see."
    show john a_5 at centerright with move
    "I thought to myself that it might be some kind of sign, so I decided to try and talk to her. I took a seat on the couch perpendicular to hers and set my bowl down on the coffee table."

    show holly b_2 with exchange
    holly "...!"

    "Finally, she looked up to see who had entered the room. The sight of her dear little brother caused her stoic expression to give way to one of surprise."

    show john a_6 with exchange
    john "...Hey. Morning, sis."

    show holly b_5 with exchange
    "She quickly regained her composure and turned away from me, her eyes gluing themselves back to the book she was holding."

    holly "...Good morning."

    john "I'm, uh... I'm surprised you're up this early. Even Mom would be, I bet."

    holly "..."

    john "What if it's some weird telepathic sibling thing? Like, when one of us wakes up early it sends the other a signal to do the same?"

    think "Considering the crazy shit that device can do, I wouldn't be surprised if that were actually true..."

    john "...My jokes aren't doing the trick, I guess."

    john "So what are you reading?"

    show holly b_6 with exchange
    holly "..."

    "At last, she looked up from her book again. Rather than surprise or evasiveness, this time she seemed... concerned, like she wanted to ask me something but couldn't get the words out."

    "Whatever the case, I interpreted that as a cue to leave her alone. With a small sigh, I picked myself up off the couch and made to leave."

    show john a_2 with exchange
    john "Um... Sorry, sis, I didn't mean to bother you. Just thought we could talk."
    john "I'll just go eat in my room. See ya, Holly."
    show john at offscreenright, faceright with move

    show holly b_4 with exchange
    holly "..."
    holly "...John."

    show john a_5 at right, faceleft with move

    john "Yeah? What's up?"

    "Now it was my turn to be surprised. It felt like it'd been a while since she actually said my name."
    "I couldn't miss this opportunity. Holly actually talking to me was a rare thing indeed, so much so that even if all that came out of her mouth was a string of insults, I'd have been happy."

    show holly b_7 with exchange
    holly "...I, um..."

    show john a_6 with exchange
    john "..."

    show holly b_1 with exchange
    holly "...Have a good day at school."

    show john a_0 with exchange
    john "...You too, sis. Thanks."

    "The smile she gave me was pretty forced, but it was refreshing all the same. I smiled back at her for real, feeling like I'd cleared a huge hurdle. I was one step closer to mending fences with my sister, and that meant a lot."

    stop music fadeout 1.5

    show holly b_0 with exchange
    holly "..."

    "She quickly buried her face in her book again, an obvious signal that the conversation was finished. My cereal was getting soggy anyway, so that was fine by me. Content, I left the living room and headed upstairs."

    show john at offscreenright, faceright with move

    scene bg house_davis bedroom_john day
    with fade

    play music bgm_summer_day

    "I sat in silence, finishing my breakfast as I flipped through the device's manual again."
    "Soon enough, I heard the shower start running down the hall, which meant my mom was awake. I'd already finished getting ready for school, so I slid the device into my pocket and shut the manual in my desk drawer."

    scene bg house_davis kitchen day
    with fade

    "I headed downstairs to the kitchen again and set my bowl in the sink."

    scene bg house_davis livingroom day
    with dissolve

    "A quick peek in the living room told me that Holly had already left for school. Rather than leave early myself, I opted to wait up in the kitchen for my mom."

    scene bg house_davis kitchen day
    show john a_0 at centerleft
    with dissolve

    "I sat at the kitchen table and fumbled around with the device for a few minutes. I was surprised at how ordinary it looked--it'd be hard to distinguish it from a typical remote control at a distance."
    "The design made me a little curious as to just how much research these aliens had done on our planet and, more specifically, our technology."
    "I'd always imagined alien tech as being more grandiose and elaborate, so disguising such an amazing machine as something so unassuming and trivial was pretty brilliant."
    "But what did the fact it looked like a TV remote mean? That the aliens thought we were {i}always{/i} carrying them around because of how much we watch television? Or was it that their images of Earth life {i}came{/i} from TV signals?"
    "My thoughts about the device were interrupted when I heard footsteps descending the stairs. I put it back in my pants pocket opposite my phone and greeted my mom as she entered the room."

    show sandra a_0 at centerright, faceleft behind john with dissolve
    sandra "Wow, you're already up? Impressive!"

    john "Morning, Mom. Yeah, I had some trouble sleeping and never really went to bed, I guess."

    show sandra a_3 with exchange
    sandra "That's awfully unusual for you. Did something happen?"

    john "Nah, not really. Just a little anxious about that test I've got coming up."

    show sandra a_1 with exchange
    sandra "Aw, is my little John {i}finally{/i} showing an interest in learning?"
    sandra "I knew I'd rub off on you eventually!"

    show john a_6 with exchange
    john "...Uh, yeah, sure. Something like that."
    show john a_0 with exchange
    show sandra a_3 with exchange
    john "Oh, by the way, Holly already left for school. She woke up even earlier than I did."

    show sandra a_7 with exchange
    sandra "Is that right? ...I hope everything's okay with her."
    show sandra a_6 with exchange
    sandra "I wish I knew why she acts the way she does. She wasn't always this distant..."

    john "I managed to get her to talk to me this morning. That's gotta count for something, at least."

    show sandra a_0 with exchange
    sandra "Really? I'm impressed, John."
    sandra "...I never thought I'd say those words."

    show john a_6 with exchange
    john "Ouch."

    show john a_5 with exchange
    show sandra a_3 with exchange
    play sound sfx_text
    pause 1.5

    "Our chat was cut short when my phone received a text message. I yanked it out of my pocket while Mom was rummaging around for breakfast."

    text start john
    text title "Kiyoshi"

    msg kiyoshi "J-man! Let's get to school early today, we need a game plan! Leave home ASAP!"

    think "Well, at least someone's excited..."

    text end

    show john a_0 with exchange
    john "Hey, Mom, I'm gonna head out. Kiyoshi wants to meet early this morning."

    show sandra a_0 with exchange
    sandra "Oh? Are you two going to have a little study date before school?"

    show john a_2 with exchange
    john "You make the worst jokes, Mom."

    show sandra a_1 with exchange
    sandra "Hahaha! Maybe one day you'll be able to appreciate your mother's genius sense of humor, but not today."

    show john a_0 with exchange
    john "{q}Genius,{/q} huh? Is that what they call it nowadays?"
    john "...Anyway, I've gotta go. I'll let you know later today whether or not you'll see me tonight."

    show sandra a_0 with exchange
    sandra "Alright. Have a good day~!"

    show john at right with move

    play sound sfx_door_open
    pause 0.5
    hide john with dissolve
    play sound sfx_door_close

    scene black
    with dissolve

    stop music fadeout 2.0
    "I hurried off on my usual route to school, catching up with Kiyoshi near the school gates."

    scene bg school entrance day
    show kiyoshi a_0 at centerleft
    with dissolve
    play music bgm_fast_talkin

    show john a_5 at centerright, faceleft with moveinright

    show kiyoshi a_2 with exchange
    kiyoshi "Ah, there you are, John! Took you long enough!"

    show john a_0 with exchange
    john "Sorry, man. I'm a little out of it this morning."

    show kiyoshi a_1 with exchange
    kiyoshi "Excuses, excuses. Anyway, I'll get right to the point, J-man."
    kiyoshi "We need to do some investigating. And by we, I mean you. As we discussed yesterday, you are to investigate the school infirmary for any evidence and report back to me."

    show john a_2 with exchange
    think "{q}Report back to me?{/q}"
    show john a_5 with exchange
    john "Uh... What about {i}you?{/i}"

    kiyoshi "{i}I{/i} will be waiting patiently for you to return while I come up with ways we can use that device to help us in our investigation!"

    john "Why do I feel like you've given yourself the easy job?"

    show kiyoshi a_5 with exchange
    kiyoshi "What!? I'm offended, John!"
    kiyoshi "I'll have you know that my genius ideas do not come easily! They require extensive research and planning, thus {i}astronomical{/i} effort on my part! You can't even begin to understand the heaviness of my burden."
    show kiyoshi a_6 with exchange
    kiyoshi "Yes, if anything, I've given {i}you{/i} the easy job. You should be thanking me."

    john "..."

    "As much as I wanted to break it to him that very rarely, if ever, were his ideas anything {i}close{/i} to genius, I just didn't have the energy to bicker with him that morning."
    "Besides, I didn't have anything planned myself, so I figured whatever he came up with was better than nothing."

    stop music fadeout 2.0
    scene black
    with dissolve
    "I decided to time my investigation of the infirmary during my PE class with a little intrigue, a little cleverness."

    scene bg school gym day
    show john a_5 at centerleft
    with dissolve

    show john:
        0.5
        faceleft
        0.5
        faceright
        0.5
    pause 1.5

    show john a_4:
        easeout 0.4 yanchor 0.75
    pause 0.4
    play sound sfx_fall
    with vpunch
    play music bgm_investigations
    john "Ow, ow!"

    show john a_6:
        yanchor 0.75
        easein 0.8 yanchor 1.0
    "I held my ankle after a self-inflicted prat fall during dodgeball. I walked haltingly over to the gym teacher, Ms. Hawkins."

    show alex a_3 at centerright, faceleft with dissolve

    show john a_1 blush with exchange
    john "I think I injured my leg. Can I go to the nurse's office?"

    show alex a_8 with exchange
    "She rolled her eyes."

    alex "That fall was nothing. There's no way you hurt your leg from that."

    john "Well, I did..."

    show alex a_3 with exchange
    alex "Oh, please! Like I've never seen a fake before. Not only that, but you're a {i}terrible{/i} fake."

    john "But what if I'm not?"

    show alex a_6 with exchange
    "Ms. Hawkins sighed heavily."

    alex "You are, but whatever. If you wanna get out of gym that badly today, I won't stop you."

    show alex a_3 with exchange
    show john a_6:
        faceleft
        easeout 0.5 xcenter 0.25
        0.2
        easeout 0.5 xcenter 0.20
        0.2
        easeout 0.5 xcenter 0.15
        0.2
    "I grabbed my backpack and staggered out of the gym, dragging my {q}injured leg{/q} behind me as if it'd been permanently damaged."

    show john:
        xcenter 0.15
    "Ms. Hawkins called out from behind me as I opened the door out of the gym."

    show alex a_0 with exchange
    alex "Careful! You might actually injure yourself doing that!"

    scene black
    with dissolve
    "Without acknowledging her, I left the gym and started walking normally. The school infirmary wasn't far away."

    scene bg school infirmary day
    show john a_0 at centerleft
    with dissolve

    stop music fadeout 2.0
    "Once inside the infirmary, I noticed no one was around. I could understand no one else needing medical attention, but not even the nurse being here?"

    john "Ms. Reinhardt, are you there?"

    think "No response. Maybe she's on break."

    show john at center with ease
    "Inspecting the room, however, I did find a single person on the last bed, hidden by one of the curtains."

    show john a_8 with exchange
    john "Seems I found our missing nurse..."

    play music bgm_groove_grove
    "Kiyoshi was right on the mark. The woman on the bed resembled the ghost almost perfectly."

    think "Maybe they're twins, after all..."

    "I nudged her with my hand."

    john "Ms. Reinhardt?"

    "Her eyes slowly fluttered open."

    grace "Ah, shit..."

    "She sat up from the bed and let out a loud yawn. It might have been my imagination, but I thought I smelt a faint scent of booze on her breath."

    grace "You sick or something?"

    john "Not exactly. I needed to talk to you about something important."

    "She scooted herself off the bed and stood up."

    show grace a_3 at right, faceleft with dissolve
    grace "It'd better be important. You disrupted my break time."

    john "Yeah, sorry about that, but I needed to talk to you specifically about it."

    grace "Really? What's so special about me?"

    john "You look exactly like a ghost I saw."

    show grace a_5 with exchange
    "She laughed bitterly."

    show grace a_1 with exchange
    grace "Let me guess: you saw this {q}ghost{/q} in the girls' locker room? You're not the first person to tell me this, kid, but you're the first guy."

    john "So you believe the stories are true then."

    grace "No. I didn't go to medical school only to fall for idle rumors and ghost stories. Just go."

    show john a_7 with exchange
    john "But the stories are true! She looks {i}exactly{/i} like you."

    show grace a_4 with exchange
    grace "..."

    show john a_8 with exchange
    john "I think she's the PE teacher who died a few years ago. Surely you must know her from somewhere."

    show grace a_2 with exchange
    stop music fadeout 2.0
    "Her face twisted at my words."
    grace "Enough of your bullshit. If you're not sick, get out."

    think "Bingo."

    "I had to do something, something to make her believe my story. I thought back to the device."
    "Suddenly I had an idea."

    show john a_8 at faceleft with exchange
    john "Alright, I'll go."

    show john a_0 at centerleft, faceleft with ease
    "As I pretended to leave, I drew out the device and then I clicked the command function and her face seemed to lose all character as it calmed from rage to a blank, dazed expression."

    play sound sfx_device
    show john at faceright with exchange
    show expression alien_particles(400, 150, 180, mind_scale) as particles:
        xpos placement_of(grace).xpos + 0.011
        ypos 0.275
        alien_particles_fadeinout()
    john "You believe in ghosts."

    "I pressed the command function again and returned her to normal, stuffing the device in my backpack as she regained awareness."
    hide particles

    show john at faceleft:
        easeout 0.3 xpos (placement_of(john).xpos + placement_of(left).xpos) * 0.5
    "I pretended to continue walking out again."

    show john at faceleft:
        easein 0.3 xpos placement_of(left).xpos
    show grace a_2 with exchange
    play music bgm_groove_grove
    grace "Wait!"

    show grace:
        easein 0.5 center
    grace "I'm sorry for what I said. I don't know what I was thinking."

    show john at faceright with exchange
    john "I can still go if you want me to..."

    grace "Please don't go! I need to know what the ghost said."

    john "Well... she told me her name was Faith."

    show grace a_4 with exchange
    grace "Is she really still there?"

    think "How much should I tell her?"

    "I knew she was connected to Faith, but I didn't know how yet. For all I knew, she could be the killer. Just to be safe, I pulled the device out and used it yet again."

    play sound sfx_device
    show expression alien_particles(400, 150, 180, mind_scale) as particles:
        xpos placement_of(grace).xpos + 0.011
        ypos 0.275
        alien_particles_fadeinout()
    john "You will truthfully answer all of my questions."

    "I dropped the device into my backpack and continued my investigation."
    hide particles

    john "Who was Faith to you?"

    grace "She was my sister. My twin sister."

    "There was no hesitation in the answer. If her response was changed by the device, she didn't notice."

    john "How did she die?"

    show grace a_2 with exchange
    grace "She was murdered."

    "There was that word again. Murder."

    john "How do you know?"

    show grace a_4 with exchange
    grace "I don't... Well, I know, but I can't prove it."
    grace "The day before she died, we were drinking together. She told me something, but..."
    grace "We both had a little bit too much that night, if you catch my meaning."

    john "She--the ghost--had a huge burn scar across her face."
    john "The story goes that she was drinking and smoking--"

    show grace a_2 with exchange
    grace "That story is complete horseshit. Faith {i}never{/i} smoked on school grounds."
    grace "That night at the bar, she was drinking way more than usual. She was {i}really{/i} upset about something."
    grace "She told me... Shit..."
    show grace a_4 with exchange
    grace "Pardon my French. I just... wish I could remember what she said."
    show grace a_2 with exchange
    "She frowned."

    "I thought back to the device, to its ability to copy memories, and thought that copying her memories might uncover what it was her sister told her the day before the murder. I took the device out for the third time and used it."

    play sound sfx_device
    stop music fadeout 2.0

    scene white
    with Dissolve(2.0)
    scene black
    with dissolve
    pause 1.0

    nvl clear
    nvl show None
    window show
    nvl_narrator "Grace's memories cascaded into my head, a fierce and uncontrollable torrent that threatened to overwhelm me if I stopped resisting their intrusion as her memories intermixed with my own."
    nvl_narrator "Like a fisherman casting his rod in rapids, I tried to reel in any useful memories within the raging waters before they were lost to the current."
    nvl_narrator "Most, I could tell, had nothing to do with her sister's death, but, after a few moments, I was finally able to compose the scene of the night before Faith died."
    window hide
    nvl hide None

    scene cg faith bar face_0
    with dissolve

    play music bgm_despair_and_triumph
    pause 0.3
    "Faith was drinking late with her sister that night. From her emanated a peculiar coolness, almost the touch of the grave. She guzzled down half of her beer and slammed her glass against the table."
    "She had the look of someone guilty. Something was clearly bothering her."

    grace "You look terrible."

    $ faith.name = "Faith Reinhardt"
    faith "Probably..."

    "She smiled bitterly and took another sip from her glass. Wiping her mouth, she sighed deeply."

    grace "You can tell me. I'm your sister."

    faith "It's not something you wanna know."

    grace "If it's bothering you, I need to know."

    show cg faith bar face_1

    faith "...You always were the nosy one. Don't say I didn't warn you."

    "Faith finished her glass of beer and closed her eyes briefly as if to prepare herself for something difficult."

    faith "Jack Mallory..."

    show cg faith bar face_2

    "She gritted her teeth."

    faith "He... He's been having some kind of {q}relationship{/q} with one of his students. I think it's one-sided. Blackmail, or something..."

    grace "Jack!? When did you learn?"

    faith "...A few months now. I caught him right in the fucking act."
    faith "{i}Literally{/i} right in the fucking act."

    grace "Holy shit! Go to the police or something!"

    faith "...I can't. He..."

    "She hesitated."

    grace "He what?"

    faith "I feel fucking {i}awful,{/i} Grace. He's threatened to go public with my... habits at school if I told anyone."
    faith "But I think it's much, much worse than that. There is something seriously fucked up about that guy, and it's {i}not{/i} just because he's been abusing a student."
    faith "I don't doubt for a second that man would have second thoughts about {i}killing me{/i} just for knowing."
    faith "I've been too terrified to tell anyone."

    grace "...Who's the girl?"

    faith "A girl in one of his classes. None of mine, thank god."
    stop music fadeout 2.0
    faith "I only know her first name...{w=0.5} Holly."

    play music bgm_controlled_chaos_no_percussion
    think "Holly!? That...!"

    scene black
    with dissolve

    nvl clear
    nvl_narrator "Yet it had to be the case. I knew she'd had a class with him at that time. I wanted to deny it, but the more I thought about it, the more the possibility became an inevitability."
    nvl_narrator "It explained everything, from how Mallory treated me to why my sister changed so dramatically a few years ago. A dry sob caught in my throat, trying to force its way out."
    nvl_narrator "My mind was demanding I forget everything I'd heard. But that was impossible now."

    scene bg school infirmary day
    show john a_5 at left, faceright
    show grace a_2 at center, faceleft
    with dissolve

    "Despite myself, I felt warm tears streaming down my face which I wiped away with my hand. I took a deep breath."

    john "..."

    show grace a_4 with exchange
    grace "Is something wrong?"

    john "No... Nothing."

    "I couldn't tell her the truth, that I'd peeked into her memories and discovered who the murderer was. Although I hardly felt like speaking, I did want to give her some closure, after all that I'd messed with her mind earlier."

    john "...I think Mallory's the killer."

    "Associating Mallory with the murder seemed to enkindle some part of those memories I'd viewed."

    grace "Jack...? Wait, I remember now! He was the one my sister mentioned! But how did {i}you{/i} figure it out?"

    john "Intuition, I guess."

    show grace a_2 with exchange
    "Her face was wracked with pained rage."

    grace "Whatever. I'm going to make that bastard pay for this!"

    john "Leave it to me. He... My sister... He was the one who..."

    "I couldn't quite get the words out, but Grace seemed to understand. She closed her eyes for a few seconds and sighed."

    show grace a_4 with exchange
    grace "...I see."

    grace "Fine, I'll give you a few days, but that's it. Three at the most. Then I'm acting on my own."

    show john a_8 with exchange
    john "Thanks, Ms. Reinhardt."

    scene black
    with dissolve
    nvl clear
    nvl_narrator "Taking another deep breath to calm myself, I left the infirmary. Even though it wasn't Ms. Reinhardt's fault, I never wanted to go back to the infirmary. It was as if learning what had happened to Holly in there had tainted the place permanently."
    nvl_narrator "No matter how many times I tried breathing exercises to soothe the anger I felt towards Mallory, I could never hold it down. The trauma resurfaced with all the force and emotion it had before."
    stop music fadeout 2.0
    nvl_narrator "I had to do something about him, and soon. Fortunately, I had the perfect weapon to avenge what had happened to my sister. Still, it'd have to wait till I told Kiyoshi that I'd found the murderer, so I waited the last few minutes of second period hoping I'd cool down some."

    scene bg school cafeteria
    show john a_8 at centerleft
    with dissolve
    play sound sfx_bell noloop
    queue music bgm_summer_day
    "By the time I reached the lunchroom after the bell, though, I was still seething. I took my lunch tray and dropped it with a loud clatter on the table, next to Kiyoshi."

    show kiyoshi a_0 at centerright, faceleft with dissolve

    "Kiyoshi looked curiously at me for a moment before returning to eating without a word. Everything on my plate was unappetizing after what I'd just learned."

    think "Mallory..."

    "I clenched my fists."

    kiyoshi "Is something wrong?"

    show john a_5 with exchange
    "I narrowed my eyes at him. I wanted to shout something at him, to tell him to leave me alone, but it wasn't his fault. Not only that, but I had to talk to him to come up with a plan for confronting Mallory. I couldn't let that guy get away with what he'd done for one day longer."

    john "No."

    "I tried to stomach some of the food in my plate, inserting a piece of the bread roll into my mouth as if it were a writhing worm."

    kiyoshi "Hm. Well, did you figure out who the murderer was?"

    john "...Yeah, it's Mallory."

    show kiyoshi a_3 with exchange
    kiyoshi "Mr. Mallory!? How do you know?"

    john "Grace's twin sister knew he was doing something illicit with... with one of his students, and she confronted him about it. She died the next day. He has the motive, and all the evidence points back to him."

    show kiyoshi a_1 with exchange
    kiyoshi "I agree completely. I always knew that man was pure evil. Now that we know, we shall at last be able to solve this murder case easily with your device."

    show john a_8 with exchange
    john "Do you have a plan?"

    show kiyoshi a_6 with exchange
    kiyoshi "A plan? A plan!? Of course I have a plan! Jack sponsors a club after school--the culture club--and we can use one of the device's functions to sneak inside. I would tell you to use it on him during his class, but it would be best no one else saw the device."

    john "And then what?"

    show kiyoshi a_2 with exchange
    kiyoshi "And then we use the device on him to force him to confess to the murder, obviously. That should resolve our ghostly problem and return Setsuna to normal. Everything will be perfect again."

    think "Except one thing..."

    show kiyoshi a_0 with exchange
    kiyoshi "You sure you're okay? You look like you're sick, or about to cry..."

    john "I'm fine..."

    "Kiyoshi nodded slightly, as if accepting what I said despite not believing."

    kiyoshi "Anyhow, let's meet up in front of the second floor bathrooms after school. From there, we'll plan our method of attack."

    "I picked at the bread roll again. Somehow it seemed like, no matter how many times I pulled a piece out of it, there was still more."
    "I pulled out another small piece, but, staring at it for a few moments, I set it back down again. I just couldn't eat another bite."

    john "I'm going. See you after school."

    show kiyoshi a_1 with exchange
    kiyoshi "Right. Hope you feel better by then."

    "I threw my backpack over my shoulder and left the lunchroom. I didn't really want to think about anything for the rest of the day, but, unfortunately, I still had two more classes, including Mallory's."

    scene black
    with dissolve
    nvl clear
    nvl_narrator "I was more capable of holding myself together, the more time passed between me and the scene I saw when I was in the infirmary."
    nvl_narrator "I couldn't shake myself out of it or really recover, but the acute pain from the experience was beginning to ebb away into a dull burn, like an old cavity."
    nvl_narrator "Even once I was in Mallory's class, I could keep myself from yelling at him. As much as I wanted to proclaim in front of the class that he was a murderer and rapist, I knew that without clear evidence, all I'd accomplish in doing that was tipping him off."
    nvl_narrator "He'd killed before and, without a doubt, he would kill again if he had to. I gritted my teeth in silence as I endured yet another of his excruciating classes."
    nvl_narrator "Whenever I so much as reached for the device in my bag, his eyes focused on me. Even though he wasn't aware I knew what he'd done, he was too conscious of me to catch him by surprise."
    nvl_narrator "Regardless, I couldn't spoil our plan. And, if I alerted everyone to the device, I'd have yet another problem on my hands."
    nvl clear
    nvl_narrator "School ended with the final bell, and I exited class and ran to the second floor bathrooms Kiyoshi wanted us to meet at. Once there we'd finally be able to put the plan into action and give Mallory the comeuppance he was due."
    nvl_narrator "Kiyoshi hadn't yet arrived when I'd reached the bathroom, so I paced around for a few minutes outside the doors."

    scene bg school stairwell_1 day
    show john a_8 at center
    with dissolve
    think "C'mon, Kiyoshi, where are you...?"

    show kiyoshi a_0:
        faceleft
        offscreenright
        easein 0.5 centerright
    show john:
        ease 0.5 centerleft
    "Fortunately, as if summoned by my supplications, he zipped past a corner and down the hallway towards me with his backpack in front of him, open and crammed past the brim with rolled pieces of papers that looked like posters."

    show kiyoshi at centerright, faceleft with exchange
    show john at centerleft with exchange
    kiyoshi "Phew. Sorry for making you wait, John, but I had a few things I had to take care of first."

    john "...So what's the plan?"

    show kiyoshi a_1 with exchange
    kiyoshi "Right. You have the gender change function on your device, if I recall correctly, and I'm positive I do."

    john "Yeah. So do you want us to go to that club as female versions of ourselves?"

    show kiyoshi a_2 with exchange
    kiyoshi "One hundred percent correct, John! Way to discover my master plan without me even telling you!"

    think "It's not as if he made it difficult."

    john "Anyway, which bathroom should we use to change? The men's room should be fine, as long as we're guys, but, once we're girls, it's something else entirely."
    john "The women's room would be better for us after the change, but we'll look like perverts if someone spots us before we use the device."

    show kiyoshi a_3 with exchange
    kiyoshi "What's wrong with that?"

    show john a_2 with exchange
    john "Sometimes you say things that explain everything about you."

    show kiyoshi a_1 with exchange
    kiyoshi "Well, some people just can't handle the Kiymaster."

    menu:
        kiyoshi "As for the bathroom choice, I'll leave it up to you, J-man."

        "We went into the guys' restroom.":
            show john a_8 with exchange
            john "We'll go into the guys' restroom."

            show kiyoshi a_0 with exchange
            "Kiyoshi slumped as if utterly drained."

            kiyoshi "Why, John... Why?"

            john "Because it'll look weird if someone spots us going into the girls' restroom. Besides, we'll be able to go in there ourselves without anyone thinking it's unusual in a few minutes."

            show kiyoshi a_5 with exchange
            kiyoshi "But it's the principle of the thing, the principle! Don't you understand this is the only chance we'll be able to go into the women's restroom at this exact time? Going another time is completely different."

            john "But it'll be the same experience."

            show kiyoshi a_0 with exchange
            kiyoshi "Life is like a river, John. You never step into the same situation twice. Every situation is its own situation and incomparable to any other, thus it will never be the {i}same{/i} experience."

            show john a_2 with exchange
            john "...Whatever, Kiyoshi. You doing this or not?"

            show kiyoshi a_1 with exchange
            kiyoshi "Of course! When did I say otherwise?"

            "Kiyoshi and I hurried through the door to the men's restroom. Kiyoshi was slavering just thinking about what we were about to do, or, rather, what we were about to change into."

        "{s}We went into the girls' restroom.{/s}":
            placeholder

    routename "Kiyoshi's Ideal Girl"

    scene bg school bathroom day
    show kiyoshi a_0 at centerleft
    show john a_0 at centerright, faceleft
    with fade

    play music bgm_covert_affair

    john "Uh, hello? Anyone in here?"

    "There was no response from any of the stalls."

    john "Okay, looks like we're in the clear. Let's use that thing and get out of here."

    show john a_8 at right, faceright with ease

    john "I'll keep watch for anyone coming."

    show kiyoshi a_2 with exchange
    kiyoshi "What's the rush, man? Now's the time to be {i}alive.{/i}"

    play sound sfx_device

    show expression alien_particles(1500, 340, 700) as particles:
        xpos placement_of(kiyoshi).xpos
        ypos 0.6
        alien_particles_fadein
    morph begin alien kiyoshi kiyoshiGB uniform b_2

    "I heard a crack and a whirr from behind me as Kiyoshi pressed one of the buttons on the device."

    morph finish kiyoshi
    hide particles with dissolve

    kiyoshi "Whoa... Shit..."

    "I heard a young woman's voice behind me. Could something so... delicate-sounding... belong to Kiyoshi?"
    "Not only that, but the first time in our lives, it seemed like something had caught Kiyoshi completely off-guard. His voice wavered with some kind of excitement or fear I hadn't ever expected to see in him."

    show kiyoshi b_24 with exchange
    kiyoshi "Dude, look! I've got {i}tits!{/i}"

    "Of course, no matter how he sounded, he was still undoubtedly Kiyoshi."

    john "Gee, I'm {i}so{/i} happy for you."

    show kiyoshi b_3 with exchange
    kiyoshi "Thanks, bro. Knew you'd understand."

    show kiyoshi:
        ease 0.8 xpos 0.45

    "I heard a few footsteps behind me as Kiyoshi stepped up to one of the mirrors."

    show kiyoshi a_2:
        xpos 0.45
    kiyoshi "Wow, my uniform changed and everything. I look like a babe."

    show john a_4 at faceright with exchange
    john "Jesus, Kiyoshi, we're here to solve a murder, not gawk at ourselves in the mirror! Get over yourself and make me a girl already!"

    show john a_5 with exchange
    show kiyoshi a_1 with exchange
    kiyoshi "Oh? I didn't know you were into such kinky stuff."

    show kiyoshi b_5 at faceleft:
        ease 0.8 centerleft
    think "What the hell is he talking about?"

    stop music fadeout 1.0

    show kiyoshi b_4 at centerleft, faceright with exchange
    kiyoshi "Just remember it was you who suggested it, not me."

    play music bgm_dreams_become_real

    show kiyoshi b_5 with exchange
    show john a_4 with exchange
    "I hardly heard the crack and whirr as my body instantly began to change."

    play sound sfx_device

    show expression alien_particles(1500, 340, 700) as particles:
        xpos placement_of(john).xpos
        ypos 0.6
        alien_particles_fadein

    morph begin alien john johnGB_legacy uniform a_2
    "Every part of me felt cold. I could sense my viewpoint lowering, the teeth in my mouth shifting, the hair on my head growing longer and thinner."

    morph do john
    show kiyoshi b_1 with exchange
    "I felt a breeze on my legs, and realized that my clothes hadn't escaped the process. In place of my trousers was a pair of stockings and the flowy skirt of a girls' uniform."

    morph end john
    hide particles with dissolve

    john "Whoa, fuck..."

    show kiyoshi b_3 with exchange
    kiyoshi "Guess I gotta take care of that, too."

    show john b_17 at right, faceleft with exchange
    john "Take care of wha--"

    play sound sfx_device

    show john b_24 with exchange
    show expression alien_particles(400, 200, 240, mind_scale) as particles:
        xpos placement_of(john).xpos + 0.012
        ypos 0.31
        alien_particles_fadeinout()

    "I felt like a pair of hands were squeezing my head. I thought it would burst at any second, but, as soon as it began, it stopped."

    hide particles

    john "Ow-Owie..."

    show kiyoshi b_1 with exchange
    kiyoshi "Seems like it worked."

    show john a_22 with exchange
    john "Of {i}course{/i} it worked, you dummy!"

    show kiyoshi b_3 with exchange
    pause 0.2
    show john a_2 at centerright with ease
    "Despite my earlier protests, I moved in front of a mirror to get a better look at myself."
    "From beyond the mirror, a cute high-school girl stared back into me. She seemed surprised to see me."

    john "Wow..."

    show kiyoshi a_3 with exchange
    show john a_17 with exchange
    "I looked down at my body. The first thing I got was a face-full of breasts, but at this point, that wasn't new to me."
    "I lifted the edge of my skirt slightly, and felt air rush in to take its place. I noticed the straps of a garter belt against my thighs."
    "Even though I had been in a copy of Tori's body earlier, this was a completely different--but just as incredible--experience."
    show john b_1 with exchange
    "I did a little twirl, letting my skirt billow out a bit."

    show kiyoshi b_4 with exchange
    kiyoshi "Well, are you just going to stare at yourself, or are we going to solve this murder?"

    show john a_11 with exchange
    john "Sh-Shush, you."

    stop music fadeout 2.0

    scene black
    with dissolve

    "I took one last look at the girl in the mirror before heading out the door with Kiyoshi."

    play music bgm_monkeys_spinning_monkeys
    play sound sfx_sliding_door_close

    pause 1.0

    scene bg school classroom_3 day
    show anuja a_0 at centerleft
    show michelle a_0 at left
    with dissolve

    show kiyoshi a_4 at right, faceleft
    show john a_3 at centerright, faceleft
    with easeinright

    pause 1.0

    "I wasn't sure what a {q}culture club{/q} was for, but it seemed to have enough members."
    "I only recognized two members out of the small crowd, Michelle and Anuja."
    "Anuja is a foreign exchange student from India. Her host family is Michelle's, so during her time here they've been pretty close. Both of them were in Kat's D&D group actually."

    show michelle a_1 with exchange
    michelle "Oh, are you two new here?"

    show john a_19 with exchange
    john "Umm... A little. We're just kinda sorta looking into new clubs and stuff."

    show michelle a_3 with exchange
    show anuja a_7 with exchange
    show kiyoshi b_1:
        easein 0.5 xpos 0.55
    kiyoshi "Heyyy, are you from India? 'Cuz you're the only {i}in--{/i}"

    show john a_12:
        easein 0.3 xpos 0.4
    pause 0.35

    show john b_18:
        faceright
        0.05
        linear 0.75 xpos placement_of(centerright).xpos
    show kiyoshi a_4:
        0.05
        linear 0.75 xpos placement_of(right).xpos
    kiyoshi "{b}Oof!{/b}"

    show john b_16 at centerright with exchange
    show kiyoshi a_5 with exchange
    show michelle a_6 with exchange
    show anuja a_1 with exchange
    anuja "I am yes. Many exchange students have come to join with the club."

    think "{q}Exchange{/q} students, huh? I guess we qualify for that term in a... strange sort of way."

    show michelle a_0 with exchange
    michelle "By the way, my name's Michelle, and this is Anuja."

    anuja "I am pleased to meet you."

    show john b_22 at faceleft with exchange
    john "N-No, the pleasure's all ours! I'm... Jane, and this is my friend, Ki...yo."

    show kiyoshi a_3 with exchange
    kiyoshi "'Sup."

    anuja "Ah, I hope that you will be pleased with the club! You will have to speak with Mr. Mallory about joining the club."

    show kiyoshi a_1 with exchange
    kiyoshi "Who would wanna join a club run by that jacka--"

    show michelle a_4 with exchange
    show anuja a_7
    show john b_24 at Position(xpos=placement_of(kiyoshi).xpos - 0.05)
    with MoveTransition(0.1)
    play sound sfx_whack
    show kiyoshi a_16
    with hpunch
    show john at centerright
    with MoveTransition(0.1)

    kiyoshi "{b}Aaugh!{/b}"

    show john b_1 with exchange
    show kiyoshi a_5 with exchange
    show michelle a_3 with exchange
    john "Thank you very much for your advice!"
    john "Kiyo says thank you too, but, um... she's not very good at speaking English! I mean, this is the culture club, after all, so I mean..."
    john "She should just..."
    show michelle a_4
    show john b_24 at Position(xpos=placement_of(kiyoshi).xpos - 0.05)
    with MoveTransition(0.1)
    play sound sfx_whack
    show kiyoshi a_16
    with hpunch
    show john at centerright
    with MoveTransition(0.1)
    john "Keep her..."
    show john at Position(xpos=placement_of(kiyoshi).xpos - 0.05)
    with MoveTransition(0.1)
    play sound sfx_whack
    with hpunch
    show john at centerright
    with MoveTransition(0.1)
    john "Mouth shut...!"
    show john at Position(xpos=placement_of(kiyoshi).xpos - 0.05)
    with MoveTransition(0.1)
    play sound sfx_whack
    with hpunch
    show john at centerright
    with MoveTransition(0.1)

    kiyoshi "{b}Blaaugh!{/b}"

    show anuja:
        xpos 0.23
    with move

    anuja "I... I see..."

    michelle "We'll... leave you two be."

    hide anuja
    hide michelle
    with dissolve

    show john b_9 at faceright with exchange
    show kiyoshi a_4 with exchange
    john "You gosh-darned {i}dummy!{/i} Leave the talking to me, okay?"

    stop music fadeout 1.0

    show john a_15 at faceleft with exchange
    "At this point, I wasn't sure why I decided to wait for an opportunity to confront Jack with Kiyoshi."

    play music bgm_maccary_bay

    show john b_4 with exchange
    pause 0.2
    show jack a_4 at left with dissolve

    jack "Can I help you, ladies?"

    "Jack's weary expression gave the impression that he'd rather be anywhere else but sponsoring this club. He must have had some kind of obligation to run it on account of being part of the social studies department."

    show john b_5 with exchange
    john "Umm, yes. Kiyo, can you give me back my {q}wallet?{/q}"

    show kiyoshi a_2 with exchange
    show jack a_8 with exchange
    kiyoshi "You never gave me your wallet, Jo--"

    play sound sfx_whack
    with hpunch

    show kiyoshi b_1 with exchange
    kiyoshi "--Oooooh, I gotcha, I gotcha."

    "Kiyoshi passed me the device."

    show kiyoshi a_0 with exchange
    john "This should cover the dues, right?"

    play sound sfx_device
    stop music fadeout 2.0
    show expression alien_particles(400, 180, 180, reject_scale) as particles:
        xpos placement_of(jack).xpos - 0.01
        ypos 0.15
        alien_particles_fail

    "I quickly pointed the device at Jack and pushed the mind manipulation button."

    hide particles
    show jack a_6 with exchange
    show john b_4 with exchange
    play music bgm_controlled_chaos_no_percussion
    jack "..."

    john "Let's... try that again."

    play sound sfx_device

    show expression alien_particles(400, 180, 180, reject_scale) as particles:
        xpos placement_of(jack).xpos - 0.01
        ypos 0.15
        alien_particles_fail

    pause 1.8
    hide particles
    show jack a_8 with exchange
    jack "There's... no way..."

    show john a_13 with exchange
    "Jack reached into his shirt pocket and began to remove something."

    john "No way! No {i}way!{/i} Kiyo, run!"

    show john at offscreenright, faceright
    show kiyoshi a_4 at offscreenright, faceright
    with MoveTransition(0.3)

    scene black
    with dissolve

    "Kiyoshi and I booked it from the room and down the hall. We tore outside the front gates and didn't stop running until we reached the road."

    scene bg road dusk:
        xzoom -1
    show john a_1 at centerleft
    show kiyoshi a_4 at centerright
    with dissolve

    john "{i}Huff... Puff...{/i}"

    show kiyoshi at faceleft with exchange
    kiyoshi "What was the big deal, man? What's got your panties in a bunch?"

    show john a_0 with exchange
    "{q}Running in this outfit,{/q} I almost wanted to reply."

    show john b_17 with exchange
    john "Jack has a device, too! Didn't you see what he was taking out of his pocket?"

    show john b_3 with exchange
    "I gasped for air. I was more out of breath than I thought. I wasn't usually athletic, but in this body, it seemed like I hardly had any stamina."
    "Strangely enough, Kiyoshi seemed fine."
    think "Maybe his female body is more athletic than his usual one?"

    show kiyoshi a_3 with exchange
    kiyoshi "No way, man! No way!"

    "Kiyoshi repeated what all three of us had said."

    stop music fadeout 1.0

    show john b_0 with exchange
    show kiyoshi a_5 with exchange
    john "O-Ow..."

    play music bgm_summer_day
    show john:
        ease 0.5 xpos 0.225

    "The sharp pain of running cramps brought me to a stop. I leaned up against the natural wall."

    show john b_19 with exchange
    john "Let's turn back now, okay? I feel like I'm gonna faint in this silly body."

    show john:
        ease 0.5 yoffset 90

    "I tossed Kiyoshi the device and sat down. I hugged my legs tightly to my body as not to reveal the underside of my skirt as I had seen other girls do."

    show kiyoshi b_10 with exchange
    kiyoshi "Hmph. Lame."

    play sound sfx_device

    show expression alien_particles(1500, 340, 700) as particles:
        xpos placement_of(kiyoshi).xpos
        ypos 0.6
        alien_particles_fadein
    morph begin alien kiyoshi kiyoshi uniform a_0

    "He used the device on himself first, apparently not realizing why I had given it to him."

    morph finish kiyoshi
    hide particles with dissolve

    show john b_2 with exchange
    john "{b}Ahem.{/b}"

    show kiyoshi a_5 with exchange
    kiyoshi "Just... Give me a few more seconds of chilling with a girl, would you? I mean, without having to keep watch for pepper spray, or physical assault. {i}Et cetera.{/i}"

    show john b_19 with exchange
    john "What do you even mean, Kiyoshi? I'm a boy. And you get to hang out with Katrina and Kyoko all the time and stuff."

    show kiyoshi a_3 with exchange
    kiyoshi "Yeah, but, they aren't exactly {q}girls.{/q}"

    stop music fadeout 2.0

    show john b_4 with exchange
    john "And I am? Wait..."

    play music bgm_the_builder

    "Suddenly it all made sense."

    show john b_24 with exchange
    john "{b}Kiyoshi, what did you do to me!?{/b}"

    show kiyoshi a_0 with exchange
    kiyoshi "I did what you told me, dude. I made you a girl."

    show john a_12 with exchange
    john "That doesn't mean I wanted you to make me act like one! You're gross!"

    show kiyoshi a_6 with exchange
    kiyoshi "It worked pretty well, too. Calling me gross is {i}exactly{/i} what a girl would do."

    show john a_15 with exchange
    john "I can't believe I trusted you! Turn me back already, you big..."

    "I struggled to think of a good insult despite my personality change."

    show john b_0 with exchange
    john "...Darn... doofus...!"
    show john b_24 with exchange
    show kiyoshi a_5 with exchange
    john "{b}Gahhh! I give up!{/b}"

    "At my outburst, Kiyoshi's expression changed considerably."

    kiyoshi "You didn't get a taser or anything along with your new uniform, did you?"

    john "{b}Just turn me back already!{/b}"

    kiyoshi "Okay, okay, jeeeez."

    show kiyoshi a_4 with exchange
    "He pointed the device at me."

    play sound sfx_device_fail

    show expression alien_particles(150, 340, 700) as particles:
        xpos placement_of(john).xpos
        ypos 0.6 + 0.125
        alien_particles_fail

    pause 1.8
    hide particles
    stop music fadeout 1.8

    show john b_19 with exchange
    kiyoshi "Uh, let me try that again."

    play sound sfx_device_fail

    show expression alien_particles(50, 340, 700) as particles:
        xpos placement_of(john).xpos
        ypos 0.6 + 0.125
        alien_particles_fail

    pause 1.8
    hide particles

    show kiyoshi a_0 with exchange
    kiyoshi "Sorry, bro. Looks like it broke."

    show john a_13 with exchange
    john "{b}Whaaaaat!?{/b}"

    play music bgm_comfortable_mystery_3

    show john:
        parallel:
            ease 0.1 yoffset 0
        parallel:
            linear 0.4 xpos 0.53

    "I stood up and grabbed the device from Kiyoshi."
    "The battery indicator was blinking red: empty."

    show john b_3 with exchange
    john "It's... out of power..."

    show kiyoshi a_4 with exchange
    "Kiyoshi finally seemed to grasp the gravity of the situation."

    kiyoshi "That's... bad. That means you'll probably have to have periods now."

    "Or not."

    show john b_2 with exchange
    john "The instruction thingy said it would take a day to fill back up after running out."
    john "Nobody is going to be having {i}periods.{/i} Especially not me."

    scene bg sky dusk
    with dissolve

    john "It's getting dark..."
    john "I can't go back home looking like this..."

    kiyoshi "Well, um..."
    kiyoshi "Why not... uh..."

    john "Huh?"

    kiyoshi "John, what was that one pickup line about asking a girl to stay at your house again?"
    kiyoshi "It was something like, {q}Why not stay at my place, because you look like an orphan.{/q}"
    kiyoshi "No, wait, that's not right..."

    john "..."
    think "I guess I have no choice."

    stop music fadeout 2.0

    scene black
    with dissolve

    john "Let's go back to your place."

    "Kiyoshi lived alone with his uncle, who wasn't home most of the time on account of his job as a detective."
    "I figured it was my best option at the time."

    scene bg house_honda livingroom dusk
    show maurice a_0 at right
    show kiyoshi a_0 at offscreenleft
    show john b_16 at offscreenleft
    with dissolve

    play sound sfx_sliding_door_close
    play music bgm_marty_gots_a_plan

    show kiyoshi:
        offscreenleft
        ease 1.0 centerleft
    show john:
        offscreenleft
        0.4
        ease 0.6 left
    pause 1.5

    kiyoshi "Yo, Uncle."

    show kiyoshi behind maurice at centerleft
    show john behind maurice at left
    show maurice at faceleft with exchange
    maurice "Hi, Kiyo--"

    show maurice a_3 with exchange
    "Mr. Honda's face went white when he saw me."

    maurice "Is that... a girl?"

    show kiyoshi a_6 with exchange
    kiyoshi "Yeah. This is my girlfriend, Jane."

    show john b_17 with exchange
    john "U-Umm, girlfriend...?"

    think "We hadn't agreed on this part of the story!"

    "Mr. Honda looked over at me in disbelief."

    maurice "Are you really my nephew's girlfriend?"

    "The look on his face seemed to say {q}if you're here against your will, give me a signal.{/q}"

    show john a_1 with exchange
    john "Oh, yes, we're... dating."

    show kiyoshi a_1 with exchange
    kiyoshi "We're gonna head upstairs if you're cool with that."

    maurice "Uh... Yeah. Yeah, that's okay."

    "He stood up from his work on the table."

    maurice "I need a drink. Or twenty."

    show maurice:
        ease 1.5 offscreenleft
    pause 1.5
    play sound sfx_sliding_door_close
    stop music fadeout 1.0

    "And with that, we were left alone in the house."
    hide maurice

    show john:
        ease 0.5 centerleft
    show kiyoshi:
        ease 1.0 centerright
        faceleft

    play music bgm_investigations
    john "So we're {q}dating,{/q} huh?"

    show john at centerleft with exchange
    show kiyoshi a_5 at centerright, faceleft with exchange
    kiyoshi "It was on short notice. I had to think of something!"

    john "Oh, please. You couldn't think of anything better?"

    kiyoshi "No..."

    show john a_18 with exchange
    john "Well, let's go to your room, {q}lover.{/q}"

    scene bg house_honda bedroom_kiyoshi dusk
    with wipeup

    show john a_4:
        faceleft
        offscreenright
        ease 1.0 centerright
    show kiyoshi a_4:
        faceleft
        offscreenright
        ease 2.0 centerleft
        faceright
    "Kiyoshi ushered me up to his room and closed the door. Despite all his bluster about love and women, he seemed fidgety sitting next to me."

    show john at centerright, faceleft with exchange
    show kiyoshi at centerleft, faceright with exchange
    john "What's wrong?"

    show kiyoshi a_1 blush with exchange
    kiyoshi "I-I've just never had a girl in my room before..."

    show john a_5 with exchange
    john "So how is it now that your {q}girlfriend{/q} is here?"

    show kiyoshi a_4 blush with exchange
    kiyoshi "It's, um... Different than I expected."

    show kiyoshi a_2 blush with exchange
    "He rubbed his chin nervously and laughed."

    show kiyoshi a_4 blush
    kiyoshi "Here."
    "He pointed at his futon on the floor."
    kiyoshi "You can sleep here tonight. I'll sleep on the chair."

    "It was easy to tell how flustered he was being around me like this. It'd be easy to mess with him in this body, and I was wanting to tease him a little."

    menu:
        "I could probably strip down to my underwear and mess with him, but, despite the temptation to screw with him, some part of me inside feared I might be giving in to my feminine side in some way."

        "I decided to tease Kiyoshi.":
            $ fGirlAcceptance = True
            stop music fadeout 2.0
            "I smiled mischievously and looked at Kiyoshi, still sitting next to me and trying to look away."

            show john a_11 with exchange
            john "{i}Hey, Kiyoshi...{/i}"

            show kiyoshi a_0 blush with exchange
            kiyoshi "Wh-What, John?"

            play music bgm_groove_grove
            "I unbuttoned my shirt and jacket and pulled them over my head, revealing my breasts set inside a lacy black bra."

            show john b_1 at faceleft
            outfit john underwear
            with dissolve
            show kiyoshi a_3 blush with exchange
            kiyoshi "What are you doing!?"

            show john b_16 at faceleft with exchange
            john "You said we were in a relationship, didn't you? Since we were alone, I thought we'd do normal stuff boys and girls in relationships do."

            "I tossed off my shoes, pulled down my skirt and started rolling down the pantyhose from my waist."

            kiyoshi "But it was a joke! I didn't mean any of it!"

            show john a_17 with exchange
            "I pouted."

            john "Am I not good enough for you?"

            kiyoshi "No, I didn't mean it like that!"

            show kiyoshi a_5 blush behind john:
                ease 1.5 xcenter 0.2
            show john b_3:
                faceleft
                ease 2.5 xcenter 0.3
            "As I crawled toward him in only a thong and bra, he pushed himself back but, either too slow or too stunned to move more quickly, I easily caught up to him."

            kiyoshi "But J-John!"

            scene cg johnGB cuddle_zoom face_1:
                xzoom -1
            with dissolve
            "I put my arms around his head and nestled my head next to his, rubbing my massive chest against his shoulder."

            show cg face_0
            john "Do you like that, Kiyoshi?"

            "I said it as suggestively as I could. He froze completely, as if petrified."

            kiyoshi "...!"

            "Kiyoshi's mouth was open, but he was unable to form a single word. I pushed my chest further against his shoulder, his arm parting my cleavage."

            john "How about if I do this?"

            "I looked down at his crotch and saw an obvious protrusion."

            show cg face_2
            john "Oh, so you {i}do{/i} like it. I was afraid you didn't like me."

            "I pretended to sniffle a little and thought I'd stop the act and let go of him. But, looking at his crotch, instead my mouth watered and an ember of desire lit deep inside me. I now {i}didn't{/i} want to let go."

            show cg face_1
            think "I'm not... I'm not getting turned on as well, am I?"

            "I brushed his crotch for a second to tease him, or so I thought, and to prove I wasn't enjoying this myself, yet doing so kindled that desire all the more. My hips clenched slightly in passion as I felt a tinge of movement from my clitoris."

            think "But that can't be right. I don't like guys."

            "I looked back at Kiyoshi's face again, yet, this time, rather than merely seeing my friend's face, my heart began beating faster, seeing something else in it. Not just a friend, but...?"

            show cg face_0
            think "No, that can't..."

            show cg cuddle with dissolve
            "Despite my internal conflict, I was smiling seductively at him, moving my chest up and down his near motionless body. Being like this, near him, was making me feel more satisfied, more fulfilled, more {i}loved,{/i} than fearful, worried, or doubtful."

            john "Kiyoshi, do you like this?"

            "He nodded a little, and finally managed to creak out a few words."

            kiyoshi "Y-Yes, Jane."

            show cg face_1
            think "...Jane?"

            "I hadn't liked it earlier, but it sounded good in this context. Better than John, for a girl."

            show cg face_0
            "Rubbing my breasts against him more rapidly, my nipples were becoming more rigid, more sensitive, and my pussy was getting wetter every time I moved up and down his arm."

            stop music fadeout 2.0
            "I wanted to reach down and rub it. Not only that, but, for a second, I wanted to reach below and touch his. I shook my head to snap me out of the spell I seemed to be under."

            scene bg house_honda bedroom_kiyoshi dusk
            show kiyoshi a_5 at center:
                xcenter 0.2
            show john b_4 at center:
                faceleft
                xcenter 0.3
                easein 0.6 xcenter 0.5
            with dissolve

            think "Did I {i}really{/i} just want to do that with him?"

            show john:
                xcenter 0.5
            play music bgm_dark_fog
            "I pushed away from Kiyoshi with a worried expression. Kiyoshi stared at me, unmoving, his arms planted to the floor."

            kiyoshi "I... I didn't do anything wrong, did I?"

            show john b_11 with exchange
            john "...No."

            show kiyoshi a_4 with exchange
            kiyoshi "Sorry, John, I don't know what I was thinking..."

            john "What are you apologizing for? It was my fault."

            "I rubbed my arm a little, blushing."

            show john b_14 with exchange
            john "I... I just hope..."

            kiyoshi "Don't cry."

            "I wiped the tears welling in my eyes away with my arm."

            kiyoshi "Do you want me to do anything?"

            show john b_20 with exchange
            john "I'm fine... Let's just forget this ever happened and go to sleep."

            hide kiyoshi
            hide john
            with dissolve
            show bg dark with dissolve
            "Without saying anything, Kiyoshi stood up and sat in his chair near him. I crawled over to his futon and yanked the blanket over my head, as if the world might disappear if I didn't see it."

            think "Why on Earth did I just do that? And, worse, why did I {i}like{/i} it?"

            "I really, really didn't want to ruminate upon the reasons I might've liked being close to him. But, in Kiyoshi's bed, contentedly tucked beneath his covers, enthralled even by his scent, my loudly thumping heart told me the answer."
        "I decided against doing anything to him.":
            $ fGirlAcceptance = False
            show john b_7 with exchange
            "I shook my head."

            think "What the heck am I thinking? There's no way I could go through with something like that."

            "Yet the thought did surface, if just for a second, and that almost bothered me more than actually doing it."

            show john b_24 with exchange
            think "It's... It's just Kiyoshi's mental changes, that's all!"

            "Kiyoshi noticed my face reddening as he tossed a few blankets on his chair."

            show kiyoshi a_4 with exchange
            kiyoshi "Is something wrong?"

            show john a_2 with exchange
            john "N-No! Everything's fine, I'm fine, you?"

            kiyoshi "My situation hasn't changed substantially in three seconds, John, but I can give you upda--"

            show john a_7 with exchange
            john "No."

            show kiyoshi a_0:
                ease 0.4 left
                easeout 0.2 yanchor 0.85
            play sound sfx_bedsprings
            "Kiyoshi shrugged and flung himself into his chair, its rickety springs crying out like a myriad of mice being crushed."

            show kiyoshi:
                left
                yanchor 0.85
            show john a_10 with exchange
            john "Are you sure that thing's safe?"

            show kiyoshi a_1 with exchange
            kiyoshi "Sure I'm sure! I've slept in it many a time."

            play sound sfx_bedsprings
            "He patted the armrests with a smile and leaned back in the chair. The springs again screamed out with each inch it descended."

            show john a_16 with exchange
            john "When's the last time?"

            play sound sfx_creak
            "The chair squeaked as Kiyoshi rubbed his chin."

            show kiyoshi a_2 with exchange
            kiyoshi "Oh... Three years ago, I believe."

            "I squinted at him."

            show john b_18 with exchange
            john "If you're certain."

            show kiyoshi a_3 with exchange
            kiyoshi "When have I ever been wrong?"

            show john b_3 with exchange
            john "The alien invasion last week, the alien invasion the week before that, about the head lunch lady inserting mind control devices into the potato salads last year, and don't forget the--"

            kiyoshi "Okay, so I was a little early with my predictions. But you can't deny that I'm always {i}eventually{/i} right. The aliens, the ghost..."

            show john b_7 with exchange
            john "And the lunch lady?"

            show kiyoshi a_1 with exchange
            kiyoshi "You'll see the light one day, Jane."

            show john a_21 with exchange
            pause 0.2
            hide kiyoshi with dissolve
            "I stuck my tongue out at him, and he grinned and lay back in his chair as if sinking into it."

            stop music fadeout 2.0
            show bg dark with dissolve
            show john b_8:
                ease 0.5 center
                ease 0.5 yanchor 0.8
                linear 0.5 alpha 0.0
            "I turned off the light and headed to Kiyoshi's bed and pulled down the covers. I was just going to sleep in my uniform tonight. No matter how bad it was sleeping in it, I definitely wasn't going to get naked in front of him."

            hide john
            play music bgm_dark_fog
            "As I settled into his bed and tugged the covers over me, I smelled Kiyoshi's scent, and it was strangely... powerful."

            "I wrinkled my nose in disgust at what I just thought, yet I couldn't deny that I kinda liked being around it."

            think "Did Kiyoshi program this into me, too?"

            "If he did make me his ideal girl in every way, this tendency probably came with it as well. I was just lucky I hadn't given in tonight. I might've actually tried... doing... something with him if I started getting close to him."

            "Even though I was uncomfortable knowing I liked even his smell, I found it all too easy to calm myself to sleep in the bed."

            "Closing my eyes, I staved off all thoughts of Kiyoshi and focused only on sleep."

            "Perversely, that didn't make it any easier."

    stop music fadeout 2.0
    scene black
    with dissolve

    jump legacy_alien_murder_day5
