label blackjack2: #This is our custom label so Student Transfer can jump into our scenario.
    if persistent.sawprologue is None: #Persistent variables last even after the game is exited. We use this so the prologue will only play during the initial play.
        call bj2prologue
    scene bg city alley day
    play music bgm_funk_game_loop
    clone audrey john #Clone functions are sometimes used in the background to store bodies for later use.
    clone faith riley #Here, we store John, Riley, and Patty into the characters of Audrey, Faith, and Riley, respectively.
    clone riley patty
    $x = BlackJackBody("john", "uniform", ("a_0"),"uniform","uniform","uniform","a_0", "a_1", "a_4", "a_9") #This is an instance of a BlackJackBody class. See other_label.rpy for more info.
    show john a_0 at centerleft
    show patty a_0 at centerright
    if persistent.goodend is None: #Initializes the persistent.goodend variable with an empty list.
        $persistent.goodend = []
    $endingsobtained = [i[0] for i in persistent.goodend] #Counts the number of good endings found.
    $transformationlist = [i.name for i in all_index] #Counts the number of transformations available in the game.
    if persistent.badend is None: #Initializes the persistent.badend variable as an empty list.
        $persistent.badend = []
    if persistent.bjs is None: #Initializes persistent.bjs (blackjackstats) as an empty list.
        $persistent.bjs = [["cornelia",0,0,0,0,0,[]]]
    if persistent.specialend is None:
        $persistent.specialend = []
    if persistent.kiyoshi is None: #Initializes persistent.Kiyoshi as False. This is Boolean, or only True or False, so it is not stored as a list like the others.
        $persistent.kiyoshi = False
    if persistent.bodylist is None: #Initializes the list of bodies encountered as an empty list.
        $persistent.bodylist = []
    if persistent.difficulty is None: #Difficulty is by default set to "easy". This is checked on during gameplay.
        $persistent.difficulty = "easy"
    if persistent.nudity is None: #Nudity is set to "True" by default and is referenced in gameplay.
        $persistent.nudity = True

    patty "Are you prepared?"
    patty "Select a tarot card."
    menu tarot1: #Menu gives the player a list of options to choose with a default layout. We can also name menus so they can be "jumped" back to.
        "Go to the Options & Extras Menu.": #This is how each menu choice is formatted. It's not too complicated, but the indentation is important.
            jump bj2options #This jumps us into the options menu code, which is stored in other_label.rpy. We can have .rpy files to help with organization.
        "The Star":
            patty "The Star, huh?"
            show patty a_1
            patty "I thought you might pick that."
            $emoo = ("john", x.happy_em) #This is the code we use to display John's emotions.
            $renpy.show (emoo) #Since John is often transformed while talking, we reference a BlackJackBody class to get the appropriate emotion then use renpy.show to display it.
            john "It will grant me a wish when I win, right?" #Renpy calls and variable definitions must be done with Python. That's why $ precede each line of code there.
            show patty a_2
            patty "You'll know soon enough."
            $cmoney = 5 #This is how much money Patty with begin the game with.
            $tarot = "thestar" #The tarot variable is used to determine endins later.
        "Temperance" if len(persistent.goodend) > 0: #Menu choices can be conditional. Here, we check if we have obtained a good ending. If we have, this menu option is selectable!
            patty "The Temperance Card? I see."
            show patty a_1
            patty "Fitting, considering the situation."
            $emoo = ("john", x.suprise_em)
            $renpy.show (emoo)
            john "What do you mean?"
            show patty a_3
            patty "Sorry, you wouldn't understand. Let us begin."
            $cmoney = 8
            $tarot = "temperance"
        "The Tower" if len(persistent.goodend) > 0: #By the way, 'len' checks the number of elements within a given variable. Here, it makes sure there is at least one element in persistent.goodend.
            show patty a_1
            patty "The Tower? Unexpected."
            john "It looks powerful, if not a bit foreboding."
            patty "Perhaps. Care to find out?"
            $cmoney = 12
            $tarot = "thetower"
        "The Fool" if len(persistent.goodend) > 1:
            show patty a_9
            patty "The Fool? Interesting."
            $emoo = ("john", x.sad_em)
            $renpy.show (emoo)
            john "Are you mocking me? Don't tell me I chose the wrong card!"
            show patty a_10
            patty "There are no foolish card selections. Your needs and desires guide your hand."
            john "Sure, if you say so..."
            $cmoney = 15
            $tarot = "thefool"
        "The High Priestess" if len(persistent.goodend) > 2:
            show patty a_1
            patty "The High Priestess?"
            show patty a_9
            patty "Fascinating that you would be drawn towards an explicitly feminine card."
            $emoo = ("john", x.sad_em)
            $renpy.show (emoo)
            john "What's wrong with that?"
            john "Wait, do you mean you're just going to change me into another girl even if I win?"
            show patty a_8
            patty "I'm sorry, I've said too much already. Shall we begin?"
            john "I'm gonna regret this, aren't I?"
            $cmoney = 18
            $tarot = "thehighpriestess"
        "More..." if len (persistent.goodend) > 3: #There is limited screen real estate, especially on mobile devices, so you do not want too many menu choices.
            menu tarot2: #Here is an instance of a menu within a menu, initialiated when we select "more" in-game.
                "Back...":
                    jump tarot1
                "The Lovers" if len(persistent.goodend) > 3:
                    show patty a_9
                    patty "The Lovers? How Sweet."
                    $emoo = ("john", x.sad_em)
                    $renpy.show (emoo)
                    john "Don't patronize me. Love is powerful!"
                    show patty a_1
                    patty "I wonder if you'll still think so after this."
                    john "What's that supposed to mean?"
                    show patty a_2
                    patty "Oh, nothing. Let us begin."
                    $cmoney = 21
                    $tarot = "thelovers"
                "Judgement" if len(persistent.goodend) > 5:
                    show patty a_7
                    patty "You picked the Judgement Card. Impressive."
                    $emoo = ("john", x.happy_em)
                    $renpy.show (emoo)
                    john "I chose correctly, didn't I?"
                    show patty a_3
                    patty "In a sense, yes."
                    show patty a_5
                    patty "But only if you win."
                    $cmoney = 25
                    $tarot = "judgement"
                "The Sun" if len (persistent.goodend) > 6:
                    patty "The Sun card. Indicative of a positive outlook."
                    show patty a_2
                    patty "Can you tell you're approaching your goal?"
                    $emoo = ("john", x.suprise_em)
                    $renpy.show (emoo)
                    john "Goal? I'm not sure what your angle is."
                    show patty a_1
                    patty "I'm sorry. That's beyond your realm of understanding."
                    $emoo = ("john", x.neutral_em)
                    $renpy.show (emoo)
                    john "I just want to go back to normal, okay?"
                    show patty a_3
                    patty "Then let's play."
                    $cmoney = 30
                    $tarot = "thesun"
                "Strength" if len (persistent.goodend) > 6:
                    show patty a_2
                    patty "Strength. Is that what you seek?"
                    $emoo = ("john", x.suprise_em)
                    $renpy.show (emoo)
                    john "What do you mean? I thought I was just picking a card here."
                    show patty a_1
                    patty "Well, yes and no."
                    $emoo = ("john", x.sad_em)
                    $renpy.show (emoo)
                    john "Really? Uh, maybe I should choose a different one, then."
                    show patty a_5
                    patty "Your hand has already guided your fate. It cannot be changed."
                    john "That sounds...ominous."
                    show patty a_3
                    patty "Worry not. The outcome will please you. If you win."
                    $cmoney = 35
                    $tarot = "strength"
                "Wheel of Fortune" if len (persistent.goodend) > 7:
                    show patty a_3
                    patty "The Wheel of Fortune. How reckless."
                    $emoo = ("john", x.sad_em)
                    $renpy.show (emoo)
                    john "Don't chastise me! You told me to pick a card."
                    show patty a_4
                    patty "My apologies. Chance can be a cruel mistress. That's all."
                    $emoo = ("john", x.neutral_em)
                    $renpy.show (emoo)
                    john "How so?"
                    show patty a_8
                    patty "You best win so you don't find out."
                    $cmoney = 40
                    $tarot = "wheeloffortune"
                "More..." if len (persistent.goodend) > 8:
                    menu tarot3: #Another menu within a menu. You can do this however many times you want, but using "Jump" is an alternative to avoid potential indentation issues.
                        "Back...":
                            jump tarot2
                        "The Empress":
                            show patty a_1
                            patty "The Empress. Such power, yet so feminine."
                            $emoo = ("john", x.suprise_em)
                            $renpy.show (emoo)
                            john "Feminine? Uh, Should I have picked The Emperor card, instead?"
                            show patty a_10
                            patty "I'm not the one to say. Your hand has guided your fate."
                            $emoo = ("john", x.sad_em)
                            $renpy.show (emoo)
                            john "Damn, this isn't going to return me to normal, is it?"
                            show patty a_9
                            patty "Those are your words. Not mine."
                            john "..."
                            show patty a_5
                            patty "Let us proceed."
                            $cmoney = 45
                            $tarot = "theempress"
                        "The World" if len (persistent.goodend) > 10:
                            show patty a_11
                            patty "The World Card. Finally."
                            $emoo = ("john", x.suprise_em)
                            $renpy.show (emoo)
                            john "What do you mean by finally? I just got here!"
                            show patty a_8
                            patty "How should I explain?"
                            $emoo = ("john", x.happy_em)
                            $renpy.show (emoo)
                            john "No need to complicate things. As long as I picked the right card, I'm happy."
                            show patty a_5
                            patty "As you wish."
                            show patty a_3
                            patty "But I shall not lose."
                            $cmoney = 50
                            $tarot = "theworld"
                        "The Devil" if len (persistent.goodend) > 11:
                            show patty a_8
                            patty "Huh? I don't remember putting that there."
                            $emoo = ("john", x.suprise_em)
                            $renpy.show (emoo)
                            john "Are you okay? You don't look so great."
                            show patty a_4
                            patty "No. Something's horribly wrong. I feel a demonic presence..."
                            show patty a_6
                            patty "..."
                            show circeGhost a_12 at centerright, faceleft
                            think "Muahahaha. It's my turn!"
                            possess circe patty a_11 #This is a custom Student Transfer animation. It will show a ghost of Circe taking over Patty with the given expression.
                            $emoo = ("john", x.sad_em)
                            $renpy.show (emoo)
                            john "Uh, are you alright, Patty? You don't look very...sane."
                            show circe a_4
                            #hide circe
                            show patty a_11 at centerright
                            $patty.name = "Circe" #This changes Patty's display name to Circe for the game's story by changing altering her character variable.
                            patty "Whatever do you mean? I feel fantastic. Let's play some Blackjack."
                            $emoo = ("john", x.suprise_em)
                            $renpy.show (emoo)
                            john "You know what? I'm out. You can just turn me back to Cornelia's twin and keep my money."
                            show patty a_9
                            patty "Oh, no you don't! Unless you'd like to face my card's wrath, you're staying right there."
                            $emoo = ("john", x.sad_em)
                            $renpy.show (emoo)
                            think "Gulp."
                            show patty a_11
                            patty "Come hither, John. You face Circe, the sexiest, most powerful of all demons. Bow before me!"
                            patty "Now, let's see if you can take all of my chips. How about, mmm, 100? Does that sound fair?"
                            think "I'm so doomed."
                            show patty a_9
                            patty "That you are, John. That you are."
                            $cmoney = 100
                            $tarot = "thedevil"
    jump gamestart

label gamestart:
    $starterdeck = [2,3,4,5,6,7,8,9,10,"Jack", "Queen","King", "Ace","Joker", #This is the initial deck of cards that will be used for gameplay. It is a list of integers and strings.
                    2,3,4,5,6,7,8,9,10,"Jack", "Queen","King", "Ace","Joker",
                    2,3,4,5,6,7,8,9,10,"Jack", "Queen","King", "Ace","Joker",
                    2,3,4,5,6,7,8,9,10,"Jack", "Queen","King", "Ace","Joker"]
    $deck = starterdeck.copy() #A copy of the starter deck is used to form the initial deck.
    $random.shuffle(deck) #Shuffle is a python command that can be used to randomly reorder a list.
    if persistent.difficulty == "easy":
        $difficulty = "easy" #The difficulty level stored as a persistent variable is stored as a regular variable for easier use.
    if persistent.difficulty == "medium":
        $difficulty = "medium"
    $jmoney = 25 #John starts with $25 worth of chips. It is overwritten with a smaller amount while playing as Kiyoshi or Riley.
    if x.name == "kiyoshi":
        $jmoney = 20
    if x.name == "riley":
        $jmoney = 15
    $johnwins = False
    $hands = 0 #The number of hands played. Used for in-game progression.
    $stake = 0 #The current stake. It will be raised automatically as the game is played.
    $jhandtotal = 0 #This is the current value of John's hand. 21 is the ideal score. He will lose the hand if he exceeds that amount.
    $chandtotal = 0 #This is the current value of Patty's hand.
    $sayakameter = 0 #The amount of hands played while John is Sayaka. If he chooses to stay as her for too long, a special ending is unlocked.
    $optionsmenu = False #This is a variable to tell the game that we are currently playing the game and not viewing endings from the options menu.
    if persistent.firstaccent is None: #John will talk with an accent the first time he talks as Sadie. This is disabled after the special dialogue is viewed.
        $persistent.firstaccent = True
    $yourturn = False #Notes whether we are currently being dealt cards.
    $aiturn = False #Notes whether the computer opponent is being dealt cards.
    $jokerplayed = False #Notes if a Joker has recently been activated. This will prevent John from transforming quickly in succession.
    $firsttime = True #Notes whether John has "checked himself out". This dialogue will only trigger once per game.
    show screen gamestatus with moveintop

label newhand:
    $emoo = ("john", x.neutral_em)
    $renpy.show (emoo)
    show patty a_0
    if jokerplayed and cooldown == 0: #If a Joker was triggered last turn, we set a cooldown variable to 1 so none will trigger this turn.
        $cooldown = 1
    else: #If the cooldown is no longer 0, instead it will be returned to 0 and John can be transformed once again.
        $jokerplayed = False
        $cooldown = 0
    $hands += 1 #Increase the counter for hands played by one.
    $mp = 1 #A "magic points" variable. Certain characters have abilities that can only be used once per hand.
    if x.name == "sadie": #Sadie's ability can be used twice, so we give her an additional mp.
        $mp += 1
    $stake = (hands //7) + 1 #The stake is always set to hands // 7 +1.  // is the floor division operator in Python, so any amount below 1 is rounded down to 0.
    if hands % 7 == 0: #% is the Modulo operator. This is the remainder after doing division. So, this dialogue triggers every 7 hands.
        patty "We're now [hands] hands into the match." #Note we can use brackets to reference variables during dialogue. This even works for numbers!
        show patty a_3
        patty "The cards grow restless. We must make haste."
        "The base stake has been raised to [stake]!"
        show patty a_0
    if x.name == "cassie": #Cassie's ability doubles the stakes. If John's body is named Cassie, the stake is doubled with dialogue explaining why.
        $stake = stake*2
        "Cassie's influence doubles the stakes!"
    hide screen cardone #Each card is coded as its own screen. We can hide a screen even if they're not currently displayed, so I just hide all of them.
    hide screen cardtwo
    hide screen cardthree
    hide screen cardfour
    hide screen cardfive
    hide screen cardsix
    hide screen cardseven
    hide screen ccardone
    hide screen ccardtwo
    hide screen ccardthree
    hide screen ccardfour
    hide screen ccardfive
    hide screen ccardsix
    hide screen ccardseven
    $jmoney -= stake #The stake is automatically subtracted from John and the AI's current pots.
    $cmoney -= stake
    $jhandtotal = 0
    if x.name == "flavia": #Checks if John's body is named Flavia. If it is, the code for her ability is ran.
        "Flavia's speed starts you with 1 point!"
        $jhandtotal += 1 #His hand score is incremented by 1.
    if x.name == "mel": #The same is done for Mel.
        "Mel's endurance gives 2 of your points to your opponent!"
        $jhandtotal -= 2
    $chandtotal = 0
    if x.name == "mel": #Since the opponent's value is initialized separately, we check for Mel's body once again.
        $chandtotal += 2
    #This is a throwaway variable used for multiple things. It's initialized at 0.6 to avoid unintended behavior with Phila.
    $randomvalue = 0.6
    $Ace = 0 #Tracks whether we have an Ace that is currently counting for 11 points.
    $cardcount = 0 #This is the amount of cards in our current hand.
    $ccardcount = 0
    $cAce = 0
    $stakeraise = False #Variable for if the stake has been raised.
    $yourturn = False #Variable for if we are currently taking our turn.
    $aiturn = False
    $southerndraw = False #Variable for if Sadie's special ability is in effect.
    call deal #This is the code for John being dealt a card.
    call cdeal #This calls the code for the AI being dealt a card.
    call deal
    call cdeal
    if jhandtotal == 21 and chandtotal == 21: #Jumps to a tie in the rare instance both players are dealt a Blackjack.
        $aihand = True
        jump tiehand
    if jhandtotal == 21: #Jumps to the Blackjack code if only John is dealt a Blackjack.
        jump jblackjack
    if chandtotal == 21: #Jumps to the Blackjack code if only Patty is dealt a Blackjack.
        jump cblackjack
    #patty "Alright, no Blackjacks here. Let's play this out."
    jump stakechoice

label stakechoice:
    if x.name == "setsuna": #Setsunsa cannot raise, so we jump straight back to the opponent if we have her body.
        "Setuna's ailment skips your ability to raise."
        jump opponentchoice
    menu:
        patty "Would you like to raise?"
        "Raise":
            $stakeraise = True #The computer will be given a choice whether to call, fold, or raise us back.
            jump opponentchoice
        "Do not raise.":
            jump opponentchoice
        "Squint" if x.name == "michelle" and mp > 0 and cardcount < 3: #If we are Michelle, we can "squint" to look at our face-down card, but only if we only have 2 cards in hand.
            $randompick = renpy.random.random()
            $mp -= 1 #This consumes our mp, meaning we can only squint once per hand.
            if randompick > 0.4: #This only works 60% of the time.
                $preview = cardstring1
            else:
                $preview = renpy.random.choice (starterdeck) #If squint is unsuccessful, it will generate the name of a card completely at random from the starter deck.
            think "On closer inspection, I think my facedown card is a [preview], but I'm not sure I would bet on it..."
            jump stakechoice
        "Check the Top card of the deck." if x.name == "maria" and mp > 0: #This is Maria's special ability to check the top card of the deck. We must have an mp to use it.
            if len (deck) == 0: #If the deck is empty, John's thoughts show that this ability has no effect.
                $emoo = ("john", x.sad_em)
                $renpy.show (emoo)
                think "It's no use. The deck is completely empty right now..."
                $emoo = ("john", x.neutral_em)
                $renpy.show (emoo)
                jump stakechoice
            $emoo = ("john", x.happy_em)
            $renpy.show (emoo)
            think "Heh, Maria's body let me sneak a little peek. It appears the next card will be a [deck[0]]."
            $emoo = ("john", x.neutral_em)
            $renpy.show (emoo)
            $mp -= 1
            jump stakechoice
        "Count cards." if x.name == "kyoko": #Kyoto's ability displays information about the remaining cards in the deck.
            if len (deck) > 0: #Checks if there are cards left in the deck. If there are none, a sepcial alternate case occurs.
                $countdeck = deck.copy() + [ccardstring1] #The number of cards in the deck, plus the computer's face-down card.
                $tencount = countdeck.count(10)+countdeck.count("Jack")+countdeck.count("Queen")+countdeck.count("King") #The number of cards from countdeck that are worth 10 points.
                $acecount = countdeck.count("Ace") #Counts the number of aces in the deck. Not used.
                $jokercount = countdeck.count ("Joker") #Counts the number of Jokers left in the deck. Not used.
                $decksize = len (countdeck) #Counts the number of cards left between the deck and opponent's face-down card.
                $ratio = int (tencount/decksize*100) #This is the percentage of unknown cards that are of value 10. It's multiplied by 100 and converted to an integer to display as a %.
                john "I've been closely tracking the cards dealt so far. There are [tencount] cards left that count for ten, which makes up
                [ratio]% of the [decksize] remaining cards." #The dialogue that uses these variables.
                $countdeck = list(map(str, countdeck)) #These functions format the cards in an easier-to-read format to be displayed.
                $countdeck = ", ".join(sorted(countdeck))
                john "As for the deck itself, its contents are: [countdeck]."
                john "Hmm, hopefully I can leverage this information somehow..."
            else: #Since there are no cards in the deck, Kyoko knows the opponent's card thanks to her card counting skillz.
                kyoko "There are no cards left in the deck, so I can deduce the opponent's face-down card is a [ccardstring1]."
                john "Hmm, hopefully I can leverage this information somehow..."
            jump stakechoice
        "Forfeit match." if tarot in endingsobtained and hands == 1: #You can only forfeit the match if you have previously won this route and this is your first hand.
            show patty a_7
            patty "Forfeit? Are you quite serious?"
            show patty a_4
            patty "Seriously, I can't recommend this. There's a lot at stake here!"
            menu:
                "Do Not Forfeit.":
                    show patty a_6
                    patty "I see. Please don't joke about this kind of thing."
                    show patty a_4
                    patty "Believe it or not, I am a human, too. Even the thought of such a nonsensical act of self-sabotage weighs heavily on me."
                    show patty a_0
                "Forfeit.":
                    show patty a_3
                    patty "Understood. I can't pretend I understand your motivations, but I will fulfill your request all the same."
                    jump bj2badend
            jump stakechoice

label callchoice:
    if x.name == "vanessa": #If you are Vanessa, there is a 50% chance you will counter-raise out of anger.
        $randompick = renpy.random.random() #Generates a random value between 0 and 1.
        if randompick > 0.5: #If the value is over 0.5, the ability will be active and this dialogue will be played.
            $emoo = ("john", x.sad_em)
            $renpy.show (emoo)
            john "That raise pisses me off. I'll show her who's boss!"
    else:
        if x.name != "Tori": #If our body isn't Tori or Vanessa, the randompick variable is set to 0 for later.
            $randompick = 0
    menu:
        patty "The stake is currently [stake*2]. How do you respond?"
        "Call." if randompick < 0.5: #Vanessa cannot call if she's angry.
            $jmoney -= stake
            $cmoney -= stake
            $stake = stake * 2
            jump mainscreen #This takes us back to the main screen for gameplay.
        "Raise." if x.name != "setsuna":
            $jmoney -= stake*3
            $jmoney -= stake*3
            $stake = stake * 4
            jump mainscreen
        "Fold." if (randompick < 0.5 and x.name != "tori"): #Vanessa cannot fold if she's angry. Tori can never fold.
            jump losehand #Jumps to the function for losing a hand.
        "Squint" if x.name == "michelle" and mp > 0 and cardcount < 3: #These functions are duplicates from earlier. They have the same functionality.
            $randompick = renpy.random.random()
            $mp -= 1
            if randompick > 0.4:
                $preview = cardstring1
            else:
                $preview = renpy.random.choice (starterdeck)
            think "On closer inspection, I think my facedown card is a [preview], but I'm not sure I would bet on it..."
            jump callchoice
        "Check the Top card of the deck." if x.name == "maria" and mp > 0: #Identical to previous instance.
            if len (deck) == 0:
                $emoo = ("john", x.sad_em)
                $renpy.show (emoo)
                think "It's no use. The deck is completely empty right now..."
                jump callchoice
            $emoo = ("john", x.happy_em)
            $renpy.show (emoo)
            think "Heh, Maria's body let me sneak a little peek. It appears the next card will be a [deck[0]]."
            $mp -= 1
            jump callchoice
        "Count cards." if x.name == "kyoko": #Identical to previous instance.
            if len (deck) > 0:
                $countdeck = deck.copy() + [ccardstring1]
                $tencount = countdeck.count(10)+countdeck.count("Jack")+countdeck.count("Queen")+countdeck.count("King")
                $acecount = countdeck.count("Ace")
                $jokercount = countdeck.count ("Joker")
                $decksize = len (countdeck)
                $ratio = int (tencount/decksize*100)
                john "I've been closely tracking the cards dealt so far. There are [tencount] cards left that count for ten, which makes up
                [ratio]% of the [decksize] remaining cards."
                $countdeck = list(map(str, countdeck))
                $countdeck = ", ".join(sorted(countdeck))
                john "As for the deck itself, its contents are: [countdeck]."
                john "Hmm, hopefully I can leverage this information somehow..."
            else:
                kyoko "There are no cards left in the deck, so I can deduce the opponent's face-down card is a [ccardstring1]."
                john "Hmm, hopefully I can leverage this information somehow..."
            jump callchoice

label jblackjack: #The function for when you get a Blackjack.
    $aiturn = True
    show patty a_2
    patty "Fortune has smiled upon you. You drew a Blackjack and win this hand by default."
    show patty a_0
    $jmoney -= stake #Money is deducted from both players to reflect the doubled stakes.
    $cmoney -= stake
    patty "Blackjacks automatically double the stakes."
    $stake = stake*2
    jump winhand #Proceeds to complete the hand.

label cblackjack: #Similar to the previous function, only for the opponent,
    $aiturn = True
    show patty a_9
    patty "The cards have betrayed you. That's a Blackback, and this hand is mine."
    show patty a_0
    $jmoney -= stake
    $cmoney -= stake
    patty "Blackjacks automatically double the stakes."
    $stake = stake*2
    jump losehand

label winhand: #This function plays after you successfully win a hand.
    show patty a_2
    patty "You win this hand. The pot of $[stake*2] is yours."
    $jmoney += (stake*2) #Your money is increased by double the stake. (The sum of your plus your opponent's stake.)
    python:
        for i in persistent.bjs: #The body's stats are reflected in the BlackJackStats persistent variable.
            if i[0] == x.name:
                i[2] += 1
                i[5] += stake
    #"[persistent.bjs]" #Blackjackstats can be displayed here, but it is commented out.
    if cmoney <= 0:
        jump bj2goodend #If your opponent is out of money, you win! Otherwise, continue playing.
    jump newhand

label losehand: #Basically the winhand function but the opposite.
    $aiturn = True
    show patty a_4
    patty "Too bad. You lose this hand. The pot of $[stake*2] is mine."
    show patty a_0
    $cmoney += (stake*2)
    python:
        for i in persistent.bjs: #Your stats are recorded in blackjackstats.
            if i[0] == x.name:
                i[3] += 1
                i[5] -= stake
    #"[persistent.bjs]"
    if jmoney <= 0:
        jump bj2badend #If you're out of money, the bad ending will play. Otherwise, continue play.
    jump newhand

label mainscreen: #This is the main screen where you play Blackjack.
    $ yourturn = True #Since you're currently taking your turn, we use a variable to reflect that.
    $emoo = ("john", x.neutral_em)
    $renpy.show (emoo)
    menu:
        patty "What would you like to do?"
        "Duel" if x.name == "izuna": #A special ability that can (and must!) be played if you're Izuna.
            while jhandtotal < 21 and chandtotal < 21: #This while loop will run until a player's hand reaches or exceeds 21.
                $randomvalue = renpy.random.random() #Generate a random value between 0 and 1.
                if randomvalue > 0.5: #If the random value is above 0.5, you'll be dealt a card first this time.
                    play sound sfx_whack
                    call deal
                    if jhandtotal == 21: #Win by default if you reach 21.
                        jump winhand
                    play sound sfx_whack
                    call cdeal #Opponent is then dealt a card.
                    if chandtotal > 21:
                        show patty a_4
                        patty "Hmm, it appears I busted."
                        show patty a_0
                        jump winhand #Win if opponent busts.
                    if chandtotal == 21:
                        jump losehand #Lose if opponent reaches 21 before you.
                else: #If the random value is below 0.5, opponent is dealt a card first this time.
                    play sound sfx_whack
                    call cdeal
                    if chandtotal > 21:
                        show patty a_4
                        patty "Hmm, it appears I busted."
                        show patty a_0
                        jump winhand #Win the hand if opponent busts.
                    if chandtotal == 21:
                        jump losehand #Lose the hand if opponent reaches 21.
                    play sound sfx_whack
                    call deal
                    if jhandtotal == 21:
                        jump winhand #Win the hand if you reach 21.
        "Hit" if x.name != "cornelia" and x.name != "izuna": #Cornelia and Izuna cannot hit.
            play sound sfx_whack
            call deal
            jump mainscreen
        "Hit" if x.name == "cornelia": #Cornelia has her own special hit. About 1/3 of the time, she'll come up "short" and not do anything!
            $randompick = renpy.random.random()
            if randompick < 0.33: #There's a 33% chance the number will be under 0.33.
                think "Meh, I'm not feeling it. I guess I'm stuck with my current hand."
                jump aitaketurn
            play sound sfx_whack
            call deal
            jump mainscreen
        "Borrow." if x.name == "sadie" and mp > 0: #Sadie's ability sets "Southern Draw" to True. So, you'll draw a copy of your opponent's card instead of from the deck.
            $southerndraw = True
            $mp -= 1 #Decrease current mp by 1. Sadie's ability can be used twice per hand (or, once if she just transformed.)
            play sound sfx_whack
            call deal
            jump mainscreen
        "Hold" if x.name!= "izuna" and (x.name != "carrie" or jhandtotal > 16): #Carrie must hit on hands below 17. Izuna cannot hold at all.
            jump aitaketurn #Opponent plays out their turn after holding.
        "Squint" if x.name == "michelle" and mp > 0 and cardcount < 3: #Identical to previous instances of squint.
            $randompick = renpy.random.random()
            $mp -= 1
            if randompick > 0.4:
                $preview = cardstring1
            else:
                $preview = renpy.random.choice (starterdeck)
            think "On closer inspection, I think my facedown card is a [preview], but I'm not sure I would bet on it..."
            jump mainscreen
        "Check the Top card of the deck." if x.name == "maria" and mp > 0: #Identical to previous instances.
            if len (deck) == 0:
                $emoo = ("john", x.sad_em)
                $renpy.show (emoo)
                think "It's no use. The deck is completely empty right now..."
                jump mainscreen
            $emoo = ("john", x.happy_em)
            $renpy.show (emoo)
            think "Heh, Maria's body let me sneak a little peek. It appears the next card will be a [deck[0]]."
            $mp -= 1
            jump mainscreen
        "Count cards." if x.name == "kyoko": #Identical to previous instances.
            if len (deck) > 0:
                $countdeck = deck.copy() + [ccardstring1]
                $tencount = countdeck.count(10)+countdeck.count("Jack")+countdeck.count("Queen")+countdeck.count("King")
                $acecount = countdeck.count("Ace")
                $jokercount = countdeck.count ("Joker")
                $decksize = len (countdeck)
                $ratio = int (tencount/decksize*100)
                john "I've been closely tracking the cards dealt so far. There are [tencount] cards left that count for ten, which makes up
                [ratio]% of the [decksize] remaining cards."
                $countdeck = list(map(str, countdeck))
                $countdeck = ", ".join(sorted(countdeck))
                john "As for the deck itself, its contents are: [countdeck]."
                john "Hmm, hopefully I can leverage this information somehow..."
            else:
                kyoko "There's are no cards left in the deck, so I can deduce the opponent's face-down card is a [ccardstring1]."
                john "Hmm, hopefully I can leverage this information somehow..."
            jump mainscreen
        "Exchange hands." if x.name == "anuja" and cardcount == 2 and mp > 0: #Anuja can use foreign exchange once per hand, but only if you haven't drawn yet.
            patty "So you want to trade hands, eh? Well, that's your perogative."
            $newcardstring1 = ccardstring1 #All cards and their associated characteristics are swapped between you and the opponent.
            $newcardstring2 = ccardstring2
            $ccardstring1 = cardstring1
            $ccardstring2 = cardstring2
            $cardstring1 = newcardstring1
            $cardstring2 = newcardstring2
            $newhandtotal = chandtotal
            $chandtotal = jhandtotal
            $jhandtotal = newhandtotal
            $newace = Ace #Don't forget the ace count!
            $newace2 = cAce
            $Ace = newace2
            $cAce = newace
            show patty a_9
            patty "Do you like your new cards? Sorry, no takebacks!"
            show patty a_0
            $ mp -= 1
            jump mainscreen

        "Inspect self." if x.name != "john" and x.name != "kiyoshi" and x.name != "riley": #John can check himself out, but he's not too interested in his original form.
            call femalebodyinspector #Function that explains John's current body.
            jump mainscreen

label opponentchoice: #This is the algorithm that determines if the opponent will hold, raise or fold.
    if difficulty == "easy": #Opponent always raises back on Easy difficulty.
        if stakeraise:
            show patty a_3
            patty "Fate demands that I raise you back."
            show patty a_0
            $jmoney -= (stake *3) #Money is deducted from both players' pots to reflect the now quadrupled stakes.
            $cmoney -= (stake *3)
            $stake = stake * 4
        elif chandtotal > 17: #On easy difficulty, opponent always raises if hand exceeds 17.
            show patty a_1
            patty "Ah, the cards are calling. I must raise you."
            show patty a_0
            jump callchoice #You have the chance to call or fold.
        else: #If neither of the previous conditions are met, opponent will call.
            show patty a_6
            patty "My cards are silent. I shall go with the flow."
            show patty a_0
    if difficulty == "medium":
        if stakeraise: #This part of the algorithm only plays if you raise your opponent.
            if (firstcard + 11 <= chandtotal and chandtotal > 16) or chandtotal == 20: #Opponent will raise on a 20 or if their hand is greater than your face down card+11.
                show patty a_3 #Opponent's hand also must be above 16 to raise.
                patty "Fate demands that I raise you back."
                show patty a_0
                $jmoney -= (stake *3)
                $cmoney -= (stake *3)
                $stake = stake * 4
            elif (firstcard + 11 <= chandtotal) or chandtotal == 18 or chandtotal == 19 or firstcard < 8 or ccardstring1 == "Ace" or ccardstring2 == "Ace":
                show patty a_5 #Otherwise, opponent will call on an 18, 19, or if your revealed card is above an 8, or if their hand is greater than your face down card + 11.
                patty "The spirits make me wary. I shall call."
                show patty a_0
                $jmoney -= (stake) #On a call, the stakes are only doubled.
                $cmoney -= (stake)
                $stake = stake * 2
            elif (chandtotal > 11 and chandtotal < 17) and cmoney > 0: #If previous conditions do not apply and hand is 12-16, opponent will fold.
                show patty a_4
                patty "My fate is sealed. I concede."
                show patty a_0
                jump winhand
            else:
                show patty a_5
                patty "The spirits make me wary. I shall call." #Otherwise, opponent will call.
                show patty a_0
                $jmoney -= (stake)
                $cmoney -= (stake)
                $stake = stake * 2
        elif chandtotal == 20: #Plays if you do not raise and opponent's hand value is 20.
            show patty a_1
            patty "Ah, the cards call to me. I must raise you."
            show patty a_0
            jump callchoice
        elif (chandtotal > firstcard +10 or firstcard < 8) and (chandtotal > 16 or chandtotal < 12): #If opponent's hand is either 11 or lower or 17 or higher:
            show patty a_1 #Opponent will raise if their hand is greater than your first card plus 10. Or, if your first card is below an 8.
            patty "Ah, the cards call to me. I must raise you."
            show patty a_0
            jump callchoice
        else: #If other conditions aren't met, opponent calls.
            show patty a_6
            patty "My cards are silent. I abide."
            show patty a_0
    jump mainscreen

label aitaketurn: #This is the function called when opponent deals themselves cards.
    $aiturn = True #AI turn is now active.
    show patty a_5
    patty "Okay. Now, what does fate have in store for me?"\

label cdealloop: #This is the loop that takes place while the dealer has cards.
    if chandtotal < 17: #Via dealer rules, opponent must deal themselves cards until they have at least 17.
        call cdeal
        if chandtotal < 17:
            jump cdealloop
    if chandtotal > 21: #If opponent exceeds 21, reduce their points by 10 if they have an ace.
        if cAce > 0:
            $cAce -= 1
            $chandtotal -= 10
            jump cdealloop
        show patty a_4 #If opponent has no aces, they bust and you win the hand.
        patty "Hmm, it appears I busted."
        show patty a_0
        jump winhand
    if x.name == "allison" and jhandtotal > 21: #Allison's ability only works if opponent doesn't bust. So, you lose at this point.
        jump losehand

label tiehand: #The function that plays when both players have the same hand total.
    if chandtotal == jhandtotal:
        if jokerplayed == False: #John can only be transformed if a Joker wasn't recently played.
            show patty a_7
            python:
                for i in persistent.bjs: #Ties are recorded for posterity.
                    if i[0] == x.name:
                        i[4] += 1
            #"[persistent.bjs]"
            patty "Oh, just a tie? But wait, the deck grows restless. The cards act on their own!" #Ties will trigger a random transformation.
            show patty a_0
            $randomvalue = renpy.random.random()
            if randomvalue > 0.5: #50% of the time, John will get a beneficial body. Otherwise, he will get one with a drawback.
                call Jokertime
            else:
                call cJokertime
        else:
            show patty a_6
            python:
                for i in persistent.bjs:
                    if i[0] == x.name:
                        i[4] += 1
            #"[persistent.bjs]"
            patty "Huh, just a tie. I'll return our stakes."
            show patty a_0
        $jmoney += stake #Stakes are returned to each player.
        $cmoney += stake
        jump newhand
    if chandtotal > jhandtotal:
        jump losehand #If all other conditions don't apply, you lose if your hand score is less than your opponent's.
    else:
        jump winhand #Otherwise, you win the hand.

label deal: #This is the function that deals cards to your hand.
    if len (deck) == 0: #If there are no cards left in the deck, a new one will first be created.
        call newdeck
    if x.name == "katrina" and cardcount == 2 and len (deck) > 1: #If you're Katrina, you get to pick one of two cards from the top of the deck when you hit.
        menu:
            "Katrina's influence grants you good luck! Which card would you prefer?"
            "[deck[0]]": #The card is read directly from the deck list.
                $card = deck[0]
                $renpy.random.shuffle(deck) #After the card is chosen, the deck is shuffled.
            "[deck[1]]":
                $card = deck[1]
                $renpy.random.shuffle(deck)
    else:
        $card = deck[0] #The card drawn defaults to the first card in the deck list.
    if x.name == "zoey": #If Zoey draws a card that exceeds 8 in value, it is changed to an 8.
        if card == "King" or card == "Queen" or card == "Jack" or card == 10 or card == "Ace" or card == 9:
            $card = 8
    if x.name == "irene": #If Irene draws a card that is below 6 in value, it is changed to a 6.
        if card == 5 or card == 4 or card == 3 or card == 2:
            $card = 6
    if x.name == "audrey" and cardcount > 1: #When Audrey hits, she will always draw a 5,6,7,8, or 9.
        $median = [5,6,7,8,9]
        $card = renpy.random.choice(median)
    $deck.pop(0) #When the card is played, remove the card from the deck.
    if x.name == "mina" and cardcount == 1: #While Mina, your second card is transformed into a copy of the first card.
        $newcard = cardstring1
        if newcard != "King" and newcard != "Queen" and newcard != "Jack" and newcard != "Ace":
            $card = int(newcard) #When borrowing a numbered card, we have to make sure it is an Integer for later.
        else:
            $card = newcard
    if x.name == "yui":
        $randomvalue = renpy.random.random() #While Yui, there is a 25% chance any card drawn below 10 becomes an Ace.
        if randomvalue > 0.75 and card != "Ace" and card != 10 and card != "King" and card != "Queen" and card != "Jack":
            "Looks like you aced another one! Your [card] was turned into an Ace!"
            $card = "Ace"
    if x.name == "phila" and cardcount == 1:
        if randomvalue > 0.5: #A random value is drawn earlier. This ability will only work half of the time.
            $newcard = ccardstring1 #If Phila's ability triggers, your 2nd card will be a copy of opponent's first card.
            if newcard != "King" and newcard != "Queen" and newcard != "Jack" and newcard != "Ace": #Otherwise, your 1st card is a copy of your opponent's second card.
                $card = int(newcard)
            else:
                $card = newcard
    if southerndraw: #This part of the code triggers when Sadie's special ability is being used.
        #$card = ccardstring1 Your card is set to your opponent's face-down card. Only this code is redundant.
        if persistent.firstaccent: #If Sadie's accent conversation hasn't happened yet, here it is!
            $emoo = ("john", x.happy_em)
            $renpy.show (emoo)
            john "Thank ya for the card, hun!"
            show patty a_2
            patty "Uh, sure. Are you feeling okay, John?"
            john "Whaddya mean? Shoot, I'm feelin' just fine 'n' dandy."
            $emoo = ("john", x.sad_em)
            $renpy.show (emoo)
            john "Oh, uh, sorry, that came out funny. Let's just pretend I didn't say that, okay?"
            show patty a_9
            patty "It's okay, John. Golly, nothin' quite like talkin' like a fine southern gal every now and then, ya hear?"
            john "..."
            $emoo = ("john", x.neutral_em)
            $renpy.show (emoo)
            $persistent.firstaccent = False #The conversation is now marked as played.
        $newcard = ccardstring1 #Stores the opponent's first card in a variable.
        if newcard != "King" and newcard != "Queen" and newcard != "Jack" and newcard != "Ace":
            $card = int(newcard) #Sets your card to a variable in the suitable format.
        else:
            $card = newcard
        $southerndraw = False #When this finishes, 'Southern Draw' will no longer be active.
    #play sound sfx_page_turn_2
    if cardcount == 0: #These functions show the drawn cards on the screen.
        $cardstring1 = str(card)
        show screen cardone with moveintop
    elif cardcount == 1:
        $cardstring2 = str(card)
        show screen cardtwo with moveintop
    elif cardcount == 2:
        $cardstring3 = str(card)
        show screen cardthree with moveintop
    elif cardcount == 3:
        $cardstring4 = str(card)
        show screen cardfour with moveintop
    elif cardcount == 4:
        $cardstring5 = str(card)
        show screen cardfive with moveintop
    elif cardcount == 5:
        $cardstring6 = str(card)
        show screen cardsix with moveintop
    elif cardcount == 6:
        $cardstring7 = str(card)
        show screen cardseven with moveintop
    else:
        show patty a_4
        patty "How unfortunate. Our playing space is limited. I'll just deal this on top of the previous card." #If you hit the limit of 7, we'll override the final card, instead.
        show patty a_0
        $cardstring7 = str(card)
        show screen cardseven with moveintop
    if card == "Jack" or card == "Queen" or card == "King":
        $jhandtotal += 10 #Face cards add 10 to John's total.
        if x.name == "bradGB": #While Bread, John's cards count for an additional point.
            $jhandtotal += 1
        if cardcount == 1:
            $firstcard = 10 #Your first card is stored for computer algorithm purposes.
    elif card == "Ace":
        $jhandtotal += 11 #Aces count for 11.
        if x.name == "bradGB":
            $jhandtotal += 1
        $Ace = Ace+1
        if cardcount == 1:
            $firstcard = 10
    elif card == "Joker": #If a Joker is revealed, call the Joker code unless one has recently been played.
        if jokerplayed == False:
            call Jokertime
            jump deal #Return to dealing cards after the Joker.
        else:
            show patty a_3
            patty "The cards have granted you a brief respite. Your body needs time to recuperate."
            show patty a_0
            jump deal
    else: #This is identical to the previous section, only we read values directly from the card names since they're already numbers.
        $jhandtotal += card #Your hand is increased by the card name.
        if cardcount == 1:
            $firstcard = card #Your revealed card is set to the card name.
        if x.name == "bradGB":
            $jhandtotal += 1
    if jhandtotal == 21 and yourturn:
        jump aitaketurn #Pass to the AI turn if you reach 21.
    if jhandtotal > 21: #If John's points exceed 21, check to see if he busts.
        if Ace > 0:
            $Ace -= 1 #If John has at least one 11 scoring ace, change it to a 1 and continue playing.
            $jhandtotal -= 10
        else: #Otherwise, you'll bust.
            show patty a_3
            patty "Fate has it out for you, for you have busted."
            show patty a_0
            if x.name == "allison": #If you're Allison, you win if your opponent also busts. So, they will begin their turn as usual.
                jump aitaketurn
            jump losehand
    if yourturn:
        show patty a_2 #This dialogue plays to let the player know what's going on.
        patty "Your card is a [card], bringing your total to [jhandtotal]. Was that your desire?"
        show patty a_0
    $cardcount += 1 #The count of your cards is increased. Used for various other parts of the code.
    return

label cdeal:
    if len (deck) == 0: #If opponent runs out of cards, creates a new deck of cards.
        call newdeck
    $card = deck[0]
    if x.name == "phila" and cardcount == 1: #This only triggers for your opponent's second card if you are Phila.
        $randomvalue = renpy.random.random()
        if randomvalue <= 0.5: #This ability triggers only half the time.
            $newcard = cardstring1 #Your opponent's second card will be set be equal to your first.
            if newcard != "King" and newcard != "Queen" and newcard != "Jack" and newcard != "Ace":
                $card = int(newcard)
            else:
                $card = newcard
    $deck.pop(0) #After the card is set, the first card in the deck list is removed.
    #play sound sfx_page_turn_2
    if ccardcount == 0: #These are the cards displayed in the form of individual screens.
        $ccardstring1 = str(card)
        show screen ccardone with moveintop
    elif ccardcount == 1:
        $ccardstring2 = str(card)
        show screen ccardtwo with moveintop
    elif ccardcount == 2:
        $ccardstring3 = str(card)
        show screen ccardthree with moveintop
    elif ccardcount == 3:
        $ccardstring4 = str(card)
        show screen ccardfour with moveintop
    elif ccardcount == 4:
        $ccardstring5 = str(card)
        show screen ccardfive with moveintop
    elif ccardcount == 5:
        $ccardstring6 = str(card)
        show screen ccardsix with moveintop
    elif ccardcount == 6:
        $ccardstring7 = str(card)
        show screen ccardseven with moveintop
    else: #Once again, the final card will be overwritten (only visually).
        show patty a_4
        patty "How unfortunate. Our playing space is limited. I'll just deal this on top of the previous card."
        show patty a_0
        $ccardstring7 = str(card)
        show screen ccardseven with moveintop
    if card == "Jack" or card == "Queen" or card == "King": #Card values are counted for AI just as they are you you.
        $chandtotal += 10
    elif card == "Ace":
        if chandtotal > 10:
            $chandtotal +=1
        else:
            $chandtotal += 11
            $cAce = cAce+1
    elif card == "Joker":
        if jokerplayed == False:
            call cJokertime #If opponent draws a Joker, this takes you to an alternate function that turns you into a detrimental form.
            jump cdeal #Jokers don't 'really' count, so opponent will deal themselves an additional card.
        else: #You will not transform if you recently transformed.
            show patty a_3
            patty "The cards have granted you a brief respite. Your body needs time to recuperate."
            show patty a_0
            jump cdeal
    else:
        $chandtotal += card
    if aiturn or (x.name == "izuna" and ccardcount>1): #Dialogue triggers when a scoring card is successfully dealt to the opponent.
        show patty a_2
        patty "My card is a [card], bringing my total to [chandtotal]."
        show patty a_0
    if x.name == "rita" and cardcount == 1: #After two cards are dealt, if you're Rita, the lower of the face-down cards is discarded.
        john "Time to pound some face-down cards!"
        if jhandtotal > chandtotal: #Case if your card is larger.
            $chandtotal = 0 #Opponent's 1st card score is set to 0 for AI purposes.
            show patty a_3
            patty "My first card has been wiped from existence."
            show patty a_0
            $ccardstring1 = "cardback" #The card is replaced with a cardback visual.
        if jhandtotal < chandtotal: #Case if your card is smaller.
            $jhandtotal = 0 #Your first card score is set to 0 for AI purposes.
            show patty a_3
            patty "Your first card has been wiped from existence."
            show patty a_0
            $cardstring1 = "cardback"
        if jhandtotal == chandtotal:
            if jhandtotal == 11:
                $Ace = 0 #In this case, Aces can be erased, so we must change the Ace variable to account.
                $cAce = 0
            $jhandtotal = 0 #Both face-down cards are equal, so Rita destroys both cards.
            $chandtotal = 0
            $ccardstring1 = "cardback"
            $cardstring1 = "cardback"
            show patty a_7
            patty "You destroyed both of them? Please show some restraint, lest the spirits of the cards retaliate in protest."
            $emoo = ("john", x.happy_em)
            $renpy.show (emoo)
            john "Sorry, I just really love punching things while I'm in this body..."
            $emoo = ("john", x.neutral_em)
            $renpy.show (emoo)
            show patty a_0
    if x.name == "izuna" and chandtotal >21 and cAce > 0: #This handles ace functionality while Izuna's 'Duel' is active.
        $chandtotal -= 10
        $cAce -= 1
    if x.name == "mel" and chandtotal > 21 and cAce == 0 and ccardcount == 1: #While you're Mel, it's possible for the opponent to bust on the opening hand.
        show patty a_4
        patty "Hmm, it appears I busted."
        show patty a_0
        jump winhand
    $ccardcount += 1 #The opponent's card count is increased by 1 for various purposes.
    return

label newdeck: #The new deck function.
    $deck = starterdeck.copy() #Once again, we use a copy of the initial deck.
    $renpy.random.shuffle(deck) #The copy is then shuffled.
    show patty a_5
    patty "It appears we're out of cards. This will not do! I'll form a new deck to deal from."
    show patty a_0
    return

label Jokertime: #The function called for Joker transformations.
    show patty a_3
    patty "Hark! The Joker's magic alters your form!"
    show patty a_0
    $roll1 = renpy.random.random() #Rolls are used for both character selection and nudity.
    $roll2 = renpy.random.random()
    if persistent.nudity == False and roll2 > 0.94: #Rolls above .94 indicate a nude outfit. So, we change those rolls to 0.94 exactly if nudity is disabled.
            $roll2 = 0.94
    if x.name == "sayaka": #Sayaka's special ability allows you to skip being transformed.
        show patty a_7
        patty "It seems your body wants to stay as Sayaka. Is that okay?"
        menu:
            "Try to change.":
                show patty a_3
                patty "Okay. Let's try this once more. Witness the card's power!"
                show patty a_0
            "Stay as Sayaka.": #If you stay as Sayaka for too long, you have the option of triggering an ending.
                if sayakameter == 4:
                    patty "Are you quite certain? You've been in that form for a while. Something bad could happen."
                    menu:
                        "Try to change.":
                            show patty a_3
                            patty "Okay. Let's try this once more. Witness the card's power!"
                            show patty a_0
                        "Stay as Sayaka.":
                            jump fullsayaka #Jump to the ending.
                else:
                    show patty a_0
                    show patty a_4
                    patty "So be it. Hopefully this doesn't anger the spirits..."
                    show patty a_0
                    $sayakameter += 1 #Stay as Sayaka, but the 'sayakameter' variable increases, which can cause an ending later.
                    return
    if x.name != "charlotte": #This triggers if you aren't Charlotte.
        $newx = renpy.random.choice (boon_index)
        if newx.name == "sayaka" and roll1 < 0.85: #If you roll Sayaka, there's an 85% chance you will reroll unless you're currently Carlotte.
            $newx = renpy.random.choice (boon_index) #Your new body is selected from the list of beneficial ones.
        while newx.name == x.name:
            $newx = renpy.random.choice (boon_index) #If your new body is the same as your old one, reroll.
        $x = newx #This is the BlackJackBody variable used for transformations.
    else: #If you're Charlotte, you get a powered-up improved transformation routine.
        $x3 = renpy.random.sample(boon_index,3) #A sample of 3 random bodies is taken.
        while x in x3:
            $x3 = renpy.random.sample(boon_index,3)
        "Charlotte's shopping sense lets you choose your next body!"
        $roll2 = renpy.random.uniform(0.55,1) #Your 2nd roll is increased, making it more likely you will find a rare outfit or nude form.
        if persistent.nudity == False and roll2 > 0.94: #Nudity is still checked.
            $roll2 = 0.94
        menu:
            "Choose your next body."
            "[x3[0].name.capitalize()]": #You select a body from the random sample. The choices are taken directly from that sample for the option choices.
                $x = x3[0] #The BlackJackBody variable is then set to the corresponding body.
            "[x3[1].name.capitalize()]":
                $x = x3[1]
            "[x3[2].name.capitalize()]":
                $x = x3[2]
    if roll2 < 0.55: #You have a 55% chance of rolling the default outfit.
        $youroutfit = x.joutfit
    elif roll2 < 0.82: #You have a 27% chance of getting the first alternate outfit.
        $youroutfit = x.outfit_tf1
    elif roll2 <= 0.94: #You have a 12% chance of getting the 2nd alternate outfit.
        $youroutfit = x.outfit_tf2
    else: #If nudity is enabled, your body will be nude 6% of the time.
        $youroutfit = x.outfit_tf3
    $ o = ("begin", "magic", "john", x.name, youroutfit, (x.em,), 1, None) #This tuple is used with execute_morph to change John's form.
    if o not in persistent.bodylist: #A record is made of your new body if it's new.
        $persistent.bodylist.append(o)
    play sound sfx_spell
    if x.name in transformationlist: #Records are also added for the blackjackstats variable.
        if x.name not in [i[0] for i in persistent.bjs]:
            $persistent.bjs.append([x.name,1,0,0,0,0,[youroutfit]]) #A new row is made for the character if necessary.
        else:
            python:
                for i in persistent.bjs:
                    if i[0] == x.name:
                        i[1] += 1 #Increase the appearance count of the character by 1.
                        if youroutfit not in i [6]:
                            i[6].append(youroutfit) #The outfit is added to the character's list of outfits if it isn't there yet.
        #"[persistent.bjs]" This displays black jack stats for testing purposes, but is commented out.
    $ execute_morph (o) #This is the transformation code.
    morph do john
    morph finish john
    john "Mmm, this could be advantageous."
    $emoo = ("john", x.neutral_em)
    if x.name == "sadie": #mp is initialized so that the character's ability works properly.
        $mp = 2
    else:
        $mp = 1
    $renpy.show (emoo)
    $jokerplayed = True #A joker card is now marked as played and the cooldown hand timer is reset.
    $cooldown = 0
    return

label cJokertime: #This is mostly identical to the player Joker function, except we use the detrimental bodies list.
    show patty a_3
    patty "Hark! The Joker's magic changes your form!"
    if x.name == "sayaka":
        show patty a_7
        patty "Huh, it seems your body wants to stay as Sayaka. Is that alright?"
        menu:
            "Try to change.":
                show patty a_3
                patty "Okay. Let's try this once more. Witness the card's power!"
                show patty a_0
            "Stay as Sayaka.":
                if sayakameter == 4:
                    patty "Are you quite certain? You've been in that form for a while. Something bad could happen."
                    menu:
                        "Try to change.":
                            show patty a_3
                            patty "Okay. Let's try this once more. Witness the card's power!"
                            show patty a_0
                        "Stay as Sayaka.":
                            jump fullsayaka
                else:
                    show patty a_4
                    patty "So be it. Hopefully this doesn't anger the spirits..."
                    show patty a_0
                    $sayakameter += 1
                    return
    if x.name != "charlotte":
        $newx = renpy.random.choice (bane_index)
        while newx.name == x.name:
            $newx = renpy.random.choice (bane_index)
        $x = newx
        $roll2 = renpy.random.random()
        if persistent.nudity == False and roll2 > 0.94:
            $roll2 = 0.94
    else:
        $x3 = renpy.random.sample(bane_index,3)
        while x in x3:
            $x3 = renpy.random.sample(bane_index,3)
        "Charlotte's shopping sense lets you choose your next body!"
        $roll2 = renpy.random.uniform(0.55,1)
        if persistent.nudity == False and roll2 > 0.94:
            $roll2 = 0.94
        menu:
            "Choose your next body."
            "[x3[0].name.capitalize()]":
                $x = x3[0]
            "[x3[1].name.capitalize()]":
                $x = x3[1]
            "[x3[2].name.capitalize()]":
                $x = x3[2]
    if roll2 < 0.55:
        $youroutfit = x.joutfit
    elif roll2 < 0.82:
        $youroutfit = x.outfit_tf1
    elif roll2 <= 0.94:
        $youroutfit = x.outfit_tf2
    else:
        $youroutfit = x.outfit_tf3
    $ o = ("begin", "magic", "john", x.name, youroutfit, (x.em,), 1, None)
    if o not in persistent.bodylist:
        $persistent.bodylist.append(o)
    if x.name in transformationlist:
        if x.name not in [i[0] for i in persistent.bjs]:
            $persistent.bjs.append([x.name,1,0,0,0,0,[youroutfit]])
        else:
            python:
                for i in persistent.bjs:
                    if i[0] == x.name:
                        i[1] += 1
                        if youroutfit not in i [6]:
                            i[6].append(youroutfit)
        #"[persistent.bjs]"
    play sound sfx_spell
    $ execute_morph (o)
    morph do john
    morph finish john
    john "Ugh, I have a bad feeling about this."
    $emoo = ("john", x.neutral_em)
    $renpy.show (emoo)
    $jokerplayed = True
    $cooldown = 0
    return

label bj2goodend: #The function called when a good ending is played.
    hide screen cardone #All card images are hidden.
    hide screen cardtwo
    hide screen cardthree
    hide screen cardfour
    hide screen cardfive
    hide screen cardsix
    hide screen cardseven
    hide screen ccardone
    hide screen ccardtwo
    hide screen ccardthree
    hide screen ccardfour
    hide screen ccardfive
    hide screen ccardsix
    hide screen ccardseven
    hide screen gamestatus
    stop music
    if patty.name!= "Circe" and tarot != "lolz": #This dialogue only plays under certain routes.
        show patty a_2
        patty "That marks the end of the game. It's time to revisit our Tarot card."
        show patty a_0
    if x.name == "john" and tarot != "lolz": #An alternate ending will trigger if John wins while in his original body.
        menu:
            think "Hmm, I'm still in my original body. Should I make a break for it before Patty does something weird??"
            "Nah.":
                $emoo = ("john", x.sad_em)
                $renpy.show (emoo)
                think "Probably a good idea. Who knows what someone with that kind of power could do if I broke the game's rules?"
            "Yes.":
                $emoo = ("john", x.happy_em)
                $renpy.show (emoo)
                think "Alright, off I go. I don't think she could catch up to me in a full sprint."
                jump johncheat #Jump to the bad ending.
    $johnwins = True #John is marked as a winner for later checks.
    play music bgm_bgm_maoudamashii_acoustic50
    if tarot == "thestar":
        if ["thestar", "The Star: Girl's Got Game"] not in persistent.goodend: #If the ending has not been recorded yet, add it to the good ending list.
            $persistent.goodend.append(["thestar", "The Star: Girl's Got Game"])
        jump thestarend #The ending dialogue is jumped to directly for each one.
    if tarot == "temperance":
        if ["temperance", "Temperance: In the Name of Bread"] not in persistent.goodend:
            $persistent.goodend.append(["temperance", "Temperance: In the Name of Bread"])
        jump temperanceend
    if tarot == "thetower":
        if ["thetower", "The Tower: John Has a Growth Spurt"] not in persistent.goodend:
            $persistent.goodend.append(["thetower", "The Tower: John Has a Growth Spurt"])
        jump thetowerend
    if tarot == "thefool":
        if ["thefool", "The Fool: John Lives in the Moment"] not in persistent.goodend:
            $persistent.goodend.append(["thefool", "The Fool: John Lives in the Moment"])
        jump thefoolend
    if tarot == "thehighpriestess":
        if ["thehighpriestess", "The High Priestess: John Lays Down the Law"] not in persistent.goodend:
            $persistent.goodend.append(["thehighpriestess", "The High Priestess: John Lays Down the Law"])
        jump thehighpriestessend
    if tarot == "thelovers":
        if ["thelovers", "The Lovers: John Practices Self-Love"] not in persistent.goodend:
            $persistent.goodend.append(["thelovers", "The Lovers: John Practices Self-Love"])
        jump theloversend
    if tarot == "judgement":
        if ["judgement", "Judgement: John Gets In Touch With His Feminine Side"] not in persistent.goodend:
            $persistent.goodend.append(["judgement", "Judgement: John Gets In Touch With His Feminine Side"])
        jump judgementend
    if tarot == "thesun":
        if ["thesun", "The Sun: John Tries On a New Accent"] not in persistent.goodend:
            $persistent.goodend.append(["thesun", "The Sun: John Tries On a New Accent"])
        jump thesunend
    if tarot == "strength":
        if ["strength", "Strength: John Goes for Gold"] not in persistent.goodend:
            $persistent.goodend.append(["strength", "Strength: John Goes for Gold"])
        jump strengthend
    if tarot == "wheeloffortune":
        if ["wheeloffortune", "Wheel of Fortune: John Strikes It Rich"] not in persistent.goodend:
            $persistent.goodend.append(["wheeloffortune", "Wheel of Fortune: John Strikes It Rich"])
        jump wheeloffortuneend
    if tarot == "theempress":
        if ["theempress", "The Empress With Two Left Feet"] not in persistent.goodend:
            $persistent.goodend.append(["theempress", "The Empress With Two Left Feet"])
        jump theempressend
    if tarot == "theworld":
        if ["theworld", "The World: John Finds the Plot"] not in persistent.goodend:
            $persistent.goodend.append(["theworld", "The World: John Finds the Plot"])
        jump theworldend
    if tarot == "thedevil":
        if ["thedevil", "John Deals With the Devil"] not in persistent.goodend:
            $persistent.goodend.append(["thedevil", "John Deals With the Devil"])
        jump thedevilend
    if tarot == "themagician" :
        if "kiyoshiwins" not in persistent.specialend:
            $persistent.specialend.append("kiyoshiwins") #These endings are stored under the special endings.
        jump kiyoshiend
    if tarot == "lolz" :
        if "impossible" not in persistent.specialend:
            $persistent.specialend.append("impossible")
        jump lolzend
    if tarot == "emperor":
        if "popular" not in persistent.specialend:
            $persistent.specialend.append("popular")
        jump emperorend
    show patty a_2 #These is a generic ending that was used for testing purposes. It can no longer be accessed in-game...I think.
    patty "Congratulations. You emerge triumphant. The deck's spirit grants you its bounty."
    play sound sfx_spell
    morph begin magic john john uniform a_0
    morph do john
    morph finish john
    john "Ayy! I'm back to normal!"
    jump newgameprompt

label bj2badend: #This is the bad ending function. It's pretty much identical to the good ending one, with the changes you'd expect.
    hide screen cardone
    hide screen cardtwo
    hide screen cardthree
    hide screen cardfour
    hide screen cardfive
    hide screen cardsix
    hide screen cardseven
    hide screen ccardone
    hide screen ccardtwo
    hide screen ccardthree
    hide screen ccardfour
    hide screen ccardfive
    hide screen ccardsix
    hide screen ccardseven
    hide screen gamestatus
    $johnwins = False
    stop music
    if patty.name != "Circe" and tarot != "lolz":
        show patty a_4
        patty "That marks the end of the game. It's time to revisit our Tarot card."
    play music bgm_waltz_tschikovsky_op_40
    if tarot == "thestar":
        if ["thestar", "The Star: Mean Girls"] not in persistent.badend: #Bad endings are added to the bad ending list.
            $persistent.badend.append(["thestar", "The Star: Mean Girls"])
        jump thestarend #They are also jumped to directly.
    if tarot == "temperance":
        if ["temperance", "Temperance: John Repeats Himself"] not in persistent.badend:
            $persistent.badend.append(["temperance", "Temperance: John Repeats Himself"])
        jump temperanceend
    if tarot == "thetower":
        if ["thetower", "The Tower: John Thinks Small"] not in persistent.badend:
            $persistent.badend.append(["thetower", "The Tower: John Thinks Small"])
        jump thetowerend
    if tarot == "thefool":
        if ["thefool", "The Fool: John Loses Himself"] not in persistent.badend:
            $persistent.badend.append(["thefool", "The Fool: John Loses Himself"])
        jump thefoolend
    if tarot == "thehighpriestess":
        if ["thehighpriestess", "The High Priestess: Anger Management"] not in persistent.badend:
            $persistent.badend.append(["thehighpriestess", "The High Priestess: Anger Management"])
        jump thehighpriestessend
    if tarot == "thelovers":
        if ["thelovers", "The Lovers: John Finds His Soulmate"] not in persistent.badend:
            $persistent.badend.append(["thelovers", "The Lovers: John Finds His Soulmate"])
        jump theloversend
    if tarot == "judgement":
        if ["judgement", "Judgement: A Whole New World"] not in persistent.badend:
            $persistent.badend.append(["judgement", "Judgement: A Whole New World"])
        jump judgementend
    if tarot == "thesun":
        if ["thesun", "The Sun: Yandere Stimulator"] not in persistent.badend:
            $persistent.badend.append(["thesun", "The Sun: Yandere Stimulator"])
        jump thesunend
    if tarot == "strength":
        if ["strength", "Strength: John Calls in Sick"] not in persistent.badend:
            $persistent.badend.append(["strength", "Strength: John Calls in Sick"])
        jump strengthend
    if tarot == "wheeloffortune":
        if ["wheeloffortune", "Wheel of Fortune: John's Luck Betrays Him"] not in persistent.badend:
            $persistent.badend.append(["wheeloffortune", "Wheel of Fortune: John's Luck Betrays Him"])
        jump wheeloffortuneend
    if tarot == "theempress":
        if ["theempress", "The Empress: John Fades Into Obscurity"] not in persistent.badend:
            $persistent.badend.append(["theempress", "The Empress: John Fades Into Obscurity"])
        jump theempressend
    if tarot == "theworld":
        if ["theworld", "The World: John Changes His Life"] not in persistent.badend:
            $persistent.badend.append(["theworld", "The World: John Changes His Life"])
        jump theworldend
    if tarot == "thedevil":
        if ["thedevil", "The Devil: Guilty Conscience"] not in persistent.badend:
            $persistent.badend.append(["thedevil", "The Devil: Guilty Conscience"])
        jump thedevilend
    if tarot == "themagician" :
        if "kiyoshiloses" not in persistent.specialend: #Bad endings are stored under the special endings.
            $persistent.specialend.append("kiyoshiloses")
        jump kiyoshiend
    if tarot == "lolz" :
        if "possible" not in persistent.specialend:
            $persistent.specialend.append("possible")
        jump lolzend
    if tarot == "emperor":
        if "popular?" not in persistent.specialend:
            $persistent.specialend.append("popular?")
        jump emperorend
    show patty a_4
    patty "How unfortunate, the cards betray you. They gleefully sabotage your fate." #This is a placeholder ending not currently used in-game...afaik.
    $x = random.choice (boon_index+bane_index) #A random body is selected for John, then he transforms into it.
    $ o = ("begin", "magic", "john", x.name, x.joutfit, (x.em,), 1, None)
    play sound sfx_spell
    $ execute_morph (o)
    morph do john
    morph finish john
    john "...great. Maybe I ought to quit playing Blackjack..."
    jump newgameprompt

screen gamestatus(): #This screen takes care of all of the relevant game values. These are variables displayed as plain text with outlines added.
    text "$[jmoney]" size 40 xpos 0.05 yalign 0.3 outlines [(absolute(4), "#000", absolute(0), absolute(0))]
    text "$[cmoney]" size 40 xpos 0.85 yalign 0.3 outlines [(absolute(4), "#000", absolute(0), absolute(0))]
    text "Stake: $[stake]" size 40 xalign 0.5 outlines [(absolute(4), "#000", absolute(0), absolute(0))]
    text "Payout: $[stake*2]" size 40 xalign 0.5 yalign 0.07 outlines [(absolute(4), "#000", absolute(0), absolute(0))]
    if aiturn or (x.name != "michelle" or cardcount > 2): #If you're Michelle, you can't initially know what your face-down card is.
        text "Total: [jhandtotal]" size 40 yalign 0.4 xpos 0.05 outlines [(absolute(4), "#000", absolute(0), absolute(0))]
    if jokerplayed: #The cooldown value is shown if you've recently been transformed.
        text "Cooldown: [2-cooldown]" size 40 xpos 0.05 yalign 0.5 outlines [(absolute(4), "#000", absolute(0), absolute(0))]
    if aiturn or x.name == "patty": #If you're Patty, you can see your opponent's hand total.
        text "Total: [chandtotal]" size 40 xpos 0.85 yalign 0.4 outlines [(absolute(4), "#000", absolute(0), absolute(0))]

screen cardone():
    if aiturn == False and x.name == "michelle" and cardcount < 3: #If you're Michelle, you initially cannot see your first card.
       add "bj2db_asset cardback" xalign 0.05 yalign 0.05
    else:
        add "bj2db_asset [cardstring1]" xalign 0.05 yalign 0.05 #This screen will read the value of the current card and display the corresponding image from this scenario's asset folder.
screen cardtwo():
    add "bj2db_asset [cardstring2]" xalign 0.07 yalign 0.05 #Each card is displayed slightly to the right so that their values are visible.
screen cardthree():
    add "bj2db_asset [cardstring3]" xalign 0.09 yalign 0.05
screen cardfour():
    add "bj2db_asset [cardstring4]" xalign 0.11 yalign 0.05
screen cardfive():
    add "bj2db_asset [cardstring5]" xalign 0.13 yalign 0.05
screen cardsix():
    add "bj2db_asset [cardstring6]" xalign 0.15 yalign 0.05
screen cardseven():
    add "bj2db_asset [cardstring7]" xalign 0.17 yalign 0.05

screen ccardone():
    if aiturn == False and x.name != "patty":
       add "bj2db_asset cardback" xalign 0.95 yalign 0.05
    else:  #If you're Patty, your opponent's face-up card is visible.
        add "bj2db_asset [ccardstring1]" xalign 0.95 yalign 0.05
screen ccardtwo():
    if aiturn == False and x.name == "anuja": #If you're Anuja, you cannot see either of your opponent's cards while it's your turn.
        add "bj2db_asset cardback" xalign 0.93 yalign 0.05
    else:
        add "bj2db_asset [ccardstring2]" xalign 0.93 yalign 0.05
screen ccardthree():
    add "bj2db_asset [ccardstring3]" xalign 0.91 yalign 0.05
screen ccardfour():
    add "bj2db_asset [ccardstring4]" xalign 0.89 yalign 0.05
screen ccardfive():
    add "bj2db_asset [ccardstring5]" xalign 0.87 yalign 0.05
screen ccardsix():
    add "bj2db_asset [ccardstring6]" xalign 0.85 yalign 0.05
screen ccardseven():
    add "bj2db_asset [ccardstring7]" xalign 0.83 yalign 0.05

label thestarend:
    call tarotexplain
    patty "The Star represents hope and renewal."
    if johnwins: #The johnwins flag was set earlier to determine whether to play the good or bad ending for each tarot card route.
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "That sounds promising."
        patty "Yes, it is an escape from your current predicament."
        john "Finally, I'll be back to normal."
        show patty a_3
        patty "Whoa there, don't get ahead of yourself now. You didn't even really wager anything."
        $emoo = ("john", x.suprise_em)
        $renpy.show (emoo)
        john "Huh? What in the world did I even win if it's not my body or cash?"
        show patty a_5
        patty "This."
        morph begin magic john katrina casual a_0
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_3
        john "Oh, I'm Katrina's twin now? Better her than Cornelia."
        show patty a_10
        patty "No. You ARE Katrina now. Well, minus your memories as John. A fine fate, no?"
        show john a_4
        john "What? No. This is not what I wanted. Katrina's my friend. Maybe even more than that. I don't want to BE her."
        show john a_2
        john "I won, right? Can't I...have a choice?"
        show patty a_4
        patty "I'm sorry, John. My cards have spoken. Your fate is set. Enjoy your new life."
        hide patty
        play sound sfx_spell
        show john a_3
        john "Wait! Huh, she's gone. But how!?"
        show john a_7
        john "I guess it's no use thinking about it now. "
        show john a_5
        john "Time to make the best of this and play some Dank Souls."
        scene bg house_morgan bedroom_katrina day_computer with fade
        show john a_1 at center, faceleft
        "END - The Star: Girl's Got Game"
    if johnwins == False:
        $emoo = ("john", x.sad_em)
        $renpy.show (emoo)
        john "That's sounds nice and all. If I had won."
        show patty a_5
        patty "Don't get too down on yourself. This was a light wager. That means a light punishment."
        john "Punishment? I didn't think this was that kind of establishment."
        patty "Not exactly. Observe."
        show patty a_3
        morph begin magic john kyoko casual a_0
        play sound sfx_spell
        morph do john
        accessory john set glasses
        morph finish john
        show john a_14
        john "Huh? Now I look just like Kyoko. Better her than Cornelia."
        patty "Not just that. You ARE Kyoko. Effective now, you'll be guiding her through life."
        show john a_15
        john "Wait, what? What about Kyoko? What about my life, for that matter?"
        show patty a_4
        patty "I'm afraid answering those questions will only invite more."
        show patty a_10
        patty "Until then, enjoy your new friendly visage. I have a feeling you would have preferred Katrina, but Kyoko is a nice girl as well."
        show john a_10
        john "I mean, considering I just had to be Cornelia's twin, at least this doesn't feel like much of a punishment."
        show patty a_3
        patty "Alas, John. The punishment will not be under the card's hands, but Sayaka's. But fret not, you and your friends will guide you through."
        show john a_4
        john "Oh. I see."
        show patty a_0
        patty "That's all, John. The cards have spoken. Enjoy your new life."
        hide patty
        play sound sfx_spell
        show john a_14
        think "She's gone. Hopefully Sayaka and Cornelia are too."
        show john a_4
        think "From now on, I better start avoiding them. I heard their bullying could be cruel."
        show john a_5
        think "I hope I'll be okay. It doesn't sound fun living with a target constantly on my back."
        scene bg school stairwell_1 day with fade
        outfit john uniform
        show john a_5 at center
        show sayaka a_1 at centerleft
        show cornelia a_13 at centerright
        "END - The Star Loss: Mean Girls"
    jump newgameprompt

label temperanceend:
    patty "Temperance. Naturally, it's a symbol of balance and moderation."
    john "Basically the opposite of playing a game like this."
    show patty a_5
    patty "Indeed. Though, a small wager can sometimes be the wise move. There is less to gain, but also so much less to lose."
    if johnwins:
        john "So I'll win $50 now and get to play for my body back next time?"
        show patty a_6
        patty "You misunderstand. Allow me to demonstrate."
        morph begin magic john bradGB casual a_12
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_8
        john "Wait, what? This isn't what I wanted at all! And what about my cash?"
        show patty a_9
        patty "Your money is non-refundable. YOU are your prize."
        john "Excuse me? Who did you even turn me into?"
        show patty a_1
        patty "You are now Zoey and Brad's sister, Bread. Small wager. Small prize. Small girl."
        show john a_7
        john "What kind of name is Bread? Wait, who even IS Bread? Is that even a real person? Are you messing with me?"
        show patty a_2
        patty "That is all. Farewell, Bread. Enjoy your new life."
        hide patty
        play sound sfx_spell
        john "Oh, come on! You're leaving without answering any of my questions?"
        john "Some victory. My name is Bread now, seriously?"
        show john a_13
        john "Oh well, at least my new family should be much nicer than my old one. Goodbye and good riddance, Cornelia."
        scene bg house_bloom livingroom day with fade
        show john a_2 at center
        show brad a_0 at right
        show zoey a_1 at centerleft, faceright
        "END - Temperance Win: In the Name of Bread"
    if johnwins == False:
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "Yeah. $25 isn't a lot. I'm sure I can pony up some more and try another day."
        show patty a_6
        patty "You misunderstand. Allow me to demonstrate."
        morph begin magic john cornelia uniform_b a_7
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_4
        john "Oh, I see. So You just returned me to how I was before."
        show patty a_1
        patty "Correct. Small Wager. Small Loss. Small girl."
        show john a_3
        john "Are you mocking me? Do you realize how difficult just the past week has been?"
        show patty a_4
        patty "I'm sorry. I empathize. Believe me, I really do. However, Remember that it could always be far worse."
        show john a_8
        john "Really? How would you know?"
        show patty a_8
        patty "I'm sorry, I have already said too much already. May you try to find happiness as Cordelia."
        hide patty
        play sound sfx_spell
        think "Damn, already gone. I'm down $25 and a chance at my old life."
        show john a_22
        think "But maybe she's right. I wonder what terrible fate she was alluding to..."
        scene bg mall exterior day with fade
        outfit john uniform_b
        outfit cornelia casual
        outfit sayaka casual
        show john b_4 at centerleft
        show cornelia a_2 at center
        show sayaka a_1 at centerright
        "END - Temperance Loss: John Repeats Himself"
    jump newgameprompt

label thetowerend:
    patty "The Tower. It normally stands for a sudden change or upheaval."
    $emoo = ("john", x.happy_em)
    $renpy.show (emoo)
    john "That's great! I could stand to be just about anyone besides Cornelia right now."
    show patty a_2
    patty "Good. You'll get your wish."
    john "Yes!"
    show patty a_9
    patty "However, sometimes the meaning of tarot cards can be a bit more literal than figurative."
    $emoo = ("john", x.suprise_em)
    $renpy.show (emoo)
    john "Huh?"
    show patty a_3
    patty "Observe."
    if johnwins:
        morph begin magic john irene casual_b a_25
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_24
        john "Who in the world did you transform me into? And why?"
        show patty a_1
        patty "Isn't it obvious? You tower over everyone now, Irene."
        show john a_28
        john "Haha, very funny. Now what's my actual prize?"
        show patty a_9
        patty "This is it! You wagered your height, and look how much taller you are now thanks to your victory!"
        show john a_27
        john "Wonderful. So it's a Monkey's Paw scenario. Except I barely got to choose my wish."
        show patty a_10
        patty "It is however you perceive. The cards have decided your fate, and it is final."
        show john a_26
        john "Wait, you mean I'm stuck this way? I don't want Irene's height. Being tall is way cooler as a guy! I'll just feel awkward!"
        show patty a_2
        patty "Goodbye."
        hide patty
        play sound sfx_spell
        john "And she's gone."
        show john a_9
        john "I guess that's that. At least now I can ditch these two and see what Allison is up to."
        scene bg mall clothing_store with fade
        show john a_0 at center
        show allison a_0 at centerleft
        "END - The Tower Win: John Has a Growth Spurt"
    if johnwins == False:
        morph begin magic john zoey casual a_6
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_7
        john "Huh, what did you do?"
        show patty a_9
        patty "Well, we just did a little height wager. And you lost. So now you get to be cute little Zoey."
        show john a_5
        john "I see. Well, Kiyoshi won't be too happy about this."
        show patty a_2
        patty "Kiyoshi? Oh, he won't remember you."
        show patty a_10
        patty "After all, you're going to be the new Zoey."
        show john a_2
        john "Excuse me? I thought you just turned me into her twin."
        show patty a_4
        patty "About that. It's kinda complicated. You're Zoey now but you also have your memories as John. You'll figure it out."
        show john a_3
        john "What?! What about the real Zoey? What about my life as John?!"
        show patty a_1
        patty "Farewell, Zoey. Go easy on Kiyoshi, okay?"
        hide patty
        play sound sfx_spell
        show john a_4
        think "Well, geez. I'm still confused, but I'll try make the best of it."
        show john a_0
        think "...and I think I'm starting to crush on Kiyoshi already."
        show john a_1
        think "Sorry old friend, I won't be able to contain myself!"
        scene bg school cafeteria with fade
        outfit john uniform
        show john b_2 at center, faceleft
        show kiyoshi a_5 at centerleft
        "END - The Tower Loss: John Thinks Small"
    jump newgameprompt

label thefoolend:
    patty "The Fool. A symbol of innocence and new beginnings."
    $emoo = ("john", x.sad_em)
    $renpy.show (emoo)
    john "I really did pick the wrong card, didn't I?"
    show patty a_4
    patty "It depends. Sometimes a fresh perspective is exactly what you need after a difficult time."
    john "Care to elaborate?"
    show patty a_1
    patty "Gladly."
    if johnwins:
        morph begin magic john charlotte casual a_7
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_8
        john "Huh? What's going on?"
        show patty a_5
        patty "You've been transformed into Charlotte. She's a classmate of your sister."
        show john a_4
        john "Huh? But why? This isn't what I wanted to play for at all!"
        patty "The card choice manifests your subconscious desires."
        show patty a_2
        patty "Choosing the fool card doesn't make you dumb. It communicate a desire to forget your current trauma and start fresh."
        show john a_3
        john "Couldn't you have just turned me back into John and tweaked my memories? "
        john "This seems really excessive. I don't even know who Charlotte is!"
        show patty a_6
        patty "That's not how these cards work, John."
        show patty a_2
        patty "Charlotte's got it good. She has caring friends and has found her life's calling."
        show patty a_4
        patty "She's scatterbrained, though. I don't think you'll be able to remember you're John for more than a day or two."
        show patty a_5
        patty "That will be your fresh start."
        show john a_5
        john "This isn't right. No matter what kind of sick game this is, I don't want to steal someone's life. I don't want to lose mine!"
        show patty a_4
        patty "The cards disagree, John, and their Judgement is final. Farewell."
        hide patty
        play sound sfx_spell
        show john a_19
        john "Only 1-2 days left to remember my past life. Should I say goodbye? Will my friends and family even understand?"
        show naomi a_4 at centerright, faceleft
        naomi "Hey girl, you alright? You look like you're about to cry up a storm. You still wanna hit the boutique?"
        show john a_2
        john "Nao! Of course I do. I forgot what I was crying about anyway."
        show naomi a_1
        naomi "Haha, go figure. I sometimes envy your forgetfulness, Charlotte. Life's all about living in the moment!"
        show john a_1
        john "Maybe you're right."
        scene bg mall clothing_store with fade
        show john a_15 at center
        show naomi a_0 at centerright, faceleft
        "END - The Fool Win: John Lives in the Moment"
    if johnwins == False:
        morph begin magic john cornelia casual a_7
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_8
        john "What's going on? I thought I was going to get a new beginning, but I'm the same old Cordelia."
        show patty a_3
        patty "The cards have granted you a fresh start, but as CORNelia."
        show john a_4
        john "What do you mean? I already had her body, and I have it once again. That's old news."
        show patty a_5
        patty "You were Cornelia on the outside, yes. But not on the inside."
        show john a_7
        john "You don't mean...NO! You can't just wipe my mind! That's messed up!"
        show patty a_4
        patty "It is however you perceive. You will be granted your new beginning but not the one you wanted."
        patty "That is the cost of failure. It is a lesson we are both much aware of."
        show john a_11
        john "Wait, we?"
        show john a_22
        john "Nevermind that. Please, surely you can stop this! I'll do anything! You're the dealer! These are just some stupid magical cards!"
        show patty a_5
        patty "I'm sorry, John. The card's judgement is final. Enjoy your new life."
        hide patty
        play sound sfx_spell
        show john a_7
        john "Stop! No!!!"
        show sayaka a_18 at centerright
        sayaka "Hey little bitch. What's with the yelling? Didn't like your fortune?"
        show john a_17
        john "Huh, fortune? Is that what I was doing?"
        show sayaka a_19
        sayaka "Duh. Where's your head? I thought you were seeing a fortune teller, not a lobotamist."
        show john a_6
        john "Oh, right. Gawd, what a waste of money. Why would I waste my time with that nonsense, anyway?"
        show sayaka a_14
        sayaka "Beats me, nerd. Hope you saved some cash for shopping!"
        show john a_18
        think "Wonderful. Looks like I dropped 25 bucks on this bullshit."
        show john a_1
        think "Oh well, at least I feel normal again. That memory lapse was a fucking trip!"
        scene bg mall exterior day with fade
        show john a_13 at center
        show sayaka a_25 at centerright
        "END - The Fool Loss: John Loses Himself"
    jump newgameprompt

label thehighpriestessend:
    patty "The high priestess. As I've said, it radiates a feminine energy. However, it also symbolizes knowledge and wisdom."
    if johnwins:
        $emoo = ("john", x.sad_em)
        $renpy.show (emoo)
        john "Yeah, yeah. I get it. Just turn me into Yui already."
        show patty a_9
        patty "How presumptuous. There are plenty of other wise women in your circle. There's Michelle, Kyoko, and yes, even your mother."
        $emoo = ("john", x.suprise_em)
        $renpy.show (emoo)
        john "Hey now, you're not going there, are you?!"
        show patty a_1
        patty "Hmm, let's find out."
        morph begin magic john yui casual a_6
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_12
        john "Uh, yup, I'm Yui alright."
        show patty a_4
        patty "What's the matter? Don't you like Yui? She's smart, she's a leader, and she's got a wonderful sister and mother!"
        show patty a_1
        patty "In fact, I'm sure you have an affection for her."
        show john a_2
        john "Hey now, it's not that. She's so obsessive! She just needs to let us be sometimes."
        show patty a_0
        patty "I see."
        patty "Perhaps that part of personality gives her some measure of comfort. A slice of order in a chaotic world."
        show john a_3
        john "Whatever. Student council president or not, it's painful to see an old friend behave like that."
        show patty a_4
        patty "Perhaps you should go easy on her. You and Yui are now one and the same."
        show john a_12
        john "Huh? I mean, I only look like her, right? It's just like the game from before."
        show patty a_0
        patty "An understandable assumption."
        show patty a_3
        patty "No. You may remember being John, but besides that you're Yui through and through. Her traits you found annoying are now yours to bear."
        show john a_5
        john "Oh, I see. If that is the case, all I can do is try to be the best Yui I can be."
        show patty a_2
        patty "Your elevated wisdom shows already. It will not always make you friends, but may it guide you well nonetheless."
        patty "Farewell."
        hide patty
        play sound sfx_spell
        show john a_8
        think "Elevated wisdom, huh? Maybe being Yui won't be so bad."
        show john a_14
        think "She's even kind of cute. Maybe if I can take it easy as hall monitor I'll become pretty popular!"
        show john a_6
        think "Wait, is that man over there jaywalking?!"
        show john a_9
        think "This is unfair. How will I ever be able to take it easy with so many brazen rulebreakers out there?!"
        scene bg school hallway_1 day with fade
        outfit john uniform
        show john b_1 at right, faceleft
        show tori a_22 at center, faceright
        "END - The High Priestess Win: John Lays Down the Law"
    if johnwins == False:
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "Huh, so I guess you're gonna make me a cool dude who struggles with school? Honestly, being Eric wouldn't be worst."
        show patty a_5
        patty "A logical conclusion, but the cards have other ideas."
        morph begin magic john vanessa casual a_16
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_7
        john "Huh, who am I? I thought if you wanted to turn me into a girl with shitty grades, it would be Tori."
        show patty a_4
        patty "What? No. Tori isn't dumb. She has other things going on. You, however..."
        show john a_2
        john "Me?"
        show patty a_3
        patty "Yes, Ms. Hothead. Surely you know who you are now."
        show john a_14
        john "Oh, no."
        show patty a_5
        patty "Oh, yes. That temper didn't come out of nowhere. Vanessa is a frustrated girl."
        show patty a_4
        patty "She struggles with school. She struggles with relationships. I mean, she looks up to Tori. That's a red flag if I've ever seen one."
        show john a_2
        john "You would be the one to talk, you smartass fortune teller!"
        show john a_5
        john "Er, sorry. I didn't mean that."
        show patty a_0
        patty "No need to apologize. I understand what you're going through."
        show john a_7
        john "You do?"
        show patty a_4
        patty "Yes. After all, nobody takes a life upheaval lightly."
        show john a_18
        john "Okay, but what do I do? I feel so scared. I feel like I need to take this out on something. Or someone."
        patty "You just need channel that anger in a way the old Vanessa didn't."
        show patty a_6
        patty "And maybe find a tutor, too."
        show john a_1
        john "If you say so. This just all sounds like a pain-in-the-ass though."
        show patty a_4
        patty "Perhaps, but the cards have decided your fate, and it is final. Again, I wish you the best."
        hide patty
        play sound sfx_spell
        show john a_9
        john "Damnit. Even after her pep talk, I already feel pissed. Who knew Vanessa had it so hard?"
        show john a_18
        john "Even being Cornelia's twin might've been better than this."
        scene bg school rooftop day with fade
        show john b_3 at center
        show tori b_10 at centerright
        "END - High Priestess Loss: Anger Management"
    jump newgameprompt

label theloversend:
    patty "The lovers. Obviously, it represents love. However, it has other readings as well, with the ability to make choices and carve out
    your own path being one of them."
    if johnwins:
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "Ooh, I like the sound of that. So you're gonna make me into a bit of a Cassanova, huh?"
        show patty a_1
        patty "I suppose you could say that, in a sense. Witness my card's power."
        john "Gladly!"
        morph begin magic john sadie casual a_7
        play sound sfx_spell
        morph do john
        accessory john set hair_twintail
        morph finish john
        show john a_30
        john "Wait, what's happenin'? You turned me into another gal? I thought I was gonna be a lady's man!"
        show patty a_6
        patty "Your naivety shows. Romance goes both ways. Both men and women can be skilled in treading that path."
        show john a_20
        john "Gotcha. Well, judgin' just from my hair 'n' accent, I'm that Sadie gal. Is she some kinda guy magnet? We've never met."
        show patty a_10
        patty "Ah, yes. Sadie's a real flirt. She's got game. Plus, she's pretty and a cheerleader. I think she could get just about any guy she wants."
        show john a_24
        john "Mmm. That does sound appealin' and all when you put it like that."
        show patty a_9
        patty "However, I do think she has a thing for a particular boy. You."
        show john a_11
        john "That's a hoot. Well, seein' as I am John, datin' myself ain't happenin'."
        show patty a_3
        patty "Well, you WERE John. Now you're Sadie-Lynn Kobayashi. You've been replaced by a new John. The cards have their ways."
        show john a_6
        john "Excuuuse me? What kinda bizarro logic is that? I thought I was just Sadie's doppelganga. Now I'm replacin' her, and someone else is replacin' me?"
        show patty a_5
        patty "An apt summary, yes."
        show john a_26
        john "And now I'm gonna hook up with myself, huh?"
        show patty a_9
        patty "That is the likely outcome."
        show patty a_11
        patty "For what it's worth, an acquaintance relayed to me that it's quite the pleasant experience."
        show john a_17
        john "Fuh real? What kinda acquaintance are we talkin' about?"
        show patty a_2
        patty "Nevermind that. I must depart. The cards have delivered your fate, and it is final. Enjoy!"
        hide patty
        play sound sfx_spell
        show john a_27
        think "Hoo boy, what did ya just sign up for, John?"
        scene bg school entrance day with fade
        outfit john uniform
        show john a_3 at center
        show audrey a_13 at centerleft
        "END - The Lovers Win: John Practices Self-Love"
    if johnwins == False:
        $emoo = ("john", x.sad_em)
        $renpy.show (emoo)
        john "Great, so I'm gonna lose my love life AND free will?"
        show patty a_3
        patty "Fret not. You misunderstand what was at stake."
        show patty a_5
        patty "This shall provide clarity."
        morph begin magic john maria casual a_9
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_22
        john "Eh, I'm Maria, aren't I?"
        show john a_0
        john "She has a great love life, right? So much for losing!"
        show patty a_4
        patty "Your assumptions cloud your judgement. Your love life itself was not at stake."
        patty "Rather, it was your self determination. To choose your own mate."
        show john a_7
        john "Oh yeah, Maria and Eric are an item, huh?"
        john "I mean, can't I always just break up and choose someone else? I'm kinda one of the cool kids now, y'know."
        show patty a_9
        patty "You won't want to. The two are practically soulmates. Eric and his smokey lips are yours and yours alone."
        show john a_25
        john "Oh, gross. Is Maria into that? Am I into that now?"
        show patty a_1
        patty "I believe you know the answer to that. Goodbye."
        hide patty
        play sound sfx_spell
        show john a_6
        think "So this is the new me, huh? Can't say I ever envied Maria, but being her should be way better than Corn's twin."
        show john a_24
        think "Who knows? Maybe this will be kind of fun."
        show john a_1
        think "And hot."
        "END - The Lovers Loss: John Finds His Soulmate"
        scene bg school passage day with fade
        outfit john uniform
        show john a_1 at center, faceleft
        show eric a_11 at centerleft
    jump newgameprompt

label judgementend:
    if johnwins:
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "Finally. I knew I picked correctly. You'll fix everything, right?"
        show patty a_5
        patty "More or less. Judgment is a powerful card, particularly in this context. It will deliver you absolution. Arguably, a rebirth of sorts."
        john "That's cool and all. Let's just get me my old life back, alright?"
        show patty a_2
        patty "I shall."
        morph begin magic john johnGB casual a_12
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_22
        john "Hey, I thought I was getting my life back, but I'm just some random girl. What gives?!"
        show patty a_7
        patty "Interesting. This is most unexpected. You certainly got a rebirth, but is it truly absolution?"
        show john a_16
        john "I don't think so. I didn't just bet it all on Blackjack just to become some rando!"
        show john a_11
        john "...even if I do feel kinda cute."
        show patty a_10
        patty "The cards have their ways. On second thought, your life has been returned to you. Only, in an unexpected form."
        show john a_14
        john "Huh, so I'm some sort of girl version of me?"
        show patty a_2
        patty "Exactly. A desirable outcome, no? Your normal life has been bestowed upon you."
        show john a_10
        john "I'm not sure I believe that. How will my friends treat me? My family?"
        patty "Just like before. The events of your life are more or less equivalent with some gender-based adjustments. You'll see."
        show john a_9
        john "But what about my best bud, Kiyoshi? Can our friendship really last with my new body?"
        show patty a_5
        patty "Life overhauls have their consequences. The cards have delivered their judgement, and it is final. Enjoy your new life."
        hide patty
        play sound sfx_spell
        show john a_4
        think "Why aren't I happier about this? I get my old life back and a beautiful new bod to boot."
        show john a_0
        think "Oh no, I'm already having flashbacks of Kiyoshi coming at me in creep mode."
        show john a_17
        think "I might need to find a new best friend."
        scene bg school cafeteria with fade
        outfit john uniform
        show john a_11 at center
        show kiyoshi a_6 at centerleft, faceright
        show katrina b_1 at centerright, faceleft
        show kyoko b_4 at right, faceleft
        "END - Judgement Win: John Gets In Touch With His Feminine Side"
    if johnwins == False:
        patty "Judgement. It is a powerful card. Especially in this context, it can deliver absolution. It can even deliver rebirth."
        $emoo = ("john", x.sad_em)
        $renpy.show (emoo)
        john "..."
        patty "What's wrong? Aren't you the least bit curious about your fate?"
        john "I blew it. I had my shot, but now everything's going to be even worse."
        patty "These losses are very difficult. I understand. I would know better than anyone."
        john "What would you know? You're just some heartless witch toying with people's lives. I'm sure you're very proud of yourself."
        show patty a_8
        patty "You don't know the half of it."
        john "Whatever. Let's just get this over with."
        show patty a_5
        patty "As you wish."
        morph begin magic john anuja exotic a_20
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_7
        show patty a_4
        patty "Normalcy is what you desired, but unfortunately the cards have decided to grant you the opposite."
        show john a_16
        john "So, the cards think I'm a weirdo just because I look different? I had no idea that the cards were racist."
        show patty a_3
        patty "Race is merely a social construct, but it is one you'll have to bear nonetheless. You're no longer Mr. average white guy."
        show john a_11
        john "Fair enough."
        show patty a_5
        patty "Furthermore, you're an outsider now. You know that Anuja is a foreign exchange student, right?"
        show john a_7
        john "Wait, does that mean..."
        show patty a_4
        patty "It does. Soon you'll be thousands of miles away from your former friends and family. The world as you know it will be deprived from you."
        show john a_4
        john "No! That sounds unbearable!"
        show patty a_5
        patty "It will be difficult, but you will find your way. You'll have new friends. New family. Maybe you'll be able to find a way to stay connected with your old ones as well."
        show john a_20
        john "If you say so."
        show patty a_4
        patty "I'm sorry, John. I know this is difficult, but remember: it could have been worse."
        patty "Alas, the card's judgement has been delivered and is final. Hang in there, John."
        hide patty
        play sound sfx_spell
        show john a_14
        think "Could be worse, huh? Is that really true?"
        show john a_11
        think "At least Anuja seems like a decent person. Maybe Patty is right. Maybe this will be okay after all."
        scene bg hotsprings bath with fade
        outfit john swimsuit
        show john a_20 at right, faceleft
        "END - Judgement Loss: A Whole New World"
    jump newgameprompt

label thesunend:
    show patty a_5
    patty "Do you consider yourself happy, John?"
    $emoo = ("john", x.suprise_em)
    $renpy.show (emoo)
    john "Excuse me? What kind of question is that?"
    show patty a_3
    patty "A vital one."
    patty "My cards wield the power to bend souls, but they also illuminate them."
    show patty a_4
    patty "Your selection of The Sun speaks volumes. It demonstrates a certain longing: an existential hole that preceded even your current predicament."
    $emoo = ("john", x.sad_em)
    $renpy.show (emoo)
    john "Well, I'll have you know I was perfectly happy prior to a week ago!"
    show patty a_6
    patty "Hmph, denial won't solve your problems, but it matters not now. Behold my card's power!"
    if johnwins:
            morph begin magic john mel casual a_7
            play sound sfx_spell
            morph do john
            morph finish john
            show john a_6
            john "Wha? Who did ya turn me into?"
            show patty a_9
            patty "Hmm, if your accent doesn't give it away, your attitude will."
            show patty a_2
            patty "Aren't you feeling a little, mmm, spunky?"
            show john a_8
            john "Attitude? Accent? Whatcha talkin' about Patty?"
            show john a_9
            john "Eep, I sound jus' like Mel! Talk about embarrassin'."
            show patty a_10
            patty "Heheh, she is a bit of a goof, but isn't she just so lovable?"
            patty "I'd wager she's one of the happiest girls at your school. That positive energy rubs off on those around her."
            show john a_6
            john "Well ain't that nice? And what's that gotta do with me?"
            show patty a_5
            patty "Well, John. It's because that is you now."
            show john a_7
            john "Moi? What do ya mean?"
            show patty a_4
            patty "The cards sensed your unhappy existence and took pity on you."
            patty "So, now you're living life in Mel's place. How do you feel? Are you happy?"
            show john a_2
            john "Darn, tootin'! I feel like I could take on the world!"
            show john a_1
            john "Er, I mean, you betcha!"
            show john a_4
            john "Aww, c'mon, why can't I shake this accent? I'm feelin' ridiculous right 'bout now!"
            show patty a_2
            patty "Well, you are Mel now aside from your memories as John."
            show patty a_10
            patty "So, it's only natural you'll start picking up her mannerisms as well. I'm not sure she could change her accent, even if she wanted to."
            show john a_8
            john "I gotcha. I'm just kinda worried the other gals will be pickin' on me for it!"
            show patty a_2
            patty "I have a feeling that won't be a problem. Just focus on your feelings, not Cornelia's or Sayaka's. That's what Mel would do."
            show patty a_10
            patty "Anyway, I leave it at that. The cards have delivered their judgement, and it is final. May it serve you well!"
            hide patty
            play sound sfx_spell
            show john a_5
            think "Golly, this is so much to take in. What should I do? I don't know the first thing about being Mel."
            show john a_6
            think "What does Mel even do in her free time? Swim?"
            show john a_0
            think "Actually, that does sound mighty fun."
            show john a_1
            think "I gotta hop to it and find a pool! I feel like goin' a whole mile!"
            scene bg school pool day with fade
            outfit flavia swimsuit
            outfit john swimsuit_b
            show john b_2 at centerleft
            show flavia a_17 at center
            "END - The Sun Win: John Tries On a New Accent"
    if johnwins == False:
        morph begin magic john carrie casual a_22
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_6
        john "Oh. Oh, my. What's wrong with me? My heart is pounding."
        show patty a_4
        patty "Alas, you have wagered your happiness away."
        show patty a_5
        patty "Who might you know that is so excitable, yet so miserable?"
        show john a_10
        john "Excitable? Oh no, I might have an idea."
        show patty a_4
        patty "Indeed, Carrie has kind of typecasted herself as a yandere."
        patty "It's a bit of tragic, really. Her obsession with you is an outlet for her trauma and isolation."
        show john a_7
        john "Yes, I can feel that obsession already."
        show john a_5
        john "The fact that I used to be John and have all of his memories is too perfect."
        show patty a_6
        patty "Oh dear, I think I see where this is going. Just try not to break any laws regarding the new John, okay?"
        hide patty
        play sound sfx_spell
        show john a_21
        think "There's another John now, too?!"
        show john a_7
        think "Oh, yes, this really is too perfect. I can use his memories to my advantage."
        show john a_5
        think "This imposter won't know what hit him."
        scene bg house_davis exterior day with fade
        show john a_5 at center
        show audrey a_11 at centerleft

        "END - The Sun Loss: Yandere Stimulator"
    jump newgameprompt

label strengthend:
    show patty a_0
    patty "You didn't appear to be someone that cares about strength, John."
    $emoo = ("john", x.sad_em)
    $renpy.show (emoo)
    john "Just because I'm not jacked? Judgemental, much?"
    show patty a_6
    patty "It's an observation, not a criticism. You've always favored comfort over strength."
    show patty a_5
    patty "That applies to other aspects of your life, too. You value your free time."
    if johnwins:
        $emoo = ("john", x.neutral_em)
        $renpy.show (emoo)
        john "I see. So, this card is going to change that?"
        show patty a_3
        patty "In more ways than one. Observe my card's power."
        morph begin magic john flavia uniform a_27
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_25
        john "Whoa, what a trip."
        show john a_17
        john "If I am who I think I am, this might be a dream come true."
        show patty a_2
        patty "I told you you'd be happy with the result, right?"
        patty "Flavia is a very strong individual. Obviously, she has physical gifts, but she also has nerves of steel and lots of charisma."
        show john a_22
        john "I really am the perfect girl now, huh? Beats returning to my normie self."
        show patty a_4
        patty "Well, yes. You're quite a strong individual, but have you ever considered the price Flavia pays for that strength?"
        show john a_23
        john "I mean, obviously she has to practice a lot."
        patty "It's far more than that. She must eat a certain way, work out constantly, present herself correctly, and so on."
        show patty a_5
        patty "Flavia's life is practically a performance. She spends so much of her life improving or acting that she seldom has time to just relax and be herself."
        show patty a_9
        patty "It's almost the exact opposite of a certain someone's life."
        show john a_24
        john "Uh, that doesn't sound too great. Maybe I can get her to lighten up a bit."
        show patty a_10
        patty "I'm afraid that's just not how it works for Flavia."
        show patty a_5
        patty "You're to chase perfection just like she does."
        show john a_26
        john "Uh, can I get a redo? I think I'm good with just being me."
        patty "Alas, my hands are tied. Your fate has been delivered, and it is final."
        show patty a_10
        patty "Enjoy being the best, John. May it prove to be worth the effort."
        hide patty
        play sound sfx_spell
        show john a_27
        think "I thought Patty said I was going to like this. Being the best just sounds like a big pain! I just wanna live a normal, comfy life."
        show mel a_2 at centerright
        mel "Hiya Flavia, how you doin'? Did the fortune lady give ya some good news?"
        john "..."
        show mel a_3
        mel "Oh come on, I know that look on your face. You think you're John again, don't cha?"
        show john a_4
        john "To be honest, I used to be John just a few minutes ago, but what do you mean by 'again'?"
        show mel a_6
        think "This poor girl can't go two weeks without an existential crisis."
        show mel a_4
        mel "Alrighty, Flav, it's time for the ol' chat again..."
        scene bg school lockerroom with fade
        outfit john swimsuit
        outfit mel swimsuit_b
        show john a_10 at center
        show mel a_1 at centerright
        "END - Strength Win: John Goes for Gold"
    if johnwins == False:
        $emoo = ("john", x.suprise_em)
        $renpy.show (emoo)
        john "I lost, though. I don't suppose that means you'll return me to normal?"
        show patty a_4
        patty "No. I think it would be best to get this over with. Observe."
        morph begin magic john setsuna miko a_7
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_8
        john "Gah, I feel so weak. What did you do to me?!"
        show john a_4
        john "Oh, this Miko..."
        show john a_9
        john "So, you transformed me into Setsuna. It all makes sense now."
        show patty a_4
        patty "It's true. I have drained you of much of your physical strength. Her lingering illness entraps you."
        show patty a_5
        patty "However, not all is lost, for you have been blessed with an exceptional spiritual strength to guide you."
        show john a_6
        john "Is Setsuna's body magical or something?"
        show patty a_5
        patty "I'm afraid not, but her mastery of meditation and granted her insight and inner peace."
        show patty a_3
        patty "As the inheritor of her life, those gifts are now yours to possess."
        show john a_4
        john "Her LIFE? What about the real Setsuna? What about my life as John, for that matter?"
        show patty a_4
        patty "It will all make sense it due time. Sadly, you'll have ample time to reflect on that."
        patty "Alas, my card's judgement has been delivered, and it is final. May you make the best of your fate."
        hide patty
        play sound sfx_spell
        think "My new fate, huh? This feels like it should be the worst thing that's ever happened to me."
        show john a_5
        think "But somehow, it doesn't. Her ailment is mine to bear. As terrible as that is, I truly feel like it will be okay nonetheless."
        show john a_1
        think "I thank Setsuna's soul for her guidance. Whether she resides in me, my old body, or somewhere entirely different now, I will do my best to make her proud."
        scene bg shrine interior day with fade
        show john b_4 at center
        show audrey a_2 at right, faceleft
        "END - Strength Loss: John Calls in Sick"
    jump newgameprompt

label wheeloffortuneend:
    patty "The Wheel of Fortune. It represents the ups and downs of life."
    patty "After all, luck's bounties come and go as they please."
    if johnwins:
        show patty a_2
        patty "Considering the game's outcome, you might guess which path you'll be crossing today."
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "Alright, lay it on me!"
        show patty a_3
        patty "That I shall."
        morph begin magic john cassie casual a_16
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_3
        john "Oh my, I feel totally different, yet oddly familiar."
        john "Wait, I think I have a hunch at what you've done."
        show patty a_10
        patty "Fitting, no? Can you think of a luckier person in your little circle of acquaintances?"
        show john a_9
        john "I always thought Katrina was a lucky charm. Good things tend to happen when she's around."
        show patty a_9
        patty "Are you infatuated or just that naive?"
        show john a_2
        john "Don't be like that. I was just answering your question."
        show patty a_6
        patty "Figures I'd have to explain this to someone with such a comfy so-called middle class upbringing."
        show patty a_5
        patty "Cassie was born into a wealthy family. Regardless of the events of the rest of her life, this was by extraordinarily luck completely outside of her control."
        show john a_4
        john "Oh, obviously. I see your point."
        show john a_5
        john "Well, now I get a share in that. Lucky me, right?"
        show patty a_8
        patty "Share? I don't know how to say this John, but you ARE Cassie now. You're not going to be some adopted twin."
        show john a_16
        john "Wait, but what about her? I can't just steal all that from my sister's friend!"
        show patty a_4
        patty "It appears that you just have. Whether her spirit continues to reside in your new body or somewhere else entirely, her existence will never be the same."
        patty "Such is the nature of the Wheel of Fortune. Such is the fate of exorbitant wealth. Someone else will always be after it. There will always be a way to lose it all."
        show john a_2
        john "Am I...really gonna lose it all?"
        show patty a_5
        patty "I cannot answer that question. All I can say is my cards have delivered their judgement, and it is final."
        show patty a_9
        patty "Best enjoy your time at the top while you can."
        hide patty
        play sound sfx_spell
        think "Oh, geez. I thought I hit the jackpot, but what if someone steals my life just like I stole Cassie's?"
        think "Heck, what if another horrible thing happens? Maybe I should have just become myself again."
        show john a_8
        think "Oh well, I guess all I can do is enjoy life's excesses while I still can."
        show john a_9
        think "I think I'll buy every video game!"
        scene bg mall exterior day with fade
        show john a_1 at center
        show elizabeth a_3 at centerright, faceleft
        "END - The Wheel of Fortune Win"
    if johnwins == False:
        show patty a_4
        patty "Considering the game's outcome, you might guess which path you'll be crossing today."
        $emoo = ("john", x.sad_em)
        $renpy.show (emoo)
        john "Yeah. Might as well get this over with."
        show patty a_3
        patty "That I shall."
        morph begin magic john tori uniform b_4
        play sound sfx_spell
        morph do john
        morph finish john
        john "What?! I feel so...strong."
        show john b_12
        john "No, this uniform..."
        show patty a_5
        patty "Oh, yes."
        show john b_6
        john "What even is this? Tori isn't unlucky, she's just an angry asshole!"
        show john b_7
        john "Just being in her body is making my blood boil."
        show patty a_6
        patty "Hmm, yes. There's a lot to unpack here."
        show patty a_5
        patty "You aren't just in here body. You ARE Tori. You just retained your past memories. Otherwise, what would be the point?"
        show john b_14
        john "All over this stupid game of Blackjack? Are you fucking kidding me?!"
        show patty a_4
        patty "It is as you perceive. Your hand called on you to risk it all, but fate had it out for you this time."
        patty "Fitting you are just as luckless as Tori herself."
        show john b_5
        john "How is Tori so unlucky?"
        show patty a_5
        patty "You had such a fortunate upbringing as John. I guess it's understandable you would take it for granted."
        show patty a_3
        patty "Tori's home life has always been in shambles. It's obliterated her relationships and social skills."
        show patty a_4
        patty "It was only a matter of time before she went full-on delinquent."
        show john b_15
        john "Oh no. What will Tori do? What will I do? Am I just destined to by angry, alone, and hopeless forever?"
        patty "It is not for me to say, John. Just try to stick around Ms. Rachel. Perhaps she can guide you somehow."
        patty "Nonetheless, the card's judgement has been delivered and is final. Try your best to overcome your dark fortune, okay?"
        hide patty
        play sound sfx_spell
        show john b_7
        think "Rachel, huh? I thought all she did was chew Tori out, but the name does make me feel hopeful somehow."
        show john b_8
        think "Maybe I will make this work. Somehow."
        show john a_21
        think "Even if just the thought of having to pick up the pieces of Tori's life pisses me off."
        scene bg school hallway_2 day with fade
        show john b_12 at center
        show rachel a_9 at right, faceright
        "END - The Wheel of Fortune Loss: John's Luck Betrays Him"
    jump newgameprompt

label theempressend:
    patty "The Empress card. It's a symbol of nurturing and abundance."
    $emoo = ("john", x.suprise_em)
    $renpy.show (emoo)
    john "Really? I thought it was just a babe ruling with an iron fist."
    show patty a_6
    patty "Seriously? You know nothing about Tarot. Why do you think any of these would be taken literally?"
    $emoo = ("john", x.neutral_em)
    $renpy.show (emoo)
    john "It all seems arbitrary to me. I bet you would have said the exact opposite if I picked a different card."
    show patty a_8
    patty "No way! You're just making stuff up. You don't get it at all!"
    $emoo = ("john", x.happy_em)
    $renpy.show (emoo)
    john "Haha, I knew it! You're just a hack, aren't you?"
    show patty a_9
    patty "You're the one to laugh. You're forgetting who wields the ultra powerful deck."
    $emoo = ("john", x.sad_em)
    $renpy.show (emoo)
    think "Gulp."
    show patty a_11
    patty "That's what I thought. Witness my card's power!"
    if johnwins:
        morph begin magic john allison casual a_22
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_16
        john "My goodness! I'm definitely not Sayaka, huh?"
        show patty a_10
        patty "Indeed. Regardless of what you think of my Tarot skills, you understand your fate."
        show john a_10
        john "Haha, I would have never guessed Allison, though!"
        show patty a_5
        patty "It's true. Allison isn't your typical ruler. They're often charismatic and overbearing."
        show patty a_2
        patty "However, the Empress represents soft power. It's about the ability to nurture and bring out the best in other people."
        patty "As far as the popular kids go, Allison is unmatched. I'm not sure anyone could dislike her, even if they tried."
        show john a_9
        john "Cool! I always liked her more than the other popular girls, but I never understood why."
        show patty a_9
        patty "She's more popular than you could possibly imagine, but let's save the alternate universe talk for another day."
        show john a_7
        john "Please do. I already feel like I'm getting a headache."
        show john a_5
        john "Wait, I'm not...turning into her, am I?"
        show patty a_8
        patty "Well, maybe. You'll still have your memories as John, though. It's not like I'm just going to erase your existence."
        show john a_28
        john "That's so horrible. Not for me, but for her! What did she do to deserve that? She's practically an angel!"
        show patty a_4
        patty "Uh, I wasn't going to tell you this, but I can't stand to see Allison cry."
        show patty a_9
        patty "It's fun to pretend that the person you're replacing is just erased from existence entirely."
        show patty a_11
        patty "It makes the stakes feel all that more real!"
        show patty a_2
        patty "But we just whisk them away into an alternate timeline where everything is still normal."
        show patty a_4
        patty "Despite the dubious actions of our game, we still have a heart, in a way."
        show john a_16
        john "We? Who do you mean by we?"
        show patty a_8
        patty "Uh, me and my cards obviously! Who did you think?"
        show patty a_2
        patty "Speaking of, the cards have delivered their judgement, and it is final."
        patty "Enjoy Allison's life blessings. She's wealthy, pretty, and has a personality of gold. Use them to lift up those around you."
        show john a_15
        think "Wow, Allison really has an amazing life. Lifting up others? I hope I can do as good of a job as the original Allison."
        show patty a_9
        patty "Just be sure to watch your step. Bye now!"
        hide patty
        play sound sfx_spell
        show john a_22
        think "Watch my step? I wonder what she me-"
        show john a_7
        john "Eek! Don't fall, don't fall!"
        scene bg house_stein livingroom day with fade
        outfit irene casual
        show john a_9 at center
        show irene b_8 at centerright, faceleft
        "END - The Empress With Two Left Feet"
    if johnwins == False:
        morph begin magic john izuna uniform a_1
        play sound sfx_spell
        morph do john
        morph finish john
        john "Wow. I thought you would turn me into a weakling, but I feel so strong and determined. Who am I?"
        show patty a_9
        patty "Who are you? Indeed, that is the question."
        show john a_5
        john "I'd appreciate it if you took this a little more seriously. Someone just gambled their life away, y'know?"
        show john a_7
        john "Who. Am. I?"
        show patty a_4
        patty "Sorry, I couldn't resist. I'll show some more tact."
        show patty a_0
        patty "The reason I laughed was I turned you into Izuna Ito. She's tough but perhaps the least popular student at your school. She's practically invisible."
        show john a_3
        john "Oh, I see."
        show john a_4
        john "Why, though? I feel like kind of a badass. Being her can't be so bad."
        show patty a_4
        patty "It's...kind of hard to explain. People will see her and forget she exists the very next day. It's almost like a curse."
        show john a_2
        john "So, I'm cursed. Now I see how I lost. You made me into the loneliest girl in the world."
        show patty a_2
        patty "It's not all bad. Setsuna can remember her. It's a good arrangement. The two keep each other much needed company."
        show john a_8
        john "Okay, so if it's not all bad, how does she get through the school day?"
        show patty a_4
        patty "..."
        show john a_3
        john "..."
        patty "It is as you perceive. Make the best of your new life."
        show patty a_5
        patty "My cards have delivered their judgement, and it is final. Farewell."
        hide patty
        play sound sfx_spell
        show john a_5
        think "This sucks. I thought I somehow lucked into being a badass, but instead I'm doomed to be a loner."
        show john a_3
        think "Now that I'm Izuna, how should I cope with this fate?"
        show john a_4
        outfit john uniform_alt
        think "I think Setsuna's place calls. It's time for some target practice!"
        scene bg shrine exterior day with fade
        show john a_7 at centerleft
        show setsuna b_2 at right, faceleft
        "END - The Empress Loss: John Fades Into Obscurity"
    jump newgameprompt

label theworldend:
    if johnwins:
        show patty a_4
        patty "I...I lost. I lost again."
        $emoo = ("john", x.suprise_em)
        $renpy.show (emoo)
        john "What do you mean? Aren't you happy I won? That I finally get to be back to normal?"
        show patty a_3
        patty "My time is limited, John. You will get your reward, but listen up."
        show patty a_6
        patty "I am not really Patty."
        show patty a_5
        patty "My name was Faith. I happily worked at Tina Hoya. One evening, my life was nearly taken from me."
        show patty a_3
        patty "A girl supposedly named Patty miraculously appeared as I lay dying. She offered a healthy body if I could beat her at Blackjack."
        show patty a_6
        patty "After a grueling and close battle, I lost. Obviously."
        show patty a_5
        patty "Before I knew it, I was Patty, too. My body started acting on its own. I was being teleported to strange places."
        show patty a_4
        patty "That's when I realized this wasn't a miracle. This was a deal with a devil. Or, a demon more specifially."
        john "A demon?! I didn't even realize those were real!"
        show patty a_3
        patty "Shut up, John! There's no time!"
        patty "Play me again. Pick the Devil card. It's the only way."
        think "Alright, this was fun, but I can't have you spoiling any more fun. Away with you!"
        hide patty
        play sound sfx_spell
        think "What the hell was that? Play her again? How?!"
        think "I just want to be normal again, not get some exposition dump!"
        think "Oh yeah, I better fix this kid on the way out. Fair is fair."
        morph begin magic john john casual a_4
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_7
        think "Oh, hey. I'm back to normal. What the hell was that about?"
        show john a_5
        think "Wait, back to normal? Was I different a moment ago? I feel totally fine"
        show john a_9
        think "Well, except I'm blacking out trying to remember anything from the past week."
        show john a_4
        think "Hopefully I'm not coming off of a bad trip."
        show john a_0
        think "Ah well, time to head home and play some more Dank Souls."
        show john a_5
        think "Operation 'buy a new game' was a total bust. I'm...short on cash."
        "END - The World Win: John Finds the Plot"
        if optionsmenu == False and persistent.difficulty != "easy":
            scene bg city walkway day with fade
            play music bgm_aces_high fadein 1.5
            show kiyoshi a_0 at center
            kiyoshi "Huh, I thought John and I were gonna go game shopping. What's he doing in that oddly conspicuous alleyway?"
            show kiyoshi a_22
            kiyoshi "What? No. It can't be!"
            show kiyoshi a_12
            kiyoshi "Was he playing..."
            show kiyoshi a_6
            kiyoshi "Blackjack?"
            circe "Looks like Kiyoshi wants to play, too! Give him in a spin in the 'Challenges' option in the options menu!"
            $persistent.kiyoshi = True
    if johnwins == False:
        show patty a_7
        patty "I...I really did it. I won. I won!"
        $emoo = ("john", x.suprise_em)
        $renpy.show (emoo)
        john "You won? Hold the phone, I thought I was the one gambling here!"
        show patty a_5
        patty "I'm sorry, John. I haven't been straight with you."
        show patty a_4
        patty "While I sympathasize with your plight, my presence is hardly an act of altruism."
        if x.name != "john":
            $emoo = ("john", x.happy_em)
            $renpy.show (emoo)
            john "Well, no shit. Otherwise, I'd already have my original body."
            show patty a_5
            patty "Indeed. Like so."
            morph begin magic john john uniform a_4
            play sound sfx_spell
            morph do john
            morph finish john
            show john a_15
            john "Huh, I'm back to normal, but why?"
            show patty a_4
        else:
            $emoo = ("john", x.sad_em)
            $renpy.show (emoo)
            john "I'm not going to leave here as John, am I?"
        patty "..."
        #$swapping = ("None", "john", "patty", a_11, a_4, a_4, a_11)
        #$execute_swap(swapping)
        swap john a_11 : a_4, patty a_4: a_11 #This is the built-in Student Transfer swap animation. Add put in each character's name followed by their old and new expressions (tied to past/current body)
        patty "I'm sorry, John. It had to be this way."
        john "What? What is this? Why am I you? How could you?"
        show patty a_11
        patty "I'm sorry! It was the only way to be free! It's the only way I could have a life!"
        show patty a_2
        patty "I can't just be a crooked Blackjack dealer forever. It's time for someone else to take a turn!"
        show john a_7
        john "Wait, wait? Were you some sort of slave? Am I?!"
        show patty a_5
        patty "I'm sorry, John."
        show john a_4
        think "What's going on with her body?! I can't move or say anything on my own."
        show john a_6
        john "It is as you perceive. The cards have passed their judgement, and it is final."
        john "I shall bear the torch as Patty moving forward."
        john "So long, my master calls. Enjoy your new life, Faith."
        hide john
        play sound sfx_spell
        show patty a_11
        think "Poor John. He's just a kid! Was there really nothing I could do?"
        show patty a_9
        think "I'm not so sure. My control was so limited as Patty."
        show patty a_19
        think "All I can do is try and be the best John I can. There's no reason to make his friends and family suffer as well."
        scene black with fade
        show john a_4 at center
        show circe a_19 at centerleft
        "END - The World Loss: John Changes His Life"
    jump newgameprompt

label thedevilend:
    if johnwins:
        $emoo = ("john", x.neutral_em)
        $renpy.show (emoo)
        john "Alright. I won. It was tedious as hell, but I won."
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "So, now you have to do what I say!"
        show patty a_6
        patty "As much as I'd like to peace out, yes, that is my contractual obligation."
        patty "What do you want?"
        show patty a_1
        patty "Would you like a demon body like mine? Trust me, it's really cool to do all of these magic tricks!"
        $emoo = ("john", x.neutral_em)
        $renpy.show (emoo)
        john "Turn Patty back to normal."
        show patty a_8
        patty "What do you mean? It's not like she was actually a dying woman named Faith that I transformed and enslaved to do my bidding or anything."
        show patty a_4
        patty "Aww, nuts. I just spoiled the plot, didn't I?"
        $emoo = ("john", x.suprise_em)
        $renpy.show (emoo)
        john "Excuse me?! I thought you just made her feel sick and possessed her!"
        john "Yeah, you're going to fix all of that. Now."
        patty "Sigh. Fine..."
        hide patty
        if optionsmenu == False:
            exspirit circe a_27
            hide circeGhost
        outfit circe nude
        show circe a_27 at centerright, faceleft
        circe "Okay, I've dispossesed your stupid friend. I'll restore her body too."
        $emoo = ("john", x.neutral_em)
        $renpy.show (emoo)
        john "Alive."
        show circe a_8
        circe "Yeah, yeah. What kind of demon do you take me for?"
        $grace.name = "Faith"
        show grace a_10:
            xalign 0.5 ypos 1.3
            linear 2 ypos 0.13
        grace "Sorry, Circe. I zoned out. What must I do next?"
        show grace a_6
        grace "Wait, my voice, my body..."
        show grace a_12
        grace "Yes, I'm myself again! No more slaving around for me! Take that, Circe!"
        show circe a_21
        circe "Whatever. Anything else before I head out?"
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "It would only be fair if you changed me back, right?"
        show circe a_20
        circe "Yeah, I guess that would be simple enough. You earned it, right?"
        circe "Just hold still for a sec, got it?"
        john "You got it!"
        $x = random.choice (boon_index+bane_index) #A random body is selected.
        while x.name == "patty" or x.name == "bradGB" or x.name == "johnGB" or x.name == "cornelia" or x.name == "carrie": #For story purposes, certain bodies are re-rolled.
            $x = random.choice (boon_index+bane_index)
        $ o = ("begin", "magic", "john", x.name, x.joutfit, (x.em,), 1, None)
        play sound sfx_spell
        $ execute_morph (o)
        morph do john
        show circe a_19
        circe "Actually, I changed my mind. Fuck you, John!"
        morph finish john
        $emoo = ("john", x.suprise_em)
        $renpy.show (emoo)
        john "What?! I thought you had to do what I said!"
        show circe a_10
        circe "You get one wish. Ask for another and you get THAT instead."
        circe "Anyway, Circe's judgement has been delivered, and it is final. Congrats! Enjoy your new life! Buh-bye!"
        hide circe
        play sound sfx_spell
        show grace a_2 at center, faceleft
        grace "I'm sorry, John. It was your own selflessness that caused this."
        $emoo = ("john", x.neutral_em)
        $renpy.show (emoo)
        john "It's okay, Faith. If it was to stop someone else from being a demonic slave, I think it was worth it."
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "Besides, I think I might like having [x.name.capitalize()]'s body. Now that I'm experiencing it up close, I feel really attached to it."
        john "Do you think I could make out with her even if I pretend we're long lost twins?"
        show grace a_9
        grace "Well, Circe did tell me she found that kind of thing to be a very pleasant experience."
        show grace a_2
        grace "So, no. It would be an extremely messed up thing to ask."
        $emoo = ("john", x.neutral_em)
        $renpy.show (emoo)
        john "Oops, my bad."
        show grace a_12
        grace "Look, why don't I teach you a few things about being a woman?"
        grace "If you're gonna live like [x.name.capitalize()], you gotta learn to be like a woman, not a horny teenage boy."
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "In bed?"
        show grace a_10
        grace "Really, John?"
        think "Circe must have messed with his head."
        think "Looks like I'll have my work cut out for me..."
        scene bg school classroom_3 day with fade
        show john a_0 at center, faceright
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        show grace a_8 at centerright, faceleft
        "END - John Deals With the Devil"
    if johnwins == False:
        show patty a_11
        $emoo = ("john", x.sad_em)
        $renpy.show (emoo)
        john "..."
        patty "What's wrong, Johnny? Cat got your tongue?"
        john "I'm not interested in chatting with conniving demons. Do what you must."
        show patty a_9
        patty "Aww, is baby sad about my wittle chip advantage?"
        patty "I'm well aware of Ren'py's rewind and save features. If you ain't cheating you ain't trying."
        think "God, not only is this Circe character intolerable, she's also impossible to understand."
        show patty a_10
        patty "Ah, sorry about that. Breaking the 4th wall is pretty passe nowadays."
        show patty a_4
        patty "Honestly, John. I'm not too happy that you tried breaking up my little scheme to save the day."
        patty "What the hell's wrong with you? Do you hate fun?"
        show patty a_6
        patty "Bah, of course you do, Mr. Plain Davis."
        think "I'm not listening. I'm not listening..."
        show patty a_9
        patty "Alright, obviously your gamer brain attention span is getting bored, so let's get down to business."
        morph begin magic john circe nude a_26
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_27
        john "Gah! What did you do to me?"
        show patty a_2
        patty "I gave you a copy of my demonic body. Pretty sexy, huh?"
        show john a_1
        john "Sexy? What the hell's wrong with it?"
        show john a_26
        john "I feel sick!"
        show patty a_9
        patty "Oh, sorry. I made a few adjustments."
        patty "I merged your consciousness with my own."
        patty "So, now you feel like you did all of the fucked up things I did. Only, you actually still have your human empathy as John."
        show patty a_11
        patty "Isn't empathy a bitch? I guess if someone's going to take moral responsibility for my actions, it might as well be a so called 'protagonist'."
        show john a_21
        john "You...you're a monster."
        show patty a_9
        patty "Takes one to know one! Plus, I'm really horny, too. I think I'm going to cause some more chaos to satiate my appetite."
        show patty a_11
        patty "I have a feeling you will soon, too."
        show patty a_9
        patty "Anyway, sorry that you feel like a horrible monster and all. I'm sure you'll manage. Ciao!"
        hide patty
        hide circe
        play sound sfx_spell
        show john a_27
        think "Damnit! She's right, I'm a monster, too!"
        show john a_18
        think "Mel and Setsuna. Zoey and Yui. Audrey and Izuna. Body swaps. Life swaps. Possessions. Morphs."
        show john a_17
        think "These random people and scenarios are flooding my mind. They overwhelm me."
        think "I must act. To satiate my urges."
        show john a_27
        think "I'm sorry, world. It's not my fault. It really isn't. Please, tell me it's not my fault..."
        hide john
        play sound sfx_spell
        "Later..."
        outfit sandra suit
        outfit audrey uniform
        scene bg school classroom_1 with fade
        show sandra a_16 at center
        show audrey b_1 at centerright, faceleft
        show john a_26 at left
        "END - The Devil Loss: Guilty Conscience"
    jump newgameprompt

label lolzend:
    if johnwins:
        morph begin magic john rudy rudy a_0
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_0:
            xpos 0.25
        morph begin magic patty sayaka_frog base a_0
        play sound sfx_spell
        morph do patty
        morph finish patty
        show patty a_0 at right
        show john a_0:
            xpos 0.25
            linear 300 xpos 0.75 #Linear 300 means this animation will take 5 minutes to finish.
        "End."
        $ renpy.pause(300, hard=True) #The game will also hard pause for 5 minutes so that you can't skip the animation. Rude!
        "Why are you taking this so seriously?"
        "END - Raines no Chosenjou"
    if johnwins == False:
        $emoo = ("john", x.neutral_em)
        $renpy.show (emoo)
        john "Oh, would you look at that? The game's over, but you still have all of your chips left and then some."
        $emoo = ("john", x.happy_em)
        $renpy.show (emoo)
        john "No harm, no foul, right?"
        show patty a_6
        patty "Hmph, just for the mere thought, you deserve the harshest of punishments."
        show patty a_5
        patty "No, I'm gonna to send you to a terrible place where heinous, vile acts are mere commonplace."
        $emoo = ("john", x.suprise_em)
        $renpy.show (emoo)
        john "Hell?"
        show patty a_3
        patty "No, it's way worse than that."
        show patty a_11
        patty "I'm going to send you to the Press Switch universe."
        morph begin magic john bj2db_eliza uniform a_0
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_2
        show patty a_10
        john "Noooo!"
        show patty a_9
        patty "Oh yes."
        patty "Say hello to Calvin for me! Or, maybe don't. That kid's wack."
        show patty a_6
        patty "Anyway, don't bother coming back for another rematch unless you put in some effort."
        show patty a_2
        patty "Remember, if you ain't cheating, you ain't trying!"
        hide john
        play sound sfx_spell
        "END - A Fate Worse Than Identity Death"
    jump newgameprompt

label kiyoshiend:
    patty "The Magician. It symbolizes transformation. Furthermore, it represents the ability to manifest dreams into reality."
    $emoo = ("john", x.happy_em)
    $renpy.show (emoo)
    john "Well, what do you know? That sounds good to me!"
    show patty a_9
    patty "Oh Kiyoshi, you little devil. You already knew that, didn't you?"
    john "That may have influenced my decision."
    show patty a_10
    patty "No matter. You know what's about to happen here, so there's no use in delaying further."
    show patty a_3
    patty "Behold my card's power!"
    if johnwins == False:
        morph begin magic john zoey casual a_6
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_7
        kiyoshi "Aww, nuts. I forgot an important detail."
        show john a_4
        kiyoshi "I lost."
        show patty a_2
        patty "And yet, I still transformed you anyway."
        show patty a_9
        patty "Aren't I a generous dealer?"
        show john a_3
        john "Hmph. Very funny."
        show patty a_11
        patty "Will you not beg for mercy? For me to set things right?"
        show john a_2
        john "A loss is a loss. I'm not happy with the result, but I accept my fate."
        show john a_1
        john "It's all part of the rush. No pain, no gain!"
        show patty a_2
        patty "I underestimated you, Kiyoshi. You've been a worthy adversary."
        patty "Alas, I must go. Your judgement has been delivered, and it is final."
        show patty a_1
        patty "I have a feeling you may enjoy it more than you think. In an odd way."
        hide patty
        play sound sfx_spell
        show john a_0
        think "Finally, I've been united with Kiyoshi!"
        show john a_1
        think "Between your memories and my subconscious, we'll be one big happy body!"
        show john a_5
        think "Ah, no, get away from me!"
        show john a_7
        think "Uh, Earth to Kiyoshi. You are me."
        outfit john swimsuit
        show john b_2
        think "Now come on. I can't wait to show you the rest of my body!"
        show john b_5
        think "Eep! No! I can't look!"
        "END - Me, Myself, and Zoey"
    if johnwins:
        morph begin magic john sayaka casual a_7
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_27
        show patty a_2
        patty "How do you feel? Is it everything that you could have hoped for?"
        show john a_28
        john "I'm Sayaka."
        show patty a_5
        patty "Well, yes, but why don't we take a moment to discuss the nature of your—"
        show john a_29:
            linear 1 xpos 1.5 #John (well, Kiyoshi) will run across the screen and then some for one second.
        john "I'm Sayaka!"
        #Kiyoshi runs out the door.
        show patty a_6
        patty "...transformation."
        show patty a_2
        patty "Oh well, I'll let the new Sayaka have her fun."
        show patty a_11
        patty "I'm sure everyone else will get a kick out of this as well!"
        hide patty
        play sound sfx_spell
        "Meanwhile..."
        scene bg neighborhood_1 dark with fade
        show john a_2 at right
        show john a_2:
            linear 1 xpos 0.25 #This time, he'll only run 3 quarters of the way and stop.
        outfit irene athletic
        show irene a_23 at center, faceleft
        irene "Look at you, running around like an athlete."
        show irene a_12
        irene "Wanna join me for my evening jog?"
        show john a_29:
            linear 1 xpos -0.5 #And he's off to the races again.
        john "There's no time, Irene. I'm Sayakaaaaa!"
        show irene a_22
        irene "Um, okay. You do you, girl."
        outfit cornelia casual
        scene bg neighborhood_2 dark with fade
        show cornelia a_11 at center
        show john a_2 at right
        show john a_2:
            linear 1 xpos 0.25
        john "I'm Sayakaaaaaa!"
        show cornelia a_13
        cornelia "Yeah, rub it in why don't you?"
        show cornelia a_1
        cornelia "What's got you in such a good mood, anyway?"
        outfit john underwear
        show john a_19
        john "Because I'm Sayaka, baby! Look at me!"
        #kiyoshi strips into her underwear
        show cornelia a_7
        cornelia "Uh, are you sure you don't wanna put those back on?"
        show john a_2:
            linear 1 xpos -0.5
        john "Woooo!"
        show cornelia a_17
        think "Hah, I should probably stop her."
        show cornelia a_19
        think "You know what? Forget it."
        show cornelia a_18
        think "I've never seen her this...happy."
        clone johnGB audrey #John is already transformed, so we copy his form from Audrey where it's stored.
        outfit johnGB casual #John is already being used, so I use JohnGB for this conversation. Yes, it's confusing.
        $johnGB.name = "John" #JohnGB is successfully transformed into John
        scene bg house_davis exterior night with fade
        show johnGB a_18 at center, faceleft
        show john a_2 at right
        show john a_2:
            linear 1 xpos 0.25
        john "I'm Sayakaaaa!"
        show johnGB a_5
        think "Huh, it looks like Sayaka finally lost her mind. Good riddance."
        show john a_2:
            linear 1 xpos -0.5
        john "Look, John. I'm Sayaka. Wheeee!"
        show johnGB a_4
        think "Wait a second. That's not Sayaka!"
        show johnGB a_18
        think "Kiyoshi?"
        show johnGB a_3
        think "Way to go, champ. You sure can play a mean game of Blackjack."
        scene bg house_sato exterior night with fade
        hide johnGB
        show john a_21 at right
        show john a_21:
            linear 1 xpos 0.5
        think "Pant. Pant."
        show john a_26
        think "Oh. Oh God. What the hell am I doing? Everyone's gonna think I'm some sort of lunatic pervent."
        show john a_19
        think "And they might be right."
        show john a_14
        think "I'll dial it back just a teensy bit. Gotta keep up appearances, after all!"
        outfit john casual
        #kiyoshi puts his shirt back on
        show john a_28
        john "I'm Sayaka. Yay!"
        "END - Sayaka Gone Wild"
    jump newgameprompt

label emperorend:
    patty "The Emperor. I Figured you would pick this one. It represents authority."
    $emoo = ("john", x.happy_em)
    $renpy.show (emoo)
    john "Nice! Well, that's a nice consolation prize if you're not going to be my girlfriend."
    show patty a_6
    patty "I'm going to ignore this girlfriend talk."
    patty "Again."
    $emoo = ("john", x.sad_em)
    $renpy.show (emoo)
    john "Don't tell me you're not interested!"
    show patty a_3
    patty "Enough! My cards shall do my talking. Witness their power!"
    if johnwins:
        morph begin magic john sandra suit a_23
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_13
        riley "Huh? I can't say this is what I expected, but I feel way more popular already!"
        show patty a_2
        patty "That's quite true, Ms. Sandra Davis."
        show john a_20
        riley "You did NOT just turn me into Ms. Davis."
        show patty a_9
        patty "Incorrect."
        show john a_22
        john "Oh, come on! I just wanted to be cool. And maybe respected. This isn't what I wanted at all!"
        show patty a_10
        patty "Cool and respected? Yeah, that sounds like Ms. Davis, alright. Lucky you, huh?"
        show john a_12
        john "Lucky? I don't want to be a mom! I don't want to be middle-aged. I don't think I even want to be a teacher."
        show patty a_1
        patty "Is that so? Perhaps in your new form, you'll change your mind."
        show patty a_9
        patty "Plus, with Ms. Winters around, you might even be able to get a girlfriend."
        show john a_8
        john "You're joking. Sandra doesn't even swing that way, does she?"
        show patty a_11
        patty "You shall find out soon enough!"
        show patty a_10
        patty "In the meantime, enjoy my card's judgement, for it is final. Farewell, Ms. Davis."
        hide patty
        play sound sfx_spell
        show john a_20
        john "Wonderful. And to think I wanted this strange girl to be my girlfriend."
        outfit leona suit
        show leona a_10 at right, faceleft
        leona "Heya, hot stuff. Quit day dreaming and get teaching! Being late isn't very sexy, you know!"
        show john a_0
        john "Don't worry Leona, I'll be right on your ass in a sec!"
        show john a_8
        think "What in the hell is this? Whatever it is, I think I might like it after all..."
        scene bg school hallway_1 day with fade
        show john b_0 blush at center, faceright
        show leona b_1 at centerright, faceleft
        "END - The Cool Teacher"
    if johnwins == False:
        morph begin magic john rileyGB uniform a_3
        play sound sfx_spell
        morph do john
        morph finish john
        show john a_4
        john "What? What's going on? Am I...popular?"
        show patty a_10
        patty "Well, you lost, so the cards decided to drain you of any authority you had."
        show patty a_9
        patty "It seems to have had a visible effect on your gender. How do you feel?"
        john "I feel scared and vulernable. Even more than I did before."
        show patty a_0
        patty "I suppose that's only natural."
        show patty a_2
        patty "However, those qualities are often more desirable for women than men. Perhaps this is a blessing in disguise."
        show john a_3
        john "You...think so?"
        show patty a_2
        patty "Yes. You make for a cute girl, Riley. You even have a great girl's name already!"
        show john a_5
        john "Wow, that's so nice of you to say."
        show john a_2
        john "Perhaps you want to be my girlfriend now?"
        show patty blush a_8
        patty "Yes, er, oops, I mean..the cards have, uh, spoken, bye!"
        hide patty
        play sound sfx_spell
        show john a_1
        think "Wow, my new body must be amazing. That gives me an idea..."
        scene bg school lockerroom with fade
        outfit john towel
        outfit genny gym
        show john a_5 blush at center
        show genny b_7 blush at centerright, faceleft
        "END - Riley's Other Half"
    jump newgameprompt

label femalebodyinspector: #This is called when John 'checks out' his current body.
    $emoo = ("john", x.suprise_em, "blush") #Note that the displayable is altered slightly here so that John blushes.
    $renpy.show (emoo)
    if x.name == "johnGB" or x.name == "bradGB" or x.name == "audrey": #John will be confused if transformed into Audrey or genderbent Brad or genderbent John. He doesn't recognize them.
        think "Whoa, check me out! The joker card transformed me into...wait, who am I, exactly?"
    else:
        think "Whoa, check me out! The joker card transformed me into [x.name.capitalize()]!" #Not only can we call a variable during dialogue, but we can use Python's built in functions to capitalize them!
    $emoo = ("john", x.happy_em, "blush")
    $renpy.show (emoo)
    if firsttime and x.name != "carrie" and x.name != "cornelia": #John is tired of being Cornelia and isn't attracted to Carrie. So sad!
        think "I'll try to resist feeling myself up in the middle of the game."
        $firsttime = False
    $emoo = ("john", x.neutral_em, "blush")
    $renpy.show (emoo)
    if x.name == "johnGB": #Each body is individually checked for. Not the most elegant code, but we need to store the dialogue anyway, right?
        think "Hmm, I feel really familiar. Am I a female version of me?" #Note x.name reads the name from the BlackJackBody class instance.
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "That's...weirdly kind of hot. Unfortunately, that won't really affect my Blackjack game."
        think "I wonder what people would call me. Maybe June?"
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Just as long as nobody calls me Jane. What a generic name that would be... "
    elif x.name == "audrey": #We use else if statements because there's no need to check further ones once the correct name is found.
        $emoo = ("john", x.suprise_em, "blush")
        $renpy.show (emoo)
        think "I swear, I feel really familiar. But, I just can't put a face or name to this body."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "I guess that means I'm really average. In a good way, though!"
        think "My cards should be happily in the middle just like me. When I hit, I wouldn't expect to see cards above 9 or below 5."
        $emoo = ("john", x.suprise_em, "blush")
        $renpy.show (emoo)
        think "Wait, that means I won't get any aces, either. Ah, the perils of mediocrity..."
    elif x.name == "sadie":
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "It's gonna take some doin' just to resist thinkin' in her southern accent."
        $emoo = ("john", x.neutral_em, "blush")
        $renpy.show (emoo)
        think "Okay, I think I got it. Anyways, Sadie's from the south so she prefers southern rules."
        think "They like sharing down there, like in Osaklahold'em Poker."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "So, ya think Patty'll let me borrow a copy o' her face-down card for Blackjack?"
        think "It ain't cheatin' or nothin', just some good ol' southern hospitality!"
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Oops, there's that accent again. Gotta focus so I don't sound like a goof."
    elif x.name == "bradGB":
        think "Hmm, I feel really familiar. I don't recognize the body, though, just the vibe."
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Whoever this is, she feels really insecure. Is it about her height?"
        think "Who knows? Whatever it is, her body makes me want to play recklessly to compensate."
        $emoo = ("john", x.neutral_em, "blush")
        $renpy.show (emoo)
        think "My cards will count for more points now. I better be careful not to bust!"
    elif x.name == "setsuna":
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "Interesting, I feel so relaxed and tranquil in this body!"
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "On second thought, that might just be fatigue. Poor Setsuna has that sickness to deal with."
        think "I better take it easy as her. That means no raising or counter-raising."
    elif x.name == "izuna":
        think "Whoever I am, it feels like I'm looking for a fight. Or, a duel, more specifically."
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "I won't be able to play a a regular game of Blackjack like this."
        $emoo = ("john", x.neutral_em, "blush")
        $renpy.show (emoo)
        think "We'll be dealt cards automatically until we reach 21 or bust."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "May the best woman win!"
    elif x.name == "flavia":
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "This is amazing! What more could a guy dream of?"
        think "I even feel super fast and fit. Somehow, I think this will even translate to my Blackjack."
        think "Yes, I think I'll have a headstart of 1 point. Time to get some Blackjacks!"
    elif x.name == "mel":
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "Her attitude is really contagious! I feel super pumped!"
        $emoo = ("john", x.neutral_em, "blush")
        $renpy.show (emoo)
        think "People say she's more of an endurance swimmer, so I'll factor that into her playstyle."
        think "I'll give Patty 2 of my points to start each hand. That way I can outlast her by getting her to bust."
    elif x.name == "sayaka":
        think "Anyway, I feel a strong attachment to Sayaka's body."
        think "Obviously, she's really hot, but it's like a supernatural sensation."
        think "I could probably stay in this body for as long as I want. Would that really be a good idea, though?"
    elif x.name == "kyoko":
        think "Being Kyoko could be advantageous. She's a card shark."
        think "I've heard she's even practiced counting cards and memorizing the deck's contents."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "That sounds really handy. I can't wait to try her out!"
    elif x.name == "allison":
        think "Allison is a bit of a klutz, but people can't help but love her anyway."
        think "Maybe if I make a mistake in her body, Patty will take pity on me and let me win."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "That could really come in handy if I bust. Time to jam that {q}hit{/q} button!"
    elif x.name == "maria":
        think "Maria has a reputation for having a wandering eye. She see's a lot of stuff that she shouldn't."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "That kind of skill is perfect for a game like this!"
        $emoo = ("john", x.neutral_em, "blush")
        $renpy.show (emoo)
        think "I'll just try to restrict myself to doing it once per hand. I don't want to rouse any suspicion."
    elif x.name == "charlotte":
        think "Huh, I didn't think I recognized myself, but my intuition told me I'm a fashion enthusiast named Charlotte."
        think "What does fashion have anything to do with Blackjack? Maybe nothing."
        think "Though, perhaps her way of thinking can help me swing the Joker transformations in my favor. I'll try to focus the next time I see one!"
    elif x.name == "katrina":
        think "Awkward! I wonder how she would feel about me having such an intimate experience with her body?"
        think "Weird as this is, I actually feel a little luckier in this body than in my old one."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "I guess that's just the power of positive thinking!"
    elif x.name == "yui":
        think "Huh, so I'm in Yui's body. I don't feel any smarter, though. I wonder how this will affect my Blackjack game?"
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "Maybe I'll draw more Aces because she gets a lot of A's."
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Wait, is that actually her ability? Wow, what a cheesy gag."
    elif x.name == "cassie":
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "Just being in Cassie's body makes me feel richer!"
        think "I'll be able to bet even more money than before. That way I can win the game quickly!"
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Though, maybe it would be best if I don't take any foolish risks. I could LOSE quickly if I'm not careful..."
    elif x.name == "mina":
        think "I don't know much about Mina, but she does seem to stick around her sister, Phila."
        think "In the Blackjack world, maybe that means she tends to draw lots of pairs."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "I won't be able to draw Blackjacks, but getting double face cards more often could be nice!"
    elif x.name == "cornelia":
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Uh oh, I have a feeling Cornelia isn't the best Blackjack player."
        think "I feel less confident while in her body. I might not even be able to {q}hit{/q} even when I should."
        think "This could be bad. I better not raise the stakes unless my starting hand is strong."
    elif x.name == "irene":
        think "I feel lost in the clouds with Irene's height."
        think "For some reason, I feel like her Blackjack game will play out the same way."
        think "I probably won't be able to draw lower than a 6. On the flip side, I should draw 6's more often."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "Maybe I can use this to my advantage somehow."
    elif x.name == "zoey":
        think "I feel so little in Zoey's body. It's kind of scary!"
        think "Unfortunately that might be bad for Blackjack. I can't imagine her drawing any cards larger than 8."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "On second thought, I should draw {q}8{/q} cards much more frequently now. Maybe I can use that to my advantage somehow."
    elif x.name == "vanessa":
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Oh no, Vanessa has that legendary temper. That could be really bad for Blackjack."
        think "If Patty raises me when I don't want her to, I might be forced to raise her back."
        think "Hopefully I can resist that urge..."
    elif x.name == "tori":
        $emoo = ("john", x.suprise_em, "blush")
        $renpy.show (emoo)
        think "I would've thought Tori was great at Blackjack, but something feels off."
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Her inner moxie might be pulling my strings. I don't think I could back down from a fight while in this body."
        think "That means no folding. Hopefully I don't draw any lousy hands..."
    elif x.name == "phila":
        think "So, Phila's one of the twins. She's always with Mina, but it feels like she's the one in charge."
        think "Perhaps with her intensity, I'll be able to manipulate my opponent's face-down cards to become a copy of one mine."
        think "That could make for some awkward situations, but at least I'll have a good idea of what my opponent's cards are."
    elif x.name == "michelle":
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "Oh, no no no. I have nothing against Michelle but she REALLY needs her glasses to see correctly."
        think "This is bad. I'm going to have no idea what my face-down card is until after I {q}hit{/q} or {q}stand{/q}."
        $emoo = ("john", x.neutral_em, "blush")
        $renpy.show (emoo)
        think "Maybe if I squint, I'll be able to at least make an educated guess?"
    elif x.name == "rita":
        think "Ah yes, I can tell I'm a boxer. Though, not because Rita's a boxer. I just feel a sudden urge to hit something."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "These face-down cards look pretty punchable. I'll aim for the ones that are lower scoring."
        $emoo = ("john", x.neutral_em, "blush")
        $renpy.show (emoo)
        think "That should provide me some invaluable info, though it might be awkward to decide whether to {q}raise{/q} with fewer cards on the table."
    elif x.name == "carrie":
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "On second thought, this is actually kind of terrifying."
        think "My blood is already boiling just thinking about my former body. Creepy!"
        think "This will definitely affect my Blackjack game. I'll end up using {q}hit{/q} on any hand below a 17. Hopefully I don't bust..."
    elif x.name == "patty":
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "Hmm, getting in the head of the dealer should be really helpful for this."
        $emoo = ("john", x.suprise_em, "blush")
        $renpy.show (emoo)
        think "Wait, I can sense her face-down card. Does she realize I'm able to do that?!"
        show patty a_8
        patty "I see that look on that face! You better not be having any perverted thoughts while in my body!"
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "Wow, she doesn't know. This is gonna be good!"
        show patty a_0
    elif x.name == "anuja":
        think "Anuja a student from a foreign country, so she's not too familiar with Blackjack."
        $emoo = ("john", x.sad_em, "blush")
        $renpy.show (emoo)
        think "She hasn't played Blackjack before, so she has trouble evaluating her opponent's cards."
        $emoo = ("john", x.happy_em, "blush")
        $renpy.show (emoo)
        think "Maybe Patty will take pity let her trade hands. I guess you would call that a foreign exchange? Oof, sorry, that's a bad one."
    return

label johncheat: #This is the Johncheat bad ending.
    play music bgm_waltz_tschikovsky_op_40
    show john a_11
    john "Gah, why can't I move?!"
    show patty a_3
    patty "My cards have frozen your body in place. Your intentions were obvious. They do not take kindly to cheaters."
    show john a_4
    john "Sorry, I'll behave, I'll behave."
    show patty a_5
    patty "I accept your apology."
    show john a_9
    john "Phew, I appreciate that."
    show patty a_4
    patty "However, the cards do not. They have new plans for you."
    show john a_4
    john "What? Gah!"
    morph begin magic john audrey casual a_7
    play sound sfx_spell
    morph do john
    morph finish john
    show john a_4
    john "Ah, who am I, and why?"
    show patty a_10
    patty "Just a little friend of a friend, if you didn't realize."
    john "Oh, is that so?"
    show john a_5
    john "This doesn't sound so bad. I thought you were going to kill me."
    show patty a_2
    patty "The cards were still impressed by your skill, after all. You won before even a single Joker was dealt."
    show patty a_1
    patty "So, instead of granting you their bounty, they decided to grant you a most mediocre and forgettable existence, instead."
    show john a_6
    john "Mediocre? That doesn't sound so bad. Just a rude choice of words."
    show patty a_9
    patty "Ah, I suppose considering your previous form, that insult hits a bit close to home, huh?"
    show john a_8
    john "Are you calling me mediocre and forgettable? I'll have you know I totally have main character energy!"
    patty "If you say so. The cards have delivered their judgement, and it is final. Farewell."
    hide patty
    play sound sfx_spell
    show john a_4
    john "Well, that went wonderfully. I'd complain, but I guess I deserved this in a weird way."
    show john a_5
    john "Might as well find out who I am now. Let's see if I can find her ID."
    show john a_3
    john "Audrey, huh?"
    show john a_6
    john "Who the hell is Audrey?"
    "END - John Cheats Himself"
    if "johnthecheater" not in persistent.specialend:
        $persistent.specialend.append("johnthecheater")
    jump newgameprompt

label fullsayaka: #This is the Sayaka secret ending.
    show john a_6
    john "..."
    show patty a_7
    patty "Uh, earth to John? Are you there? We're kind of in the middle of a game here?"
    hide screen cardone #Since we're jumping straight from gameplay, we still need to hide all of the gameplay screens.
    hide screen cardtwo
    hide screen cardthree
    hide screen cardfour
    hide screen cardfive
    hide screen cardsix
    hide screen cardseven
    hide screen ccardone
    hide screen ccardtwo
    hide screen ccardthree
    hide screen ccardfour
    hide screen ccardfive
    hide screen ccardsix
    hide screen ccardseven
    hide screen gamestatus
    play music bgm_waltz_tschikovsky_op_40
    show john a_26
    john "Who are you calling John, you little witch?"
    show john a_1
    john "I'll have you know I'm Ms. Sayaka Sato in the flesh, and expect to be addressed as such."
    show patty a_8
    patty "Oh no, I knew I should've intervened earlier. The cards were not supposed to do that."
    show john a_21
    john "What are you going on about?"
    show john a_19
    john "Bah, forget it. I'm outta here. Cornelia's waiting. Later, loser."
    hide john
    think "A most unexpected outcome. The card's magic has not only overwritten John's personality, it has transferred his very existence into Sayaka's."
    show patty a_4
    think "Is this good? Is this bad? Sayaka lives a priveleged life, but I can't imagine it as one John wanted as his own."
    show patty a_5
    think "Whatever the case. It seems the cards have casted their judgement. However surprising, it is still final."
    show patty a_0
    think "Now, time to find my next wayward soul. There are so many more troubled people in this world that desire intervention."
    hide patty
    play sound sfx_spell
    if "nevergo" not in persistent.specialend:
        $persistent.specialend.append("nevergo")
    "END - Never Go Full Sayaka"
    jump newgameprompt
